// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * When included in a receipt rule, this action adds a header to the received email.
 *
 * For information about adding a header using a receipt rule, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-add-header.html).
 */
public class AddHeaderAction private constructor(builder: Builder) {
    /**
     * The name of the header to add to the incoming message. The name must contain at least one character, and can contain up to 50 characters. It consists of alphanumeric (a–z, A–Z, 0–9) characters and dashes.
     */
    public val headerName: kotlin.String = requireNotNull(builder.headerName) { "A non-null value must be provided for headerName" }
    /**
     * The content to include in the header. This value can contain up to 2048 characters. It can't contain newline (`\n`) or carriage return (`\r`) characters.
     */
    public val headerValue: kotlin.String = requireNotNull(builder.headerValue) { "A non-null value must be provided for headerValue" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.AddHeaderAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AddHeaderAction(")
        append("headerName=$headerName,")
        append("headerValue=$headerValue")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = headerName.hashCode()
        result = 31 * result + (headerValue.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AddHeaderAction

        if (headerName != other.headerName) return false
        if (headerValue != other.headerValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.AddHeaderAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the header to add to the incoming message. The name must contain at least one character, and can contain up to 50 characters. It consists of alphanumeric (a–z, A–Z, 0–9) characters and dashes.
         */
        public var headerName: kotlin.String? = null
        /**
         * The content to include in the header. This value can contain up to 2048 characters. It can't contain newline (`\n`) or carriage return (`\r`) characters.
         */
        public var headerValue: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.AddHeaderAction) : this() {
            this.headerName = x.headerName
            this.headerValue = x.headerValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.AddHeaderAction = AddHeaderAction(this)

        internal fun correctErrors(): Builder {
            if (headerName == null) headerName = ""
            if (headerValue == null) headerValue = ""
            return this
        }
    }
}
