// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.ses.auth.SesAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.ses.auth.SesIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.ses.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.ses.model.*
import aws.sdk.kotlin.services.ses.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.middleware.MutateHeaders
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultSesClient(override val config: SesClient.Config) : SesClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = SesIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "ses")
        }
        toMap()
    }
    private val authSchemeAdapter = SesAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.ses"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Creates a receipt rule set by cloning an existing one. All receipt rules and configurations are copied to the new receipt rule set and are completely independent of the source rule set.
     *
     * For information about setting up rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html#receiving-email-concepts-rules).
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.CloneReceiptRuleSet.sample
     */
    override suspend fun cloneReceiptRuleSet(input: CloneReceiptRuleSetRequest): CloneReceiptRuleSetResponse {
        val op = SdkHttpOperation.build<CloneReceiptRuleSetRequest, CloneReceiptRuleSetResponse> {
            serializer = CloneReceiptRuleSetOperationSerializer()
            deserializer = CloneReceiptRuleSetOperationDeserializer()
            operationName = "CloneReceiptRuleSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a configuration set.
     *
     * Configuration sets enable you to publish email sending events. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun createConfigurationSet(input: CreateConfigurationSetRequest): CreateConfigurationSetResponse {
        val op = SdkHttpOperation.build<CreateConfigurationSetRequest, CreateConfigurationSetResponse> {
            serializer = CreateConfigurationSetOperationSerializer()
            deserializer = CreateConfigurationSetOperationDeserializer()
            operationName = "CreateConfigurationSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a configuration set event destination.
     *
     * When you create or update an event destination, you must provide one, and only one, destination. The destination can be CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).
     *
     * An event destination is the Amazon Web Services service to which Amazon SES publishes the email sending events associated with a configuration set. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun createConfigurationSetEventDestination(input: CreateConfigurationSetEventDestinationRequest): CreateConfigurationSetEventDestinationResponse {
        val op = SdkHttpOperation.build<CreateConfigurationSetEventDestinationRequest, CreateConfigurationSetEventDestinationResponse> {
            serializer = CreateConfigurationSetEventDestinationOperationSerializer()
            deserializer = CreateConfigurationSetEventDestinationOperationDeserializer()
            operationName = "CreateConfigurationSetEventDestination"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an association between a configuration set and a custom domain for open and click event tracking.
     *
     * By default, images and links used for tracking open and click events are hosted on domains operated by Amazon SES. You can configure a subdomain of your own to handle these events. For information about using custom domains, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/configure-custom-open-click-domains.html).
     */
    override suspend fun createConfigurationSetTrackingOptions(input: CreateConfigurationSetTrackingOptionsRequest): CreateConfigurationSetTrackingOptionsResponse {
        val op = SdkHttpOperation.build<CreateConfigurationSetTrackingOptionsRequest, CreateConfigurationSetTrackingOptionsResponse> {
            serializer = CreateConfigurationSetTrackingOptionsOperationSerializer()
            deserializer = CreateConfigurationSetTrackingOptionsOperationDeserializer()
            operationName = "CreateConfigurationSetTrackingOptions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new custom verification email template.
     *
     * For more information about custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom) in the *Amazon SES Developer Guide*.
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun createCustomVerificationEmailTemplate(input: CreateCustomVerificationEmailTemplateRequest): CreateCustomVerificationEmailTemplateResponse {
        val op = SdkHttpOperation.build<CreateCustomVerificationEmailTemplateRequest, CreateCustomVerificationEmailTemplateResponse> {
            serializer = CreateCustomVerificationEmailTemplateOperationSerializer()
            deserializer = CreateCustomVerificationEmailTemplateOperationDeserializer()
            operationName = "CreateCustomVerificationEmailTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new IP address filter.
     *
     * For information about setting up IP address filters, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-ip-filtering-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.CreateReceiptFilter.sample
     */
    override suspend fun createReceiptFilter(input: CreateReceiptFilterRequest): CreateReceiptFilterResponse {
        val op = SdkHttpOperation.build<CreateReceiptFilterRequest, CreateReceiptFilterResponse> {
            serializer = CreateReceiptFilterOperationSerializer()
            deserializer = CreateReceiptFilterOperationDeserializer()
            operationName = "CreateReceiptFilter"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a receipt rule.
     *
     * For information about setting up receipt rules, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.CreateReceiptRule.sample
     */
    override suspend fun createReceiptRule(input: CreateReceiptRuleRequest): CreateReceiptRuleResponse {
        val op = SdkHttpOperation.build<CreateReceiptRuleRequest, CreateReceiptRuleResponse> {
            serializer = CreateReceiptRuleOperationSerializer()
            deserializer = CreateReceiptRuleOperationDeserializer()
            operationName = "CreateReceiptRule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an empty receipt rule set.
     *
     * For information about setting up receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html#receiving-email-concepts-rules).
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.CreateReceiptRuleSet.sample
     */
    override suspend fun createReceiptRuleSet(input: CreateReceiptRuleSetRequest): CreateReceiptRuleSetResponse {
        val op = SdkHttpOperation.build<CreateReceiptRuleSetRequest, CreateReceiptRuleSetResponse> {
            serializer = CreateReceiptRuleSetOperationSerializer()
            deserializer = CreateReceiptRuleSetOperationDeserializer()
            operationName = "CreateReceiptRuleSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an email template. Email templates enable you to send personalized email to one or more destinations in a single operation. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-personalized-email-api.html).
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun createTemplate(input: CreateTemplateRequest): CreateTemplateResponse {
        val op = SdkHttpOperation.build<CreateTemplateRequest, CreateTemplateResponse> {
            serializer = CreateTemplateOperationSerializer()
            deserializer = CreateTemplateOperationDeserializer()
            operationName = "CreateTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a configuration set. Configuration sets enable you to publish email sending events. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun deleteConfigurationSet(input: DeleteConfigurationSetRequest): DeleteConfigurationSetResponse {
        val op = SdkHttpOperation.build<DeleteConfigurationSetRequest, DeleteConfigurationSetResponse> {
            serializer = DeleteConfigurationSetOperationSerializer()
            deserializer = DeleteConfigurationSetOperationDeserializer()
            operationName = "DeleteConfigurationSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a configuration set event destination. Configuration set event destinations are associated with configuration sets, which enable you to publish email sending events. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun deleteConfigurationSetEventDestination(input: DeleteConfigurationSetEventDestinationRequest): DeleteConfigurationSetEventDestinationResponse {
        val op = SdkHttpOperation.build<DeleteConfigurationSetEventDestinationRequest, DeleteConfigurationSetEventDestinationResponse> {
            serializer = DeleteConfigurationSetEventDestinationOperationSerializer()
            deserializer = DeleteConfigurationSetEventDestinationOperationDeserializer()
            operationName = "DeleteConfigurationSetEventDestination"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an association between a configuration set and a custom domain for open and click event tracking.
     *
     * By default, images and links used for tracking open and click events are hosted on domains operated by Amazon SES. You can configure a subdomain of your own to handle these events. For information about using custom domains, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/configure-custom-open-click-domains.html).
     *
     * Deleting this kind of association results in emails sent using the specified configuration set to capture open and click events using the standard, Amazon SES-operated domains.
     */
    override suspend fun deleteConfigurationSetTrackingOptions(input: DeleteConfigurationSetTrackingOptionsRequest): DeleteConfigurationSetTrackingOptionsResponse {
        val op = SdkHttpOperation.build<DeleteConfigurationSetTrackingOptionsRequest, DeleteConfigurationSetTrackingOptionsResponse> {
            serializer = DeleteConfigurationSetTrackingOptionsOperationSerializer()
            deserializer = DeleteConfigurationSetTrackingOptionsOperationDeserializer()
            operationName = "DeleteConfigurationSetTrackingOptions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing custom verification email template.
     *
     * For more information about custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom) in the *Amazon SES Developer Guide*.
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun deleteCustomVerificationEmailTemplate(input: DeleteCustomVerificationEmailTemplateRequest): DeleteCustomVerificationEmailTemplateResponse {
        val op = SdkHttpOperation.build<DeleteCustomVerificationEmailTemplateRequest, DeleteCustomVerificationEmailTemplateResponse> {
            serializer = DeleteCustomVerificationEmailTemplateOperationSerializer()
            deserializer = DeleteCustomVerificationEmailTemplateOperationDeserializer()
            operationName = "DeleteCustomVerificationEmailTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified identity (an email address or a domain) from the list of verified identities.
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.DeleteIdentity.sample
     */
    override suspend fun deleteIdentity(input: DeleteIdentityRequest): DeleteIdentityResponse {
        val op = SdkHttpOperation.build<DeleteIdentityRequest, DeleteIdentityResponse> {
            serializer = DeleteIdentityOperationSerializer()
            deserializer = DeleteIdentityOperationDeserializer()
            operationName = "DeleteIdentity"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified sending authorization policy for the given identity (an email address or a domain). This operation returns successfully even if a policy with the specified name does not exist.
     *
     * This operation is for the identity owner only. If you have not verified the identity, it returns an error.
     *
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.DeleteIdentityPolicy.sample
     */
    override suspend fun deleteIdentityPolicy(input: DeleteIdentityPolicyRequest): DeleteIdentityPolicyResponse {
        val op = SdkHttpOperation.build<DeleteIdentityPolicyRequest, DeleteIdentityPolicyResponse> {
            serializer = DeleteIdentityPolicyOperationSerializer()
            deserializer = DeleteIdentityPolicyOperationDeserializer()
            operationName = "DeleteIdentityPolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified IP address filter.
     *
     * For information about managing IP address filters, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-ip-filtering-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.DeleteReceiptFilter.sample
     */
    override suspend fun deleteReceiptFilter(input: DeleteReceiptFilterRequest): DeleteReceiptFilterResponse {
        val op = SdkHttpOperation.build<DeleteReceiptFilterRequest, DeleteReceiptFilterResponse> {
            serializer = DeleteReceiptFilterOperationSerializer()
            deserializer = DeleteReceiptFilterOperationDeserializer()
            operationName = "DeleteReceiptFilter"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified receipt rule.
     *
     * For information about managing receipt rules, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.DeleteReceiptRule.sample
     */
    override suspend fun deleteReceiptRule(input: DeleteReceiptRuleRequest): DeleteReceiptRuleResponse {
        val op = SdkHttpOperation.build<DeleteReceiptRuleRequest, DeleteReceiptRuleResponse> {
            serializer = DeleteReceiptRuleOperationSerializer()
            deserializer = DeleteReceiptRuleOperationDeserializer()
            operationName = "DeleteReceiptRule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified receipt rule set and all of the receipt rules it contains.
     *
     * The currently active rule set cannot be deleted.
     *
     * For information about managing receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.DeleteReceiptRuleSet.sample
     */
    override suspend fun deleteReceiptRuleSet(input: DeleteReceiptRuleSetRequest): DeleteReceiptRuleSetResponse {
        val op = SdkHttpOperation.build<DeleteReceiptRuleSetRequest, DeleteReceiptRuleSetResponse> {
            serializer = DeleteReceiptRuleSetOperationSerializer()
            deserializer = DeleteReceiptRuleSetOperationDeserializer()
            operationName = "DeleteReceiptRuleSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an email template.
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun deleteTemplate(input: DeleteTemplateRequest): DeleteTemplateResponse {
        val op = SdkHttpOperation.build<DeleteTemplateRequest, DeleteTemplateResponse> {
            serializer = DeleteTemplateOperationSerializer()
            deserializer = DeleteTemplateOperationDeserializer()
            operationName = "DeleteTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deprecated. Use the `DeleteIdentity` operation to delete email addresses and domains.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.DeleteVerifiedEmailAddress.sample
     */
    override suspend fun deleteVerifiedEmailAddress(input: DeleteVerifiedEmailAddressRequest): DeleteVerifiedEmailAddressResponse {
        val op = SdkHttpOperation.build<DeleteVerifiedEmailAddressRequest, DeleteVerifiedEmailAddressResponse> {
            serializer = DeleteVerifiedEmailAddressOperationSerializer()
            deserializer = DeleteVerifiedEmailAddressOperationDeserializer()
            operationName = "DeleteVerifiedEmailAddress"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the metadata and receipt rules for the receipt rule set that is currently active.
     *
     * For information about setting up receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html#receiving-email-concepts-rules).
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.DescribeActiveReceiptRuleSet.sample
     */
    override suspend fun describeActiveReceiptRuleSet(input: DescribeActiveReceiptRuleSetRequest): DescribeActiveReceiptRuleSetResponse {
        val op = SdkHttpOperation.build<DescribeActiveReceiptRuleSetRequest, DescribeActiveReceiptRuleSetResponse> {
            serializer = DescribeActiveReceiptRuleSetOperationSerializer()
            deserializer = DescribeActiveReceiptRuleSetOperationDeserializer()
            operationName = "DescribeActiveReceiptRuleSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the details of the specified configuration set. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun describeConfigurationSet(input: DescribeConfigurationSetRequest): DescribeConfigurationSetResponse {
        val op = SdkHttpOperation.build<DescribeConfigurationSetRequest, DescribeConfigurationSetResponse> {
            serializer = DescribeConfigurationSetOperationSerializer()
            deserializer = DescribeConfigurationSetOperationDeserializer()
            operationName = "DescribeConfigurationSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the details of the specified receipt rule.
     *
     * For information about setting up receipt rules, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.DescribeReceiptRule.sample
     */
    override suspend fun describeReceiptRule(input: DescribeReceiptRuleRequest): DescribeReceiptRuleResponse {
        val op = SdkHttpOperation.build<DescribeReceiptRuleRequest, DescribeReceiptRuleResponse> {
            serializer = DescribeReceiptRuleOperationSerializer()
            deserializer = DescribeReceiptRuleOperationDeserializer()
            operationName = "DescribeReceiptRule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the details of the specified receipt rule set.
     *
     * For information about managing receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.DescribeReceiptRuleSet.sample
     */
    override suspend fun describeReceiptRuleSet(input: DescribeReceiptRuleSetRequest): DescribeReceiptRuleSetResponse {
        val op = SdkHttpOperation.build<DescribeReceiptRuleSetRequest, DescribeReceiptRuleSetResponse> {
            serializer = DescribeReceiptRuleSetOperationSerializer()
            deserializer = DescribeReceiptRuleSetOperationDeserializer()
            operationName = "DescribeReceiptRuleSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the email sending status of the Amazon SES account for the current Region.
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.GetAccountSendingEnabled.sample
     */
    override suspend fun getAccountSendingEnabled(input: GetAccountSendingEnabledRequest): GetAccountSendingEnabledResponse {
        val op = SdkHttpOperation.build<GetAccountSendingEnabledRequest, GetAccountSendingEnabledResponse> {
            serializer = GetAccountSendingEnabledOperationSerializer()
            deserializer = GetAccountSendingEnabledOperationDeserializer()
            operationName = "GetAccountSendingEnabled"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the custom email verification template for the template name you specify.
     *
     * For more information about custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom) in the *Amazon SES Developer Guide*.
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun getCustomVerificationEmailTemplate(input: GetCustomVerificationEmailTemplateRequest): GetCustomVerificationEmailTemplateResponse {
        val op = SdkHttpOperation.build<GetCustomVerificationEmailTemplateRequest, GetCustomVerificationEmailTemplateResponse> {
            serializer = GetCustomVerificationEmailTemplateOperationSerializer()
            deserializer = GetCustomVerificationEmailTemplateOperationDeserializer()
            operationName = "GetCustomVerificationEmailTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the current status of Easy DKIM signing for an entity. For domain name identities, this operation also returns the DKIM tokens that are required for Easy DKIM signing, and whether Amazon SES has successfully verified that these tokens have been published.
     *
     * This operation takes a list of identities as input and returns the following information for each:
     * + Whether Easy DKIM signing is enabled or disabled.
     * + A set of DKIM tokens that represent the identity. If the identity is an email address, the tokens represent the domain of that address.
     * + Whether Amazon SES has successfully verified the DKIM tokens published in the domain's DNS. This information is only returned for domain name identities, not for email addresses.
     *
     * This operation is throttled at one request per second and can only get DKIM attributes for up to 100 identities at a time.
     *
     * For more information about creating DNS records using DKIM tokens, go to the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy-managing.html).
     *
     * @sample aws.sdk.kotlin.services.ses.samples.GetIdentityDkimAttributes.sample
     */
    override suspend fun getIdentityDkimAttributes(input: GetIdentityDkimAttributesRequest): GetIdentityDkimAttributesResponse {
        val op = SdkHttpOperation.build<GetIdentityDkimAttributesRequest, GetIdentityDkimAttributesResponse> {
            serializer = GetIdentityDkimAttributesOperationSerializer()
            deserializer = GetIdentityDkimAttributesOperationDeserializer()
            operationName = "GetIdentityDkimAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the custom MAIL FROM attributes for a list of identities (email addresses : domains).
     *
     * This operation is throttled at one request per second and can only get custom MAIL FROM attributes for up to 100 identities at a time.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.GetIdentityMailFromDomainAttributes.sample
     */
    override suspend fun getIdentityMailFromDomainAttributes(input: GetIdentityMailFromDomainAttributesRequest): GetIdentityMailFromDomainAttributesResponse {
        val op = SdkHttpOperation.build<GetIdentityMailFromDomainAttributesRequest, GetIdentityMailFromDomainAttributesResponse> {
            serializer = GetIdentityMailFromDomainAttributesOperationSerializer()
            deserializer = GetIdentityMailFromDomainAttributesOperationDeserializer()
            operationName = "GetIdentityMailFromDomainAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Given a list of verified identities (email addresses and/or domains), returns a structure describing identity notification attributes.
     *
     * This operation is throttled at one request per second and can only get notification attributes for up to 100 identities at a time.
     *
     * For more information about using notifications with Amazon SES, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications.html).
     *
     * @sample aws.sdk.kotlin.services.ses.samples.GetIdentityNotificationAttributes.sample
     */
    override suspend fun getIdentityNotificationAttributes(input: GetIdentityNotificationAttributesRequest): GetIdentityNotificationAttributesResponse {
        val op = SdkHttpOperation.build<GetIdentityNotificationAttributesRequest, GetIdentityNotificationAttributesResponse> {
            serializer = GetIdentityNotificationAttributesOperationSerializer()
            deserializer = GetIdentityNotificationAttributesOperationDeserializer()
            operationName = "GetIdentityNotificationAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the requested sending authorization policies for the given identity (an email address or a domain). The policies are returned as a map of policy names to policy contents. You can retrieve a maximum of 20 policies at a time.
     *
     * This operation is for the identity owner only. If you have not verified the identity, it returns an error.
     *
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.GetIdentityPolicies.sample
     */
    override suspend fun getIdentityPolicies(input: GetIdentityPoliciesRequest): GetIdentityPoliciesResponse {
        val op = SdkHttpOperation.build<GetIdentityPoliciesRequest, GetIdentityPoliciesResponse> {
            serializer = GetIdentityPoliciesOperationSerializer()
            deserializer = GetIdentityPoliciesOperationDeserializer()
            operationName = "GetIdentityPolicies"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Given a list of identities (email addresses and/or domains), returns the verification status and (for domain identities) the verification token for each identity.
     *
     * The verification status of an email address is "Pending" until the email address owner clicks the link within the verification email that Amazon SES sent to that address. If the email address owner clicks the link within 24 hours, the verification status of the email address changes to "Success". If the link is not clicked within 24 hours, the verification status changes to "Failed." In that case, to verify the email address, you must restart the verification process from the beginning.
     *
     * For domain identities, the domain's verification status is "Pending" as Amazon SES searches for the required TXT record in the DNS settings of the domain. When Amazon SES detects the record, the domain's verification status changes to "Success". If Amazon SES is unable to detect the record within 72 hours, the domain's verification status changes to "Failed." In that case, to verify the domain, you must restart the verification process from the beginning.
     *
     * This operation is throttled at one request per second and can only get verification attributes for up to 100 identities at a time.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.GetIdentityVerificationAttributes.sample
     */
    override suspend fun getIdentityVerificationAttributes(input: GetIdentityVerificationAttributesRequest): GetIdentityVerificationAttributesResponse {
        val op = SdkHttpOperation.build<GetIdentityVerificationAttributesRequest, GetIdentityVerificationAttributesResponse> {
            serializer = GetIdentityVerificationAttributesOperationSerializer()
            deserializer = GetIdentityVerificationAttributesOperationDeserializer()
            operationName = "GetIdentityVerificationAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides the sending limits for the Amazon SES account.
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.GetSendQuota.sample
     */
    override suspend fun getSendQuota(input: GetSendQuotaRequest): GetSendQuotaResponse {
        val op = SdkHttpOperation.build<GetSendQuotaRequest, GetSendQuotaResponse> {
            serializer = GetSendQuotaOperationSerializer()
            deserializer = GetSendQuotaOperationDeserializer()
            operationName = "GetSendQuota"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides sending statistics for the current Amazon Web Services Region. The result is a list of data points, representing the last two weeks of sending activity. Each data point in the list contains statistics for a 15-minute period of time.
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.GetSendStatistics.sample
     */
    override suspend fun getSendStatistics(input: GetSendStatisticsRequest): GetSendStatisticsResponse {
        val op = SdkHttpOperation.build<GetSendStatisticsRequest, GetSendStatisticsResponse> {
            serializer = GetSendStatisticsOperationSerializer()
            deserializer = GetSendStatisticsOperationDeserializer()
            operationName = "GetSendStatistics"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Displays the template object (which includes the Subject line, HTML part and text part) for the template you specify.
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun getTemplate(input: GetTemplateRequest): GetTemplateResponse {
        val op = SdkHttpOperation.build<GetTemplateRequest, GetTemplateResponse> {
            serializer = GetTemplateOperationSerializer()
            deserializer = GetTemplateOperationDeserializer()
            operationName = "GetTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides a list of the configuration sets associated with your Amazon SES account in the current Amazon Web Services Region. For information about using configuration sets, see [Monitoring Your Amazon SES Sending Activity](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html) in the *Amazon SES Developer Guide.*
     *
     * You can execute this operation no more than once per second. This operation returns up to 1,000 configuration sets each time it is run. If your Amazon SES account has more than 1,000 configuration sets, this operation also returns `NextToken`. You can then execute the `ListConfigurationSets` operation again, passing the `NextToken` parameter and the value of the NextToken element to retrieve additional results.
     */
    override suspend fun listConfigurationSets(input: ListConfigurationSetsRequest): ListConfigurationSetsResponse {
        val op = SdkHttpOperation.build<ListConfigurationSetsRequest, ListConfigurationSetsResponse> {
            serializer = ListConfigurationSetsOperationSerializer()
            deserializer = ListConfigurationSetsOperationDeserializer()
            operationName = "ListConfigurationSets"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the existing custom verification email templates for your account in the current Amazon Web Services Region.
     *
     * For more information about custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom) in the *Amazon SES Developer Guide*.
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun listCustomVerificationEmailTemplates(input: ListCustomVerificationEmailTemplatesRequest): ListCustomVerificationEmailTemplatesResponse {
        val op = SdkHttpOperation.build<ListCustomVerificationEmailTemplatesRequest, ListCustomVerificationEmailTemplatesResponse> {
            serializer = ListCustomVerificationEmailTemplatesOperationSerializer()
            deserializer = ListCustomVerificationEmailTemplatesOperationDeserializer()
            operationName = "ListCustomVerificationEmailTemplates"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list containing all of the identities (email addresses and domains) for your Amazon Web Services account in the current Amazon Web Services Region, regardless of verification status.
     *
     * You can execute this operation no more than once per second.
     *
     * It's recommended that for successive pagination calls of this API, you continue to the use the same parameter/value pairs as used in the original call, e.g., if you used `IdentityType=Domain` in the the original call and received a `NextToken` in the response, you should continue providing the `IdentityType=Domain` parameter for further `NextToken` calls; however, if you didn't provide the `IdentityType` parameter in the original call, then continue to not provide it for successive pagination calls. Using this protocol will ensure consistent results.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.ListIdentities.sample
     */
    override suspend fun listIdentities(input: ListIdentitiesRequest): ListIdentitiesResponse {
        val op = SdkHttpOperation.build<ListIdentitiesRequest, ListIdentitiesResponse> {
            serializer = ListIdentitiesOperationSerializer()
            deserializer = ListIdentitiesOperationDeserializer()
            operationName = "ListIdentities"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of sending authorization policies that are attached to the given identity (an email address or a domain). This operation returns only a list. To get the actual policy content, use `GetIdentityPolicies`.
     *
     * This operation is for the identity owner only. If you have not verified the identity, it returns an error.
     *
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.ListIdentityPolicies.sample
     */
    override suspend fun listIdentityPolicies(input: ListIdentityPoliciesRequest): ListIdentityPoliciesResponse {
        val op = SdkHttpOperation.build<ListIdentityPoliciesRequest, ListIdentityPoliciesResponse> {
            serializer = ListIdentityPoliciesOperationSerializer()
            deserializer = ListIdentityPoliciesOperationDeserializer()
            operationName = "ListIdentityPolicies"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the IP address filters associated with your Amazon Web Services account in the current Amazon Web Services Region.
     *
     * For information about managing IP address filters, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-ip-filtering-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.ListReceiptFilters.sample
     */
    override suspend fun listReceiptFilters(input: ListReceiptFiltersRequest): ListReceiptFiltersResponse {
        val op = SdkHttpOperation.build<ListReceiptFiltersRequest, ListReceiptFiltersResponse> {
            serializer = ListReceiptFiltersOperationSerializer()
            deserializer = ListReceiptFiltersOperationDeserializer()
            operationName = "ListReceiptFilters"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the receipt rule sets that exist under your Amazon Web Services account in the current Amazon Web Services Region. If there are additional receipt rule sets to be retrieved, you receive a `NextToken` that you can provide to the next call to `ListReceiptRuleSets` to retrieve the additional entries.
     *
     * For information about managing receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.ListReceiptRuleSets.sample
     */
    override suspend fun listReceiptRuleSets(input: ListReceiptRuleSetsRequest): ListReceiptRuleSetsResponse {
        val op = SdkHttpOperation.build<ListReceiptRuleSetsRequest, ListReceiptRuleSetsResponse> {
            serializer = ListReceiptRuleSetsOperationSerializer()
            deserializer = ListReceiptRuleSetsOperationDeserializer()
            operationName = "ListReceiptRuleSets"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the email templates present in your Amazon SES account in the current Amazon Web Services Region.
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun listTemplates(input: ListTemplatesRequest): ListTemplatesResponse {
        val op = SdkHttpOperation.build<ListTemplatesRequest, ListTemplatesResponse> {
            serializer = ListTemplatesOperationSerializer()
            deserializer = ListTemplatesOperationDeserializer()
            operationName = "ListTemplates"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deprecated. Use the `ListIdentities` operation to list the email addresses and domains associated with your account.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.ListVerifiedEmailAddresses.sample
     */
    override suspend fun listVerifiedEmailAddresses(input: ListVerifiedEmailAddressesRequest): ListVerifiedEmailAddressesResponse {
        val op = SdkHttpOperation.build<ListVerifiedEmailAddressesRequest, ListVerifiedEmailAddressesResponse> {
            serializer = ListVerifiedEmailAddressesOperationSerializer()
            deserializer = ListVerifiedEmailAddressesOperationDeserializer()
            operationName = "ListVerifiedEmailAddresses"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds or updates the delivery options for a configuration set.
     */
    override suspend fun putConfigurationSetDeliveryOptions(input: PutConfigurationSetDeliveryOptionsRequest): PutConfigurationSetDeliveryOptionsResponse {
        val op = SdkHttpOperation.build<PutConfigurationSetDeliveryOptionsRequest, PutConfigurationSetDeliveryOptionsResponse> {
            serializer = PutConfigurationSetDeliveryOptionsOperationSerializer()
            deserializer = PutConfigurationSetDeliveryOptionsOperationDeserializer()
            operationName = "PutConfigurationSetDeliveryOptions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds or updates a sending authorization policy for the specified identity (an email address or a domain).
     *
     * This operation is for the identity owner only. If you have not verified the identity, it returns an error.
     *
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.PutIdentityPolicy.sample
     */
    override suspend fun putIdentityPolicy(input: PutIdentityPolicyRequest): PutIdentityPolicyResponse {
        val op = SdkHttpOperation.build<PutIdentityPolicyRequest, PutIdentityPolicyResponse> {
            serializer = PutIdentityPolicyOperationSerializer()
            deserializer = PutIdentityPolicyOperationDeserializer()
            operationName = "PutIdentityPolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Reorders the receipt rules within a receipt rule set.
     *
     * All of the rules in the rule set must be represented in this request. That is, it is error if the reorder request doesn't explicitly position all of the rules.
     *
     * For information about managing receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.ReorderReceiptRuleSet.sample
     */
    override suspend fun reorderReceiptRuleSet(input: ReorderReceiptRuleSetRequest): ReorderReceiptRuleSetResponse {
        val op = SdkHttpOperation.build<ReorderReceiptRuleSetRequest, ReorderReceiptRuleSetResponse> {
            serializer = ReorderReceiptRuleSetOperationSerializer()
            deserializer = ReorderReceiptRuleSetOperationDeserializer()
            operationName = "ReorderReceiptRuleSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Generates and sends a bounce message to the sender of an email you received through Amazon SES. You can only use this operation on an email up to 24 hours after you receive it.
     *
     * You cannot use this operation to send generic bounces for mail that was not received by Amazon SES.
     *
     * For information about receiving email through Amazon SES, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email.html).
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun sendBounce(input: SendBounceRequest): SendBounceResponse {
        val op = SdkHttpOperation.build<SendBounceRequest, SendBounceResponse> {
            serializer = SendBounceOperationSerializer()
            deserializer = SendBounceOperationDeserializer()
            operationName = "SendBounce"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Composes an email message to multiple destinations. The message body is created using an email template.
     *
     * To send email using this operation, your call must meet the following requirements:
     * + The call must refer to an existing email template. You can create email templates using CreateTemplate.
     * + The message must be sent from a verified email address or domain.
     * + If your account is still in the Amazon SES sandbox, you may send only to verified addresses or domains, or to email addresses associated with the Amazon SES Mailbox Simulator. For more information, see [Verifying Email Addresses and Domains](https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html) in the *Amazon SES Developer Guide.*
     * + The maximum message size is 10 MB.
     * + Each `Destination` parameter must include at least one recipient email address. The recipient address can be a To: address, a CC: address, or a BCC: address. If a recipient email address is invalid (that is, it is not in the format *UserName@&#91;SubDomain.&#93;Domain.TopLevelDomain*), the entire message is rejected, even if the message contains other recipients that are valid.
     * + The message may not include more than 50 recipients, across the To:, CC: and BCC: fields. If you need to send an email message to a larger audience, you can divide your recipient list into groups of 50 or fewer, and then call the `SendBulkTemplatedEmail` operation several times to send the message to each group.
     * + The number of destinations you can contact in a single call can be limited by your account's maximum sending rate.
     */
    override suspend fun sendBulkTemplatedEmail(input: SendBulkTemplatedEmailRequest): SendBulkTemplatedEmailResponse {
        val op = SdkHttpOperation.build<SendBulkTemplatedEmailRequest, SendBulkTemplatedEmailResponse> {
            serializer = SendBulkTemplatedEmailOperationSerializer()
            deserializer = SendBulkTemplatedEmailOperationDeserializer()
            operationName = "SendBulkTemplatedEmail"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds an email address to the list of identities for your Amazon SES account in the current Amazon Web Services Region and attempts to verify it. As a result of executing this operation, a customized verification email is sent to the specified address.
     *
     * To use this operation, you must first create a custom verification email template. For more information about creating and using custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom) in the *Amazon SES Developer Guide*.
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun sendCustomVerificationEmail(input: SendCustomVerificationEmailRequest): SendCustomVerificationEmailResponse {
        val op = SdkHttpOperation.build<SendCustomVerificationEmailRequest, SendCustomVerificationEmailResponse> {
            serializer = SendCustomVerificationEmailOperationSerializer()
            deserializer = SendCustomVerificationEmailOperationDeserializer()
            operationName = "SendCustomVerificationEmail"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Composes an email message and immediately queues it for sending. To send email using this operation, your message must meet the following requirements:
     * + The message must be sent from a verified email address or domain. If you attempt to send email using a non-verified address or domain, the operation results in an "Email address not verified" error.
     * + If your account is still in the Amazon SES sandbox, you may only send to verified addresses or domains, or to email addresses associated with the Amazon SES Mailbox Simulator. For more information, see [Verifying Email Addresses and Domains](https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html) in the *Amazon SES Developer Guide.*
     * + The maximum message size is 10 MB.
     * + The message must include at least one recipient email address. The recipient address can be a To: address, a CC: address, or a BCC: address. If a recipient email address is invalid (that is, it is not in the format *UserName@&#91;SubDomain.&#93;Domain.TopLevelDomain*), the entire message is rejected, even if the message contains other recipients that are valid.
     * + The message may not include more than 50 recipients, across the To:, CC: and BCC: fields. If you need to send an email message to a larger audience, you can divide your recipient list into groups of 50 or fewer, and then call the `SendEmail` operation several times to send the message to each group.
     *
     * For every message that you send, the total number of recipients (including each recipient in the To:, CC: and BCC: fields) is counted against the maximum number of emails you can send in a 24-hour period (your *sending quota*). For more information about sending quotas in Amazon SES, see [Managing Your Amazon SES Sending Limits](https://docs.aws.amazon.com/ses/latest/dg/manage-sending-quotas.html) in the *Amazon SES Developer Guide.*
     *
     * @sample aws.sdk.kotlin.services.ses.samples.SendEmail.sample
     */
    override suspend fun sendEmail(input: SendEmailRequest): SendEmailResponse {
        val op = SdkHttpOperation.build<SendEmailRequest, SendEmailResponse> {
            serializer = SendEmailOperationSerializer()
            deserializer = SendEmailOperationDeserializer()
            operationName = "SendEmail"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Composes an email message and immediately queues it for sending.
     *
     * This operation is more flexible than the `SendEmail` operation. When you use the `SendRawEmail` operation, you can specify the headers of the message as well as its content. This flexibility is useful, for example, when you need to send a multipart MIME email (such a message that contains both a text and an HTML version). You can also use this operation to send messages that include attachments.
     *
     * The `SendRawEmail` operation has the following requirements:
     * + You can only send email from [verified email addresses or domains](https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html). If you try to send email from an address that isn't verified, the operation results in an "Email address not verified" error.
     * + If your account is still in the [Amazon SES sandbox](https://docs.aws.amazon.com/ses/latest/dg/request-production-access.html), you can only send email to other verified addresses in your account, or to addresses that are associated with the [Amazon SES mailbox simulator](https://docs.aws.amazon.com/ses/latest/dg/send-an-email-from-console.html).
     * + The maximum message size, including attachments, is 10 MB.
     * + Each message has to include at least one recipient address. A recipient address includes any address on the To:, CC:, or BCC: lines.
     * + If you send a single message to more than one recipient address, and one of the recipient addresses isn't in a valid format (that is, it's not in the format *UserName@&#91;SubDomain.&#93;Domain.TopLevelDomain*), Amazon SES rejects the entire message, even if the other addresses are valid.
     * + Each message can include up to 50 recipient addresses across the To:, CC:, or BCC: lines. If you need to send a single message to more than 50 recipients, you have to split the list of recipient addresses into groups of less than 50 recipients, and send separate messages to each group.
     * + Amazon SES allows you to specify 8-bit Content-Transfer-Encoding for MIME message parts. However, if Amazon SES has to modify the contents of your message (for example, if you use open and click tracking), 8-bit content isn't preserved. For this reason, we highly recommend that you encode all content that isn't 7-bit ASCII. For more information, see [MIME Encoding](https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html#send-email-mime-encoding) in the *Amazon SES Developer Guide*.
     *
     * Additionally, keep the following considerations in mind when using the `SendRawEmail` operation:
     * + Although you can customize the message headers when using the `SendRawEmail` operation, Amazon SES automatically applies its own `Message-ID` and `Date` headers; if you passed these headers when creating the message, they are overwritten by the values that Amazon SES provides.
     * + If you are using sending authorization to send on behalf of another user, `SendRawEmail` enables you to specify the cross-account identity for the email's Source, From, and Return-Path parameters in one of two ways: you can pass optional parameters `SourceArn`, `FromArn`, and/or `ReturnPathArn`, or you can include the following X-headers in the header of your raw email:
     *    + `X-SES-SOURCE-ARN`
     *    + `X-SES-FROM-ARN`
     *    + `X-SES-RETURN-PATH-ARN`
     * Don't include these X-headers in the DKIM signature. Amazon SES removes these before it sends the email.If you only specify the `SourceIdentityArn` parameter, Amazon SES sets the From and Return-Path addresses to the same identity that you specified.For more information about sending authorization, see the [Using Sending Authorization with Amazon SES](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html) in the *Amazon SES Developer Guide.*
     * + For every message that you send, the total number of recipients (including each recipient in the To:, CC: and BCC: fields) is counted against the maximum number of emails you can send in a 24-hour period (your *sending quota*). For more information about sending quotas in Amazon SES, see [Managing Your Amazon SES Sending Limits](https://docs.aws.amazon.com/ses/latest/dg/manage-sending-quotas.html) in the *Amazon SES Developer Guide.*
     *
     * @sample aws.sdk.kotlin.services.ses.samples.SendRawEmail.sample
     */
    override suspend fun sendRawEmail(input: SendRawEmailRequest): SendRawEmailResponse {
        val op = SdkHttpOperation.build<SendRawEmailRequest, SendRawEmailResponse> {
            serializer = SendRawEmailOperationSerializer()
            deserializer = SendRawEmailOperationDeserializer()
            operationName = "SendRawEmail"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Composes an email message using an email template and immediately queues it for sending.
     *
     * To send email using this operation, your call must meet the following requirements:
     * + The call must refer to an existing email template. You can create email templates using the CreateTemplate operation.
     * + The message must be sent from a verified email address or domain.
     * + If your account is still in the Amazon SES sandbox, you may only send to verified addresses or domains, or to email addresses associated with the Amazon SES Mailbox Simulator. For more information, see [Verifying Email Addresses and Domains](https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html) in the *Amazon SES Developer Guide.*
     * + The maximum message size is 10 MB.
     * + Calls to the `SendTemplatedEmail` operation may only include one `Destination` parameter. A destination is a set of recipients that receives the same version of the email. The `Destination` parameter can include up to 50 recipients, across the To:, CC: and BCC: fields.
     * + The `Destination` parameter must include at least one recipient email address. The recipient address can be a To: address, a CC: address, or a BCC: address. If a recipient email address is invalid (that is, it is not in the format *UserName@&#91;SubDomain.&#93;Domain.TopLevelDomain*), the entire message is rejected, even if the message contains other recipients that are valid.
     *
     * If your call to the `SendTemplatedEmail` operation includes all of the required parameters, Amazon SES accepts it and returns a Message ID. However, if Amazon SES can't render the email because the template contains errors, it doesn't send the email. Additionally, because it already accepted the message, Amazon SES doesn't return a message stating that it was unable to send the email.
     *
     * For these reasons, we highly recommend that you set up Amazon SES to send you notifications when Rendering Failure events occur. For more information, see [Sending Personalized Email Using the Amazon SES API](https://docs.aws.amazon.com/ses/latest/dg/send-personalized-email-api.html) in the *Amazon Simple Email Service Developer Guide*.
     */
    override suspend fun sendTemplatedEmail(input: SendTemplatedEmailRequest): SendTemplatedEmailResponse {
        val op = SdkHttpOperation.build<SendTemplatedEmailRequest, SendTemplatedEmailResponse> {
            serializer = SendTemplatedEmailOperationSerializer()
            deserializer = SendTemplatedEmailOperationDeserializer()
            operationName = "SendTemplatedEmail"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sets the specified receipt rule set as the active receipt rule set.
     *
     * To disable your email-receiving through Amazon SES completely, you can call this operation with `RuleSetName` set to null.
     *
     * For information about managing receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.SetActiveReceiptRuleSet.sample
     */
    override suspend fun setActiveReceiptRuleSet(input: SetActiveReceiptRuleSetRequest): SetActiveReceiptRuleSetResponse {
        val op = SdkHttpOperation.build<SetActiveReceiptRuleSetRequest, SetActiveReceiptRuleSetResponse> {
            serializer = SetActiveReceiptRuleSetOperationSerializer()
            deserializer = SetActiveReceiptRuleSetOperationDeserializer()
            operationName = "SetActiveReceiptRuleSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables or disables Easy DKIM signing of email sent from an identity. If Easy DKIM signing is enabled for a domain, then Amazon SES uses DKIM to sign all email that it sends from addresses on that domain. If Easy DKIM signing is enabled for an email address, then Amazon SES uses DKIM to sign all email it sends from that address.
     *
     * For email addresses (for example, `user@example.com`), you can only enable DKIM signing if the corresponding domain (in this case, `example.com`) has been set up to use Easy DKIM.
     *
     * You can enable DKIM signing for an identity at any time after you start the verification process for the identity, even if the verification process isn't complete.
     *
     * You can execute this operation no more than once per second.
     *
     * For more information about Easy DKIM signing, go to the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
     *
     * @sample aws.sdk.kotlin.services.ses.samples.SetIdentityDkimEnabled.sample
     */
    override suspend fun setIdentityDkimEnabled(input: SetIdentityDkimEnabledRequest): SetIdentityDkimEnabledResponse {
        val op = SdkHttpOperation.build<SetIdentityDkimEnabledRequest, SetIdentityDkimEnabledResponse> {
            serializer = SetIdentityDkimEnabledOperationSerializer()
            deserializer = SetIdentityDkimEnabledOperationDeserializer()
            operationName = "SetIdentityDkimEnabled"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Given an identity (an email address or a domain), enables or disables whether Amazon SES forwards bounce and complaint notifications as email. Feedback forwarding can only be disabled when Amazon Simple Notification Service (Amazon SNS) topics are specified for both bounces and complaints.
     *
     * Feedback forwarding does not apply to delivery notifications. Delivery notifications are only available through Amazon SNS.
     *
     * You can execute this operation no more than once per second.
     *
     * For more information about using notifications with Amazon SES, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications.html).
     *
     * @sample aws.sdk.kotlin.services.ses.samples.SetIdentityFeedbackForwardingEnabled.sample
     */
    override suspend fun setIdentityFeedbackForwardingEnabled(input: SetIdentityFeedbackForwardingEnabledRequest): SetIdentityFeedbackForwardingEnabledResponse {
        val op = SdkHttpOperation.build<SetIdentityFeedbackForwardingEnabledRequest, SetIdentityFeedbackForwardingEnabledResponse> {
            serializer = SetIdentityFeedbackForwardingEnabledOperationSerializer()
            deserializer = SetIdentityFeedbackForwardingEnabledOperationDeserializer()
            operationName = "SetIdentityFeedbackForwardingEnabled"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Given an identity (an email address or a domain), sets whether Amazon SES includes the original email headers in the Amazon Simple Notification Service (Amazon SNS) notifications of a specified type.
     *
     * You can execute this operation no more than once per second.
     *
     * For more information about using notifications with Amazon SES, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications.html).
     *
     * @sample aws.sdk.kotlin.services.ses.samples.SetIdentityHeadersInNotificationsEnabled.sample
     */
    override suspend fun setIdentityHeadersInNotificationsEnabled(input: SetIdentityHeadersInNotificationsEnabledRequest): SetIdentityHeadersInNotificationsEnabledResponse {
        val op = SdkHttpOperation.build<SetIdentityHeadersInNotificationsEnabledRequest, SetIdentityHeadersInNotificationsEnabledResponse> {
            serializer = SetIdentityHeadersInNotificationsEnabledOperationSerializer()
            deserializer = SetIdentityHeadersInNotificationsEnabledOperationDeserializer()
            operationName = "SetIdentityHeadersInNotificationsEnabled"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables or disables the custom MAIL FROM domain setup for a verified identity (an email address or a domain).
     *
     * To send emails using the specified MAIL FROM domain, you must add an MX record to your MAIL FROM domain's DNS settings. To ensure that your emails pass Sender Policy Framework (SPF) checks, you must also add or update an SPF record. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/mail-from.html).
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.SetIdentityMailFromDomain.sample
     */
    override suspend fun setIdentityMailFromDomain(input: SetIdentityMailFromDomainRequest): SetIdentityMailFromDomainResponse {
        val op = SdkHttpOperation.build<SetIdentityMailFromDomainRequest, SetIdentityMailFromDomainResponse> {
            serializer = SetIdentityMailFromDomainOperationSerializer()
            deserializer = SetIdentityMailFromDomainOperationDeserializer()
            operationName = "SetIdentityMailFromDomain"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sets an Amazon Simple Notification Service (Amazon SNS) topic to use when delivering notifications. When you use this operation, you specify a verified identity, such as an email address or domain. When you send an email that uses the chosen identity in the Source field, Amazon SES sends notifications to the topic you specified. You can send bounce, complaint, or delivery notifications (or any combination of the three) to the Amazon SNS topic that you specify.
     *
     * You can execute this operation no more than once per second.
     *
     * For more information about feedback notification, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications.html).
     *
     * @sample aws.sdk.kotlin.services.ses.samples.SetIdentityNotificationTopic.sample
     */
    override suspend fun setIdentityNotificationTopic(input: SetIdentityNotificationTopicRequest): SetIdentityNotificationTopicResponse {
        val op = SdkHttpOperation.build<SetIdentityNotificationTopicRequest, SetIdentityNotificationTopicResponse> {
            serializer = SetIdentityNotificationTopicOperationSerializer()
            deserializer = SetIdentityNotificationTopicOperationDeserializer()
            operationName = "SetIdentityNotificationTopic"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sets the position of the specified receipt rule in the receipt rule set.
     *
     * For information about managing receipt rules, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.SetReceiptRulePosition.sample
     */
    override suspend fun setReceiptRulePosition(input: SetReceiptRulePositionRequest): SetReceiptRulePositionResponse {
        val op = SdkHttpOperation.build<SetReceiptRulePositionRequest, SetReceiptRulePositionResponse> {
            serializer = SetReceiptRulePositionOperationSerializer()
            deserializer = SetReceiptRulePositionOperationDeserializer()
            operationName = "SetReceiptRulePosition"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a preview of the MIME content of an email when provided with a template and a set of replacement data.
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun testRenderTemplate(input: TestRenderTemplateRequest): TestRenderTemplateResponse {
        val op = SdkHttpOperation.build<TestRenderTemplateRequest, TestRenderTemplateResponse> {
            serializer = TestRenderTemplateOperationSerializer()
            deserializer = TestRenderTemplateOperationDeserializer()
            operationName = "TestRenderTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables or disables email sending across your entire Amazon SES account in the current Amazon Web Services Region. You can use this operation in conjunction with Amazon CloudWatch alarms to temporarily pause email sending across your Amazon SES account in a given Amazon Web Services Region when reputation metrics (such as your bounce or complaint rates) reach certain thresholds.
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.UpdateAccountSendingEnabled.sample
     */
    override suspend fun updateAccountSendingEnabled(input: UpdateAccountSendingEnabledRequest): UpdateAccountSendingEnabledResponse {
        val op = SdkHttpOperation.build<UpdateAccountSendingEnabledRequest, UpdateAccountSendingEnabledResponse> {
            serializer = UpdateAccountSendingEnabledOperationSerializer()
            deserializer = UpdateAccountSendingEnabledOperationDeserializer()
            operationName = "UpdateAccountSendingEnabled"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the event destination of a configuration set. Event destinations are associated with configuration sets, which enable you to publish email sending events to Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS). For information about using configuration sets, see [Monitoring Your Amazon SES Sending Activity](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html) in the *Amazon SES Developer Guide.*
     *
     * When you create or update an event destination, you must provide one, and only one, destination. The destination can be Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun updateConfigurationSetEventDestination(input: UpdateConfigurationSetEventDestinationRequest): UpdateConfigurationSetEventDestinationResponse {
        val op = SdkHttpOperation.build<UpdateConfigurationSetEventDestinationRequest, UpdateConfigurationSetEventDestinationResponse> {
            serializer = UpdateConfigurationSetEventDestinationOperationSerializer()
            deserializer = UpdateConfigurationSetEventDestinationOperationDeserializer()
            operationName = "UpdateConfigurationSetEventDestination"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables or disables the publishing of reputation metrics for emails sent using a specific configuration set in a given Amazon Web Services Region. Reputation metrics include bounce and complaint rates. These metrics are published to Amazon CloudWatch. By using CloudWatch, you can create alarms when bounce or complaint rates exceed certain thresholds.
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.UpdateConfigurationSetReputationMetricsEnabled.sample
     */
    override suspend fun updateConfigurationSetReputationMetricsEnabled(input: UpdateConfigurationSetReputationMetricsEnabledRequest): UpdateConfigurationSetReputationMetricsEnabledResponse {
        val op = SdkHttpOperation.build<UpdateConfigurationSetReputationMetricsEnabledRequest, UpdateConfigurationSetReputationMetricsEnabledResponse> {
            serializer = UpdateConfigurationSetReputationMetricsEnabledOperationSerializer()
            deserializer = UpdateConfigurationSetReputationMetricsEnabledOperationDeserializer()
            operationName = "UpdateConfigurationSetReputationMetricsEnabled"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables or disables email sending for messages sent using a specific configuration set in a given Amazon Web Services Region. You can use this operation in conjunction with Amazon CloudWatch alarms to temporarily pause email sending for a configuration set when the reputation metrics for that configuration set (such as your bounce on complaint rate) exceed certain thresholds.
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.UpdateConfigurationSetSendingEnabled.sample
     */
    override suspend fun updateConfigurationSetSendingEnabled(input: UpdateConfigurationSetSendingEnabledRequest): UpdateConfigurationSetSendingEnabledResponse {
        val op = SdkHttpOperation.build<UpdateConfigurationSetSendingEnabledRequest, UpdateConfigurationSetSendingEnabledResponse> {
            serializer = UpdateConfigurationSetSendingEnabledOperationSerializer()
            deserializer = UpdateConfigurationSetSendingEnabledOperationDeserializer()
            operationName = "UpdateConfigurationSetSendingEnabled"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies an association between a configuration set and a custom domain for open and click event tracking.
     *
     * By default, images and links used for tracking open and click events are hosted on domains operated by Amazon SES. You can configure a subdomain of your own to handle these events. For information about using custom domains, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/configure-custom-open-click-domains.html).
     */
    override suspend fun updateConfigurationSetTrackingOptions(input: UpdateConfigurationSetTrackingOptionsRequest): UpdateConfigurationSetTrackingOptionsResponse {
        val op = SdkHttpOperation.build<UpdateConfigurationSetTrackingOptionsRequest, UpdateConfigurationSetTrackingOptionsResponse> {
            serializer = UpdateConfigurationSetTrackingOptionsOperationSerializer()
            deserializer = UpdateConfigurationSetTrackingOptionsOperationDeserializer()
            operationName = "UpdateConfigurationSetTrackingOptions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing custom verification email template.
     *
     * For more information about custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom) in the *Amazon SES Developer Guide*.
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun updateCustomVerificationEmailTemplate(input: UpdateCustomVerificationEmailTemplateRequest): UpdateCustomVerificationEmailTemplateResponse {
        val op = SdkHttpOperation.build<UpdateCustomVerificationEmailTemplateRequest, UpdateCustomVerificationEmailTemplateResponse> {
            serializer = UpdateCustomVerificationEmailTemplateOperationSerializer()
            deserializer = UpdateCustomVerificationEmailTemplateOperationDeserializer()
            operationName = "UpdateCustomVerificationEmailTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a receipt rule.
     *
     * For information about managing receipt rules, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.UpdateReceiptRule.sample
     */
    override suspend fun updateReceiptRule(input: UpdateReceiptRuleRequest): UpdateReceiptRuleResponse {
        val op = SdkHttpOperation.build<UpdateReceiptRuleRequest, UpdateReceiptRuleResponse> {
            serializer = UpdateReceiptRuleOperationSerializer()
            deserializer = UpdateReceiptRuleOperationDeserializer()
            operationName = "UpdateReceiptRule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an email template. Email templates enable you to send personalized email to one or more destinations in a single operation. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-personalized-email-api.html).
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun updateTemplate(input: UpdateTemplateRequest): UpdateTemplateResponse {
        val op = SdkHttpOperation.build<UpdateTemplateRequest, UpdateTemplateResponse> {
            serializer = UpdateTemplateOperationSerializer()
            deserializer = UpdateTemplateOperationDeserializer()
            operationName = "UpdateTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a set of DKIM tokens for a domain identity.
     *
     * When you execute the `VerifyDomainDkim` operation, the domain that you specify is added to the list of identities that are associated with your account. This is true even if you haven't already associated the domain with your account by using the `VerifyDomainIdentity` operation. However, you can't send email from the domain until you either successfully [verify it](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#verify-domain-procedure) or you successfully [set up DKIM for it](https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
     *
     * You use the tokens that are generated by this operation to create CNAME records. When Amazon SES detects that you've added these records to the DNS configuration for a domain, you can start sending email from that domain. You can start sending email even if you haven't added the TXT record provided by the VerifyDomainIdentity operation to the DNS configuration for your domain. All email that you send from the domain is authenticated using DKIM.
     *
     * To create the CNAME records for DKIM authentication, use the following values:
     * + **Name**: *token*._domainkey.*example.com*
     * + **Type**: CNAME
     * + **Value**: *token*.dkim.amazonses.com
     *
     * In the preceding example, replace *token* with one of the tokens that are generated when you execute this operation. Replace *example.com* with your domain. Repeat this process for each token that's generated by this operation.
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.VerifyDomainDkim.sample
     */
    override suspend fun verifyDomainDkim(input: VerifyDomainDkimRequest): VerifyDomainDkimResponse {
        val op = SdkHttpOperation.build<VerifyDomainDkimRequest, VerifyDomainDkimResponse> {
            serializer = VerifyDomainDkimOperationSerializer()
            deserializer = VerifyDomainDkimOperationDeserializer()
            operationName = "VerifyDomainDkim"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a domain to the list of identities for your Amazon SES account in the current Amazon Web Services Region and attempts to verify it. For more information about verifying domains, see [Verifying Email Addresses and Domains](https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html) in the *Amazon SES Developer Guide.*
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.VerifyDomainIdentity.sample
     */
    override suspend fun verifyDomainIdentity(input: VerifyDomainIdentityRequest): VerifyDomainIdentityResponse {
        val op = SdkHttpOperation.build<VerifyDomainIdentityRequest, VerifyDomainIdentityResponse> {
            serializer = VerifyDomainIdentityOperationSerializer()
            deserializer = VerifyDomainIdentityOperationDeserializer()
            operationName = "VerifyDomainIdentity"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deprecated. Use the `VerifyEmailIdentity` operation to verify a new email address.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.VerifyEmailAddress.sample
     */
    override suspend fun verifyEmailAddress(input: VerifyEmailAddressRequest): VerifyEmailAddressResponse {
        val op = SdkHttpOperation.build<VerifyEmailAddressRequest, VerifyEmailAddressResponse> {
            serializer = VerifyEmailAddressOperationSerializer()
            deserializer = VerifyEmailAddressOperationDeserializer()
            operationName = "VerifyEmailAddress"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds an email address to the list of identities for your Amazon SES account in the current Amazon Web Services Region and attempts to verify it. As a result of executing this operation, a verification email is sent to the specified address.
     *
     * You can execute this operation no more than once per second.
     *
     * @sample aws.sdk.kotlin.services.ses.samples.VerifyEmailIdentity.sample
     */
    override suspend fun verifyEmailIdentity(input: VerifyEmailIdentityRequest): VerifyEmailIdentityResponse {
        val op = SdkHttpOperation.build<VerifyEmailIdentityRequest, VerifyEmailIdentityResponse> {
            serializer = VerifyEmailIdentityOperationSerializer()
            deserializer = VerifyEmailIdentityOperationDeserializer()
            operationName = "VerifyEmailIdentity"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(AwsClientOption.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "ses")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
