// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.waiters

import aws.sdk.kotlin.services.ses.SesClient
import aws.sdk.kotlin.services.ses.model.GetIdentityVerificationAttributesRequest
import aws.sdk.kotlin.services.ses.model.GetIdentityVerificationAttributesResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import kotlin.time.Duration.Companion.milliseconds


public suspend fun SesClient.waitUntilIdentityExists(request: GetIdentityVerificationAttributesRequest): Outcome<GetIdentityVerificationAttributesResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 3_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetIdentityVerificationAttributesRequest, GetIdentityVerificationAttributesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val verificationAttributes = it.verificationAttributes
            val verificationAttributesValues = verificationAttributes?.values
            val projection = verificationAttributesValues?.flatMap {
                val verificationStatus = it?.verificationStatus?.value
                listOfNotNull(verificationStatus)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "Success" }
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getIdentityVerificationAttributes(request) }
}

public suspend fun SesClient.waitUntilIdentityExists(block: GetIdentityVerificationAttributesRequest.Builder.() -> Unit): Outcome<GetIdentityVerificationAttributesResponse> =
    waitUntilIdentityExists(GetIdentityVerificationAttributesRequest.Builder().apply(block).build())
