// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.serde

import aws.sdk.kotlin.services.ses.model.SesException
import aws.sdk.kotlin.services.ses.model.UpdateConfigurationSetTrackingOptionsResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateConfigurationSetTrackingOptionsOperationDeserializer: HttpDeserialize<UpdateConfigurationSetTrackingOptionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateConfigurationSetTrackingOptionsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateConfigurationSetTrackingOptionsError(context, call)
        }
        val builder = UpdateConfigurationSetTrackingOptionsResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateConfigurationSetTrackingOptionsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw SesException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConfigurationSetDoesNotExist" -> ConfigurationSetDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidTrackingOptions" -> InvalidTrackingOptionsExceptionDeserializer().deserialize(context, wrappedCall)
        "TrackingOptionsDoesNotExistException" -> TrackingOptionsDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
