// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.serde

import aws.sdk.kotlin.services.ses.model.MessageTag
import aws.sdk.kotlin.services.ses.model.RawMessage
import aws.sdk.kotlin.services.ses.model.SendRawEmailRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SendRawEmailOperationSerializer: HttpSerialize<SendRawEmailRequest> {
    override suspend fun serialize(context: ExecutionContext, input: SendRawEmailRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeSendRawEmailOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeSendRawEmailOperationBody(context: ExecutionContext, input: SendRawEmailRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val CONFIGURATIONSETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ConfigurationSetName"))
    val DESTINATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Destinations"))
    val FROMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("FromArn"))
    val RAWMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("RawMessage"))
    val RETURNPATHARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ReturnPathArn"))
    val SOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Source"))
    val SOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("SourceArn"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("SendRawEmailRequest"))
        trait(QueryLiteral("Action", "SendRawEmail"))
        trait(QueryLiteral("Version", "2010-12-01"))
        field(CONFIGURATIONSETNAME_DESCRIPTOR)
        field(DESTINATIONS_DESCRIPTOR)
        field(FROMARN_DESCRIPTOR)
        field(RAWMESSAGE_DESCRIPTOR)
        field(RETURNPATHARN_DESCRIPTOR)
        field(SOURCE_DESCRIPTOR)
        field(SOURCEARN_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.configurationSetName?.let { field(CONFIGURATIONSETNAME_DESCRIPTOR, it) }
        if (input.destinations != null) {
            listField(DESTINATIONS_DESCRIPTOR) {
                for (el0 in input.destinations) {
                    serializeString(el0)
                }
            }
        }
        input.fromArn?.let { field(FROMARN_DESCRIPTOR, it) }
        input.rawMessage?.let { field(RAWMESSAGE_DESCRIPTOR, it, ::serializeRawMessageDocument) }
        input.returnPathArn?.let { field(RETURNPATHARN_DESCRIPTOR, it) }
        input.source?.let { field(SOURCE_DESCRIPTOR, it) }
        input.sourceArn?.let { field(SOURCEARN_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeMessageTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
