// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.serde

import aws.sdk.kotlin.services.ses.model.Destination
import aws.sdk.kotlin.services.ses.model.Message
import aws.sdk.kotlin.services.ses.model.MessageTag
import aws.sdk.kotlin.services.ses.model.SendEmailRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SendEmailOperationSerializer: HttpSerialize<SendEmailRequest> {
    override suspend fun serialize(context: ExecutionContext, input: SendEmailRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeSendEmailOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeSendEmailOperationBody(context: ExecutionContext, input: SendEmailRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val CONFIGURATIONSETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ConfigurationSetName"))
    val DESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("Destination"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("Message"))
    val REPLYTOADDRESSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("ReplyToAddresses"))
    val RETURNPATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ReturnPath"))
    val RETURNPATHARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ReturnPathArn"))
    val SOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Source"))
    val SOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("SourceArn"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("SendEmailRequest"))
        trait(QueryLiteral("Action", "SendEmail"))
        trait(QueryLiteral("Version", "2010-12-01"))
        field(CONFIGURATIONSETNAME_DESCRIPTOR)
        field(DESTINATION_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(REPLYTOADDRESSES_DESCRIPTOR)
        field(RETURNPATH_DESCRIPTOR)
        field(RETURNPATHARN_DESCRIPTOR)
        field(SOURCE_DESCRIPTOR)
        field(SOURCEARN_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.configurationSetName?.let { field(CONFIGURATIONSETNAME_DESCRIPTOR, it) }
        input.destination?.let { field(DESTINATION_DESCRIPTOR, it, ::serializeDestinationDocument) }
        input.message?.let { field(MESSAGE_DESCRIPTOR, it, ::serializeMessageDocument) }
        if (input.replyToAddresses != null) {
            listField(REPLYTOADDRESSES_DESCRIPTOR) {
                for (el0 in input.replyToAddresses) {
                    serializeString(el0)
                }
            }
        }
        input.returnPath?.let { field(RETURNPATH_DESCRIPTOR, it) }
        input.returnPathArn?.let { field(RETURNPATHARN_DESCRIPTOR, it) }
        input.source?.let { field(SOURCE_DESCRIPTOR, it) }
        input.sourceArn?.let { field(SOURCEARN_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeMessageTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
