// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.serde

import aws.sdk.kotlin.services.ses.model.SendCustomVerificationEmailResponse
import aws.sdk.kotlin.services.ses.model.SesException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class SendCustomVerificationEmailOperationDeserializer: HttpDeserialize<SendCustomVerificationEmailResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): SendCustomVerificationEmailResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSendCustomVerificationEmailError(context, call)
        }
        val builder = SendCustomVerificationEmailResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSendCustomVerificationEmailOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwSendCustomVerificationEmailError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw SesException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConfigurationSetDoesNotExist" -> ConfigurationSetDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "CustomVerificationEmailTemplateDoesNotExist" -> CustomVerificationEmailTemplateDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "FromEmailAddressNotVerified" -> FromEmailAddressNotVerifiedExceptionDeserializer().deserialize(context, wrappedCall)
        "MessageRejected" -> MessageRejectedDeserializer().deserialize(context, wrappedCall)
        "ProductionAccessNotGranted" -> ProductionAccessNotGrantedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSendCustomVerificationEmailOperationBody(builder: SendCustomVerificationEmailResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("SendCustomVerificationEmailResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("SendCustomVerificationEmailResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap SendCustomVerificationEmail response")
    }
    // end unwrap response wrapper

    val MESSAGEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("MessageId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://ses.amazonaws.com/doc/2010-12-01/"))
        trait(XmlSerialName("SendCustomVerificationEmailResult"))
        field(MESSAGEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MESSAGEID_DESCRIPTOR.index -> builder.messageId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
