// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.serde

import aws.sdk.kotlin.services.ses.model.BouncedRecipientInfo
import aws.sdk.kotlin.services.ses.model.MessageDsn
import aws.sdk.kotlin.services.ses.model.SendBounceRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SendBounceOperationSerializer: HttpSerialize<SendBounceRequest> {
    override suspend fun serialize(context: ExecutionContext, input: SendBounceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeSendBounceOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeSendBounceOperationBody(context: ExecutionContext, input: SendBounceRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val BOUNCESENDER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("BounceSender"))
    val BOUNCESENDERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("BounceSenderArn"))
    val BOUNCEDRECIPIENTINFOLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("BouncedRecipientInfoList"))
    val EXPLANATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Explanation"))
    val MESSAGEDSN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("MessageDsn"))
    val ORIGINALMESSAGEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("OriginalMessageId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("SendBounceRequest"))
        trait(QueryLiteral("Action", "SendBounce"))
        trait(QueryLiteral("Version", "2010-12-01"))
        field(BOUNCESENDER_DESCRIPTOR)
        field(BOUNCESENDERARN_DESCRIPTOR)
        field(BOUNCEDRECIPIENTINFOLIST_DESCRIPTOR)
        field(EXPLANATION_DESCRIPTOR)
        field(MESSAGEDSN_DESCRIPTOR)
        field(ORIGINALMESSAGEID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.bounceSender?.let { field(BOUNCESENDER_DESCRIPTOR, it) }
        input.bounceSenderArn?.let { field(BOUNCESENDERARN_DESCRIPTOR, it) }
        if (input.bouncedRecipientInfoList != null) {
            listField(BOUNCEDRECIPIENTINFOLIST_DESCRIPTOR) {
                for (el0 in input.bouncedRecipientInfoList) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeBouncedRecipientInfoDocument))
                }
            }
        }
        input.explanation?.let { field(EXPLANATION_DESCRIPTOR, it) }
        input.messageDsn?.let { field(MESSAGEDSN_DESCRIPTOR, it, ::serializeMessageDsnDocument) }
        input.originalMessageId?.let { field(ORIGINALMESSAGEID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
