// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.serde

import aws.sdk.kotlin.services.ses.model.CreateCustomVerificationEmailTemplateResponse
import aws.sdk.kotlin.services.ses.model.SesException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class CreateCustomVerificationEmailTemplateOperationDeserializer: HttpDeserialize<CreateCustomVerificationEmailTemplateResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateCustomVerificationEmailTemplateResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateCustomVerificationEmailTemplateError(context, call)
        }
        val builder = CreateCustomVerificationEmailTemplateResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateCustomVerificationEmailTemplateError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw SesException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CustomVerificationEmailInvalidContent" -> CustomVerificationEmailInvalidContentExceptionDeserializer().deserialize(context, wrappedCall)
        "CustomVerificationEmailTemplateAlreadyExists" -> CustomVerificationEmailTemplateAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall)
        "FromEmailAddressNotVerified" -> FromEmailAddressNotVerifiedExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceeded" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
