// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Returns a TXT record that you must publish to the DNS server of your domain to complete domain verification with Amazon SES.
 */
public class VerifyDomainIdentityResponse private constructor(builder: Builder) {
    /**
     * A TXT record that you must place in the DNS settings of the domain to complete domain verification with Amazon SES.
     *
     * As Amazon SES searches for the TXT record, the domain's verification status is "Pending". When Amazon SES detects the record, the domain's verification status changes to "Success". If Amazon SES is unable to detect the record within 72 hours, the domain's verification status changes to "Failed." In that case, to verify the domain, you must restart the verification process from the beginning. The domain's verification status also changes to "Success" when it is DKIM verified.
     */
    public val verificationToken: kotlin.String = requireNotNull(builder.verificationToken) { "A non-null value must be provided for verificationToken" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.VerifyDomainIdentityResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VerifyDomainIdentityResponse(")
        append("verificationToken=$verificationToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = verificationToken.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VerifyDomainIdentityResponse

        if (verificationToken != other.verificationToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.VerifyDomainIdentityResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A TXT record that you must place in the DNS settings of the domain to complete domain verification with Amazon SES.
         *
         * As Amazon SES searches for the TXT record, the domain's verification status is "Pending". When Amazon SES detects the record, the domain's verification status changes to "Success". If Amazon SES is unable to detect the record within 72 hours, the domain's verification status changes to "Failed." In that case, to verify the domain, you must restart the verification process from the beginning. The domain's verification status also changes to "Success" when it is DKIM verified.
         */
        public var verificationToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.VerifyDomainIdentityResponse) : this() {
            this.verificationToken = x.verificationToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.VerifyDomainIdentityResponse = VerifyDomainIdentityResponse(this)

        internal fun correctErrors(): Builder {
            if (verificationToken == null) verificationToken = ""
            return this
        }
    }
}
