// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to update a receipt rule. You use receipt rules to receive email with Amazon SES. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html).
 */
public class UpdateReceiptRuleRequest private constructor(builder: Builder) {
    /**
     * A data structure that contains the updated receipt rule information.
     */
    public val rule: aws.sdk.kotlin.services.ses.model.ReceiptRule? = builder.rule
    /**
     * The name of the receipt rule set that the receipt rule belongs to.
     */
    public val ruleSetName: kotlin.String? = builder.ruleSetName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.UpdateReceiptRuleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateReceiptRuleRequest(")
        append("rule=$rule,")
        append("ruleSetName=$ruleSetName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = rule?.hashCode() ?: 0
        result = 31 * result + (ruleSetName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateReceiptRuleRequest

        if (rule != other.rule) return false
        if (ruleSetName != other.ruleSetName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.UpdateReceiptRuleRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A data structure that contains the updated receipt rule information.
         */
        public var rule: aws.sdk.kotlin.services.ses.model.ReceiptRule? = null
        /**
         * The name of the receipt rule set that the receipt rule belongs to.
         */
        public var ruleSetName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.UpdateReceiptRuleRequest) : this() {
            this.rule = x.rule
            this.ruleSetName = x.ruleSetName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.UpdateReceiptRuleRequest = UpdateReceiptRuleRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.ReceiptRule] inside the given [block]
         */
        public fun rule(block: aws.sdk.kotlin.services.ses.model.ReceiptRule.Builder.() -> kotlin.Unit) {
            this.rule = aws.sdk.kotlin.services.ses.model.ReceiptRule.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
