// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to set the position of a receipt rule in a receipt rule set. You use receipt rule sets to receive email with Amazon SES. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html).
 */
public class SetReceiptRulePositionRequest private constructor(builder: Builder) {
    /**
     * The name of the receipt rule after which to place the specified receipt rule.
     */
    public val after: kotlin.String? = builder.after
    /**
     * The name of the receipt rule to reposition.
     */
    public val ruleName: kotlin.String? = builder.ruleName
    /**
     * The name of the receipt rule set that contains the receipt rule to reposition.
     */
    public val ruleSetName: kotlin.String? = builder.ruleSetName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.SetReceiptRulePositionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SetReceiptRulePositionRequest(")
        append("after=$after,")
        append("ruleName=$ruleName,")
        append("ruleSetName=$ruleSetName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = after?.hashCode() ?: 0
        result = 31 * result + (ruleName?.hashCode() ?: 0)
        result = 31 * result + (ruleSetName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SetReceiptRulePositionRequest

        if (after != other.after) return false
        if (ruleName != other.ruleName) return false
        if (ruleSetName != other.ruleSetName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.SetReceiptRulePositionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the receipt rule after which to place the specified receipt rule.
         */
        public var after: kotlin.String? = null
        /**
         * The name of the receipt rule to reposition.
         */
        public var ruleName: kotlin.String? = null
        /**
         * The name of the receipt rule set that contains the receipt rule to reposition.
         */
        public var ruleSetName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.SetReceiptRulePositionRequest) : this() {
            this.after = x.after
            this.ruleName = x.ruleName
            this.ruleSetName = x.ruleSetName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.SetReceiptRulePositionRequest = SetReceiptRulePositionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
