// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to set whether Amazon SES includes the original email headers in the Amazon SNS notifications of a specified type. For information about notifications, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications-sns.html).
 */
public class SetIdentityHeadersInNotificationsEnabledRequest private constructor(builder: Builder) {
    /**
     * Sets whether Amazon SES includes the original email headers in Amazon SNS notifications of the specified notification type. A value of `true` specifies that Amazon SES includes headers in notifications, and a value of `false` specifies that Amazon SES does not include headers in notifications.
     *
     * This value can only be set when `NotificationType` is already set to use a particular Amazon SNS topic.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The identity for which to enable or disable headers in notifications. Examples: `user@example.com`, `example.com`.
     */
    public val identity: kotlin.String? = builder.identity
    /**
     * The notification type for which to enable or disable headers in notifications.
     */
    public val notificationType: aws.sdk.kotlin.services.ses.model.NotificationType? = builder.notificationType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.SetIdentityHeadersInNotificationsEnabledRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SetIdentityHeadersInNotificationsEnabledRequest(")
        append("enabled=$enabled,")
        append("identity=$identity,")
        append("notificationType=$notificationType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (identity?.hashCode() ?: 0)
        result = 31 * result + (notificationType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SetIdentityHeadersInNotificationsEnabledRequest

        if (enabled != other.enabled) return false
        if (identity != other.identity) return false
        if (notificationType != other.notificationType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.SetIdentityHeadersInNotificationsEnabledRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Sets whether Amazon SES includes the original email headers in Amazon SNS notifications of the specified notification type. A value of `true` specifies that Amazon SES includes headers in notifications, and a value of `false` specifies that Amazon SES does not include headers in notifications.
         *
         * This value can only be set when `NotificationType` is already set to use a particular Amazon SNS topic.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The identity for which to enable or disable headers in notifications. Examples: `user@example.com`, `example.com`.
         */
        public var identity: kotlin.String? = null
        /**
         * The notification type for which to enable or disable headers in notifications.
         */
        public var notificationType: aws.sdk.kotlin.services.ses.model.NotificationType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.SetIdentityHeadersInNotificationsEnabledRequest) : this() {
            this.enabled = x.enabled
            this.identity = x.identity
            this.notificationType = x.notificationType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.SetIdentityHeadersInNotificationsEnabledRequest = SetIdentityHeadersInNotificationsEnabledRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
