// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to enable or disable Amazon SES Easy DKIM signing for an identity. For more information about setting up Easy DKIM, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
 */
public class SetIdentityDkimEnabledRequest private constructor(builder: Builder) {
    /**
     * Sets whether DKIM signing is enabled for an identity. Set to `true` to enable DKIM signing for this identity; `false` to disable it.
     */
    public val dkimEnabled: kotlin.Boolean? = builder.dkimEnabled
    /**
     * The identity for which DKIM signing should be enabled or disabled.
     */
    public val identity: kotlin.String? = builder.identity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.SetIdentityDkimEnabledRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SetIdentityDkimEnabledRequest(")
        append("dkimEnabled=$dkimEnabled,")
        append("identity=$identity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dkimEnabled?.hashCode() ?: 0
        result = 31 * result + (identity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SetIdentityDkimEnabledRequest

        if (dkimEnabled != other.dkimEnabled) return false
        if (identity != other.identity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.SetIdentityDkimEnabledRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Sets whether DKIM signing is enabled for an identity. Set to `true` to enable DKIM signing for this identity; `false` to disable it.
         */
        public var dkimEnabled: kotlin.Boolean? = null
        /**
         * The identity for which DKIM signing should be enabled or disabled.
         */
        public var identity: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.SetIdentityDkimEnabledRequest) : this() {
            this.dkimEnabled = x.dkimEnabled
            this.identity = x.identity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.SetIdentityDkimEnabledRequest = SetIdentityDkimEnabledRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
