// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to send a bounce message to the sender of an email you received through Amazon SES.
 */
public class SendBounceRequest private constructor(builder: Builder) {
    /**
     * The address to use in the "From" header of the bounce message. This must be an identity that you have verified with Amazon SES.
     */
    public val bounceSender: kotlin.String? = builder.bounceSender
    /**
     * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the address in the "From" header of the bounce. For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
     */
    public val bounceSenderArn: kotlin.String? = builder.bounceSenderArn
    /**
     * A list of recipients of the bounced message, including the information required to create the Delivery Status Notifications (DSNs) for the recipients. You must specify at least one `BouncedRecipientInfo` in the list.
     */
    public val bouncedRecipientInfoList: List<BouncedRecipientInfo>? = builder.bouncedRecipientInfoList
    /**
     * Human-readable text for the bounce message to explain the failure. If not specified, the text is auto-generated based on the bounced recipient information.
     */
    public val explanation: kotlin.String? = builder.explanation
    /**
     * Message-related DSN fields. If not specified, Amazon SES chooses the values.
     */
    public val messageDsn: aws.sdk.kotlin.services.ses.model.MessageDsn? = builder.messageDsn
    /**
     * The message ID of the message to be bounced.
     */
    public val originalMessageId: kotlin.String? = builder.originalMessageId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.SendBounceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SendBounceRequest(")
        append("bounceSender=$bounceSender,")
        append("bounceSenderArn=$bounceSenderArn,")
        append("bouncedRecipientInfoList=$bouncedRecipientInfoList,")
        append("explanation=$explanation,")
        append("messageDsn=$messageDsn,")
        append("originalMessageId=$originalMessageId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bounceSender?.hashCode() ?: 0
        result = 31 * result + (bounceSenderArn?.hashCode() ?: 0)
        result = 31 * result + (bouncedRecipientInfoList?.hashCode() ?: 0)
        result = 31 * result + (explanation?.hashCode() ?: 0)
        result = 31 * result + (messageDsn?.hashCode() ?: 0)
        result = 31 * result + (originalMessageId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SendBounceRequest

        if (bounceSender != other.bounceSender) return false
        if (bounceSenderArn != other.bounceSenderArn) return false
        if (bouncedRecipientInfoList != other.bouncedRecipientInfoList) return false
        if (explanation != other.explanation) return false
        if (messageDsn != other.messageDsn) return false
        if (originalMessageId != other.originalMessageId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.SendBounceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The address to use in the "From" header of the bounce message. This must be an identity that you have verified with Amazon SES.
         */
        public var bounceSender: kotlin.String? = null
        /**
         * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the address in the "From" header of the bounce. For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
         */
        public var bounceSenderArn: kotlin.String? = null
        /**
         * A list of recipients of the bounced message, including the information required to create the Delivery Status Notifications (DSNs) for the recipients. You must specify at least one `BouncedRecipientInfo` in the list.
         */
        public var bouncedRecipientInfoList: List<BouncedRecipientInfo>? = null
        /**
         * Human-readable text for the bounce message to explain the failure. If not specified, the text is auto-generated based on the bounced recipient information.
         */
        public var explanation: kotlin.String? = null
        /**
         * Message-related DSN fields. If not specified, Amazon SES chooses the values.
         */
        public var messageDsn: aws.sdk.kotlin.services.ses.model.MessageDsn? = null
        /**
         * The message ID of the message to be bounced.
         */
        public var originalMessageId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.SendBounceRequest) : this() {
            this.bounceSender = x.bounceSender
            this.bounceSenderArn = x.bounceSenderArn
            this.bouncedRecipientInfoList = x.bouncedRecipientInfoList
            this.explanation = x.explanation
            this.messageDsn = x.messageDsn
            this.originalMessageId = x.originalMessageId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.SendBounceRequest = SendBounceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.MessageDsn] inside the given [block]
         */
        public fun messageDsn(block: aws.sdk.kotlin.services.ses.model.MessageDsn.Builder.() -> kotlin.Unit) {
            this.messageDsn = aws.sdk.kotlin.services.ses.model.MessageDsn.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
