// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Recipient-related information to include in the Delivery Status Notification (DSN) when an email that Amazon SES receives on your behalf bounces.
 *
 * For information about receiving email through Amazon SES, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email.html).
 */
public class RecipientDsnFields private constructor(builder: Builder) {
    /**
     * The action performed by the reporting mail transfer agent (MTA) as a result of its attempt to deliver the message to the recipient address. This is required by [RFC 3464](https://tools.ietf.org/html/rfc3464).
     */
    public val action: aws.sdk.kotlin.services.ses.model.DsnAction = requireNotNull(builder.action) { "A non-null value must be provided for action" }
    /**
     * An extended explanation of what went wrong; this is usually an SMTP response. See [RFC 3463](https://tools.ietf.org/html/rfc3463) for the correct formatting of this parameter.
     */
    public val diagnosticCode: kotlin.String? = builder.diagnosticCode
    /**
     * Additional X-headers to include in the DSN.
     */
    public val extensionFields: List<ExtensionField>? = builder.extensionFields
    /**
     * The email address that the message was ultimately delivered to. This corresponds to the `Final-Recipient` in the DSN. If not specified, `FinalRecipient` is set to the `Recipient` specified in the `BouncedRecipientInfo` structure. Either `FinalRecipient` or the recipient in `BouncedRecipientInfo` must be a recipient of the original bounced message.
     *
     * Do not prepend the `FinalRecipient` email address with `rfc 822;`, as described in [RFC 3798](https://tools.ietf.org/html/rfc3798).
     */
    public val finalRecipient: kotlin.String? = builder.finalRecipient
    /**
     * The time the final delivery attempt was made, in [RFC 822](https://www.ietf.org/rfc/rfc0822.txt) date-time format.
     */
    public val lastAttemptDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAttemptDate
    /**
     * The MTA to which the remote MTA attempted to deliver the message, formatted as specified in [RFC 3464](https://tools.ietf.org/html/rfc3464) (`mta-name-type; mta-name`). This parameter typically applies only to propagating synchronous bounces.
     */
    public val remoteMta: kotlin.String? = builder.remoteMta
    /**
     * The status code that indicates what went wrong. This is required by [RFC 3464](https://tools.ietf.org/html/rfc3464).
     */
    public val status: kotlin.String = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.RecipientDsnFields = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecipientDsnFields(")
        append("action=$action,")
        append("diagnosticCode=$diagnosticCode,")
        append("extensionFields=$extensionFields,")
        append("finalRecipient=$finalRecipient,")
        append("lastAttemptDate=$lastAttemptDate,")
        append("remoteMta=$remoteMta,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action.hashCode()
        result = 31 * result + (diagnosticCode?.hashCode() ?: 0)
        result = 31 * result + (extensionFields?.hashCode() ?: 0)
        result = 31 * result + (finalRecipient?.hashCode() ?: 0)
        result = 31 * result + (lastAttemptDate?.hashCode() ?: 0)
        result = 31 * result + (remoteMta?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecipientDsnFields

        if (action != other.action) return false
        if (diagnosticCode != other.diagnosticCode) return false
        if (extensionFields != other.extensionFields) return false
        if (finalRecipient != other.finalRecipient) return false
        if (lastAttemptDate != other.lastAttemptDate) return false
        if (remoteMta != other.remoteMta) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.RecipientDsnFields = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action performed by the reporting mail transfer agent (MTA) as a result of its attempt to deliver the message to the recipient address. This is required by [RFC 3464](https://tools.ietf.org/html/rfc3464).
         */
        public var action: aws.sdk.kotlin.services.ses.model.DsnAction? = null
        /**
         * An extended explanation of what went wrong; this is usually an SMTP response. See [RFC 3463](https://tools.ietf.org/html/rfc3463) for the correct formatting of this parameter.
         */
        public var diagnosticCode: kotlin.String? = null
        /**
         * Additional X-headers to include in the DSN.
         */
        public var extensionFields: List<ExtensionField>? = null
        /**
         * The email address that the message was ultimately delivered to. This corresponds to the `Final-Recipient` in the DSN. If not specified, `FinalRecipient` is set to the `Recipient` specified in the `BouncedRecipientInfo` structure. Either `FinalRecipient` or the recipient in `BouncedRecipientInfo` must be a recipient of the original bounced message.
         *
         * Do not prepend the `FinalRecipient` email address with `rfc 822;`, as described in [RFC 3798](https://tools.ietf.org/html/rfc3798).
         */
        public var finalRecipient: kotlin.String? = null
        /**
         * The time the final delivery attempt was made, in [RFC 822](https://www.ietf.org/rfc/rfc0822.txt) date-time format.
         */
        public var lastAttemptDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The MTA to which the remote MTA attempted to deliver the message, formatted as specified in [RFC 3464](https://tools.ietf.org/html/rfc3464) (`mta-name-type; mta-name`). This parameter typically applies only to propagating synchronous bounces.
         */
        public var remoteMta: kotlin.String? = null
        /**
         * The status code that indicates what went wrong. This is required by [RFC 3464](https://tools.ietf.org/html/rfc3464).
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.RecipientDsnFields) : this() {
            this.action = x.action
            this.diagnosticCode = x.diagnosticCode
            this.extensionFields = x.extensionFields
            this.finalRecipient = x.finalRecipient
            this.lastAttemptDate = x.lastAttemptDate
            this.remoteMta = x.remoteMta
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.RecipientDsnFields = RecipientDsnFields(this)

        internal fun correctErrors(): Builder {
            if (action == null) action = DsnAction.SdkUnknown("no value provided")
            if (status == null) status = ""
            return this
        }
    }
}
