// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * A receipt IP address filter enables you to specify whether to accept or reject mail originating from an IP address or range of IP addresses.
 *
 * For information about setting up IP address filters, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-ip-filtering-console-walkthrough.html).
 */
public class ReceiptIpFilter private constructor(builder: Builder) {
    /**
     * A single IP address or a range of IP addresses to block or allow, specified in Classless Inter-Domain Routing (CIDR) notation. An example of a single email address is 10.0.0.1. An example of a range of IP addresses is 10.0.0.1/24. For more information about CIDR notation, see [RFC 2317](https://tools.ietf.org/html/rfc2317).
     */
    public val cidr: kotlin.String = requireNotNull(builder.cidr) { "A non-null value must be provided for cidr" }
    /**
     * Indicates whether to block or allow incoming mail from the specified IP addresses.
     */
    public val policy: aws.sdk.kotlin.services.ses.model.ReceiptFilterPolicy = requireNotNull(builder.policy) { "A non-null value must be provided for policy" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.ReceiptIpFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReceiptIpFilter(")
        append("cidr=$cidr,")
        append("policy=$policy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidr.hashCode()
        result = 31 * result + (policy.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReceiptIpFilter

        if (cidr != other.cidr) return false
        if (policy != other.policy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.ReceiptIpFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A single IP address or a range of IP addresses to block or allow, specified in Classless Inter-Domain Routing (CIDR) notation. An example of a single email address is 10.0.0.1. An example of a range of IP addresses is 10.0.0.1/24. For more information about CIDR notation, see [RFC 2317](https://tools.ietf.org/html/rfc2317).
         */
        public var cidr: kotlin.String? = null
        /**
         * Indicates whether to block or allow incoming mail from the specified IP addresses.
         */
        public var policy: aws.sdk.kotlin.services.ses.model.ReceiptFilterPolicy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.ReceiptIpFilter) : this() {
            this.cidr = x.cidr
            this.policy = x.policy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.ReceiptIpFilter = ReceiptIpFilter(this)

        internal fun correctErrors(): Builder {
            if (cidr == null) cidr = ""
            if (policy == null) policy = ReceiptFilterPolicy.SdkUnknown("no value provided")
            return this
        }
    }
}
