// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * Indicates that the Amazon Simple Notification Service (Amazon SNS) destination is invalid. See the error message for details.
 */
public class InvalidSnsDestinationException private constructor(builder: Builder) : SesException() {

    /**
     * Indicates that the configuration set does not exist.
     */
    public val configurationSetName: kotlin.String? = builder.configurationSetName
    /**
     * Indicates that the event destination does not exist.
     */
    public val eventDestinationName: kotlin.String? = builder.eventDestinationName
    override val message: kotlin.String? = builder.message

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.InvalidSnsDestinationException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InvalidSnsDestinationException(")
        append("configurationSetName=$configurationSetName,")
        append("eventDestinationName=$eventDestinationName,")
        append("message=$message")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationSetName?.hashCode() ?: 0
        result = 31 * result + (eventDestinationName?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InvalidSnsDestinationException

        if (configurationSetName != other.configurationSetName) return false
        if (eventDestinationName != other.eventDestinationName) return false
        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.InvalidSnsDestinationException = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates that the configuration set does not exist.
         */
        public var configurationSetName: kotlin.String? = null
        /**
         * Indicates that the event destination does not exist.
         */
        public var eventDestinationName: kotlin.String? = null
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.InvalidSnsDestinationException) : this() {
            this.configurationSetName = x.configurationSetName
            this.eventDestinationName = x.eventDestinationName
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.InvalidSnsDestinationException = InvalidSnsDestinationException(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
