// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * Indicates that the provided Amazon Web Services Lambda function is invalid, or that Amazon SES could not execute the provided function, possibly due to permissions issues. For information about giving permissions, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
 */
public class InvalidLambdaFunctionException private constructor(builder: Builder) : SesException() {

    /**
     * Indicates that the ARN of the function was not found.
     */
    public val functionArn: kotlin.String? = builder.functionArn
    override val message: kotlin.String? = builder.message

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.InvalidLambdaFunctionException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InvalidLambdaFunctionException(")
        append("functionArn=$functionArn,")
        append("message=$message")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = functionArn?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InvalidLambdaFunctionException

        if (functionArn != other.functionArn) return false
        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.InvalidLambdaFunctionException = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates that the ARN of the function was not found.
         */
        public var functionArn: kotlin.String? = null
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.InvalidLambdaFunctionException) : this() {
            this.functionArn = x.functionArn
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.InvalidLambdaFunctionException = InvalidLambdaFunctionException(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
