// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents the DKIM attributes of a verified email address or a domain.
 */
public class IdentityDkimAttributes private constructor(builder: Builder) {
    /**
     * Is true if DKIM signing is enabled for email sent from the identity. It's false otherwise. The default value is true.
     */
    public val dkimEnabled: kotlin.Boolean = builder.dkimEnabled
    /**
     * A set of character strings that represent the domain's identity. Using these tokens, you need to create DNS CNAME records that point to DKIM public keys that are hosted by Amazon SES. Amazon Web Services eventually detects that you've updated your DNS records. This detection process might take up to 72 hours. After successful detection, Amazon SES is able to DKIM-sign email originating from that domain. (This only applies to domain identities, not email address identities.)
     *
     * For more information about creating DNS records using DKIM tokens, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
     */
    public val dkimTokens: List<String>? = builder.dkimTokens
    /**
     * Describes whether Amazon SES has successfully verified the DKIM DNS records (tokens) published in the domain name's DNS. (This only applies to domain identities, not email address identities.)
     */
    public val dkimVerificationStatus: aws.sdk.kotlin.services.ses.model.VerificationStatus = requireNotNull(builder.dkimVerificationStatus) { "A non-null value must be provided for dkimVerificationStatus" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.IdentityDkimAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IdentityDkimAttributes(")
        append("dkimEnabled=$dkimEnabled,")
        append("dkimTokens=$dkimTokens,")
        append("dkimVerificationStatus=$dkimVerificationStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dkimEnabled.hashCode()
        result = 31 * result + (dkimTokens?.hashCode() ?: 0)
        result = 31 * result + (dkimVerificationStatus.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IdentityDkimAttributes

        if (dkimEnabled != other.dkimEnabled) return false
        if (dkimTokens != other.dkimTokens) return false
        if (dkimVerificationStatus != other.dkimVerificationStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.IdentityDkimAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Is true if DKIM signing is enabled for email sent from the identity. It's false otherwise. The default value is true.
         */
        public var dkimEnabled: kotlin.Boolean = false
        /**
         * A set of character strings that represent the domain's identity. Using these tokens, you need to create DNS CNAME records that point to DKIM public keys that are hosted by Amazon SES. Amazon Web Services eventually detects that you've updated your DNS records. This detection process might take up to 72 hours. After successful detection, Amazon SES is able to DKIM-sign email originating from that domain. (This only applies to domain identities, not email address identities.)
         *
         * For more information about creating DNS records using DKIM tokens, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
         */
        public var dkimTokens: List<String>? = null
        /**
         * Describes whether Amazon SES has successfully verified the DKIM DNS records (tokens) published in the domain name's DNS. (This only applies to domain identities, not email address identities.)
         */
        public var dkimVerificationStatus: aws.sdk.kotlin.services.ses.model.VerificationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.IdentityDkimAttributes) : this() {
            this.dkimEnabled = x.dkimEnabled
            this.dkimTokens = x.dkimTokens
            this.dkimVerificationStatus = x.dkimVerificationStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.IdentityDkimAttributes = IdentityDkimAttributes(this)

        internal fun correctErrors(): Builder {
            if (dkimVerificationStatus == null) dkimVerificationStatus = VerificationStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
