// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents the destination of the message, consisting of To:, CC:, and BCC: fields.
 *
 * Amazon SES does not support the SMTPUTF8 extension, as described in [RFC6531](https://tools.ietf.org/html/rfc6531). For this reason, the email address string must be 7-bit ASCII. If you want to send to or from email addresses that contain Unicode characters in the domain part of an address, you must encode the domain using Punycode. Punycode is not permitted in the local part of the email address (the part before the @ sign) nor in the "friendly from" name. If you want to use Unicode characters in the "friendly from" name, you must encode the "friendly from" name using MIME encoded-word syntax, as described in [Sending raw email using the Amazon SES API](https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html). For more information about Punycode, see [RFC 3492](http://tools.ietf.org/html/rfc3492).
 */
public class Destination private constructor(builder: Builder) {
    /**
     * The recipients to place on the BCC: line of the message.
     */
    public val bccAddresses: List<String>? = builder.bccAddresses
    /**
     * The recipients to place on the CC: line of the message.
     */
    public val ccAddresses: List<String>? = builder.ccAddresses
    /**
     * The recipients to place on the To: line of the message.
     */
    public val toAddresses: List<String>? = builder.toAddresses

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.Destination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Destination(")
        append("bccAddresses=$bccAddresses,")
        append("ccAddresses=$ccAddresses,")
        append("toAddresses=$toAddresses")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bccAddresses?.hashCode() ?: 0
        result = 31 * result + (ccAddresses?.hashCode() ?: 0)
        result = 31 * result + (toAddresses?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Destination

        if (bccAddresses != other.bccAddresses) return false
        if (ccAddresses != other.ccAddresses) return false
        if (toAddresses != other.toAddresses) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.Destination = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The recipients to place on the BCC: line of the message.
         */
        public var bccAddresses: List<String>? = null
        /**
         * The recipients to place on the CC: line of the message.
         */
        public var ccAddresses: List<String>? = null
        /**
         * The recipients to place on the To: line of the message.
         */
        public var toAddresses: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.Destination) : this() {
            this.bccAddresses = x.bccAddresses
            this.ccAddresses = x.ccAddresses
            this.toAddresses = x.toAddresses
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.Destination = Destination(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
