// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * The name of the configuration set.
 *
 * Configuration sets let you create groups of rules that you can apply to the emails you send using Amazon SES. For more information about using configuration sets, see [Using Amazon SES Configuration Sets](https://docs.aws.amazon.com/ses/latest/dg/using-configuration-sets.html) in the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/).
 */
public class ConfigurationSet private constructor(builder: Builder) {
    /**
     * The name of the configuration set. The name must meet the following requirements:
     * + Contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
     * + Contain 64 characters or fewer.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.ConfigurationSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConfigurationSet(")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConfigurationSet

        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.ConfigurationSet = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the configuration set. The name must meet the following requirements:
         * + Contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
         * + Contain 64 characters or fewer.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.ConfigurationSet) : this() {
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.ConfigurationSet = ConfigurationSet(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
