// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Contains the dimension configuration to use when you publish email sending events to Amazon CloudWatch.
 *
 * For information about publishing email sending events to Amazon CloudWatch, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
 */
public class CloudWatchDimensionConfiguration private constructor(builder: Builder) {
    /**
     * The default value of the dimension that is published to Amazon CloudWatch if you do not provide the value of the dimension when you send an email. The default value must meet the following requirements:
     * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), dashes (-), at signs (@), or periods (.).
     * + Contain 256 characters or fewer.
     */
    public val defaultDimensionValue: kotlin.String = requireNotNull(builder.defaultDimensionValue) { "A non-null value must be provided for defaultDimensionValue" }
    /**
     * The name of an Amazon CloudWatch dimension associated with an email sending metric. The name must meet the following requirements:
     * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), dashes (-), or colons (:).
     * + Contain 256 characters or fewer.
     */
    public val dimensionName: kotlin.String = requireNotNull(builder.dimensionName) { "A non-null value must be provided for dimensionName" }
    /**
     * The place where Amazon SES finds the value of a dimension to publish to Amazon CloudWatch. To use the message tags that you specify using an `X-SES-MESSAGE-TAGS` header or a parameter to the `SendEmail`/`SendRawEmail` API, specify `messageTag`. To use your own email headers, specify `emailHeader`. To put a custom tag on any link included in your email, specify `linkTag`.
     */
    public val dimensionValueSource: aws.sdk.kotlin.services.ses.model.DimensionValueSource = requireNotNull(builder.dimensionValueSource) { "A non-null value must be provided for dimensionValueSource" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.CloudWatchDimensionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudWatchDimensionConfiguration(")
        append("defaultDimensionValue=$defaultDimensionValue,")
        append("dimensionName=$dimensionName,")
        append("dimensionValueSource=$dimensionValueSource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultDimensionValue.hashCode()
        result = 31 * result + (dimensionName.hashCode())
        result = 31 * result + (dimensionValueSource.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudWatchDimensionConfiguration

        if (defaultDimensionValue != other.defaultDimensionValue) return false
        if (dimensionName != other.dimensionName) return false
        if (dimensionValueSource != other.dimensionValueSource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.CloudWatchDimensionConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The default value of the dimension that is published to Amazon CloudWatch if you do not provide the value of the dimension when you send an email. The default value must meet the following requirements:
         * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), dashes (-), at signs (@), or periods (.).
         * + Contain 256 characters or fewer.
         */
        public var defaultDimensionValue: kotlin.String? = null
        /**
         * The name of an Amazon CloudWatch dimension associated with an email sending metric. The name must meet the following requirements:
         * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), dashes (-), or colons (:).
         * + Contain 256 characters or fewer.
         */
        public var dimensionName: kotlin.String? = null
        /**
         * The place where Amazon SES finds the value of a dimension to publish to Amazon CloudWatch. To use the message tags that you specify using an `X-SES-MESSAGE-TAGS` header or a parameter to the `SendEmail`/`SendRawEmail` API, specify `messageTag`. To use your own email headers, specify `emailHeader`. To put a custom tag on any link included in your email, specify `linkTag`.
         */
        public var dimensionValueSource: aws.sdk.kotlin.services.ses.model.DimensionValueSource? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.CloudWatchDimensionConfiguration) : this() {
            this.defaultDimensionValue = x.defaultDimensionValue
            this.dimensionName = x.dimensionName
            this.dimensionValueSource = x.dimensionValueSource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.CloudWatchDimensionConfiguration = CloudWatchDimensionConfiguration(this)

        internal fun correctErrors(): Builder {
            if (defaultDimensionValue == null) defaultDimensionValue = ""
            if (dimensionName == null) dimensionName = ""
            if (dimensionValueSource == null) dimensionValueSource = DimensionValueSource.SdkUnknown("no value provided")
            return this
        }
    }
}
