// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Contains information associated with an Amazon CloudWatch event destination to which email sending events are published.
 *
 * Event destinations, such as Amazon CloudWatch, are associated with configuration sets, which enable you to publish email sending events. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
 */
public class CloudWatchDestination private constructor(builder: Builder) {
    /**
     * A list of dimensions upon which to categorize your emails when you publish email sending events to Amazon CloudWatch.
     */
    public val dimensionConfigurations: List<CloudWatchDimensionConfiguration> = requireNotNull(builder.dimensionConfigurations) { "A non-null value must be provided for dimensionConfigurations" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.CloudWatchDestination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudWatchDestination(")
        append("dimensionConfigurations=$dimensionConfigurations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dimensionConfigurations.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudWatchDestination

        if (dimensionConfigurations != other.dimensionConfigurations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.CloudWatchDestination = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of dimensions upon which to categorize your emails when you publish email sending events to Amazon CloudWatch.
         */
        public var dimensionConfigurations: List<CloudWatchDimensionConfiguration>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.CloudWatchDestination) : this() {
            this.dimensionConfigurations = x.dimensionConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.CloudWatchDestination = CloudWatchDestination(this)

        internal fun correctErrors(): Builder {
            if (dimensionConfigurations == null) dimensionConfigurations = emptyList()
            return this
        }
    }
}
