// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * An array that contains one or more Destinations, as well as the tags and replacement data associated with each of those Destinations.
 */
public class BulkEmailDestination private constructor(builder: Builder) {
    /**
     * Represents the destination of the message, consisting of To:, CC:, and BCC: fields.
     *
     * Amazon SES does not support the SMTPUTF8 extension, as described in [RFC6531](https://tools.ietf.org/html/rfc6531). For this reason, the email address string must be 7-bit ASCII. If you want to send to or from email addresses that contain Unicode characters in the domain part of an address, you must encode the domain using Punycode. Punycode is not permitted in the local part of the email address (the part before the @ sign) nor in the "friendly from" name. If you want to use Unicode characters in the "friendly from" name, you must encode the "friendly from" name using MIME encoded-word syntax, as described in [Sending raw email using the Amazon SES API](https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html). For more information about Punycode, see [RFC 3492](http://tools.ietf.org/html/rfc3492).
     */
    public val destination: aws.sdk.kotlin.services.ses.model.Destination? = builder.destination
    /**
     * A list of tags, in the form of name/value pairs, to apply to an email that you send using `SendBulkTemplatedEmail`. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.
     */
    public val replacementTags: List<MessageTag>? = builder.replacementTags
    /**
     * A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.
     */
    public val replacementTemplateData: kotlin.String? = builder.replacementTemplateData

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.BulkEmailDestination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BulkEmailDestination(")
        append("destination=$destination,")
        append("replacementTags=$replacementTags,")
        append("replacementTemplateData=$replacementTemplateData")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destination?.hashCode() ?: 0
        result = 31 * result + (replacementTags?.hashCode() ?: 0)
        result = 31 * result + (replacementTemplateData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BulkEmailDestination

        if (destination != other.destination) return false
        if (replacementTags != other.replacementTags) return false
        if (replacementTemplateData != other.replacementTemplateData) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.BulkEmailDestination = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Represents the destination of the message, consisting of To:, CC:, and BCC: fields.
         *
         * Amazon SES does not support the SMTPUTF8 extension, as described in [RFC6531](https://tools.ietf.org/html/rfc6531). For this reason, the email address string must be 7-bit ASCII. If you want to send to or from email addresses that contain Unicode characters in the domain part of an address, you must encode the domain using Punycode. Punycode is not permitted in the local part of the email address (the part before the @ sign) nor in the "friendly from" name. If you want to use Unicode characters in the "friendly from" name, you must encode the "friendly from" name using MIME encoded-word syntax, as described in [Sending raw email using the Amazon SES API](https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html). For more information about Punycode, see [RFC 3492](http://tools.ietf.org/html/rfc3492).
         */
        public var destination: aws.sdk.kotlin.services.ses.model.Destination? = null
        /**
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using `SendBulkTemplatedEmail`. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.
         */
        public var replacementTags: List<MessageTag>? = null
        /**
         * A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.
         */
        public var replacementTemplateData: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.BulkEmailDestination) : this() {
            this.destination = x.destination
            this.replacementTags = x.replacementTags
            this.replacementTemplateData = x.replacementTemplateData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.BulkEmailDestination = BulkEmailDestination(this)

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.Destination] inside the given [block]
         */
        public fun destination(block: aws.sdk.kotlin.services.ses.model.Destination.Builder.() -> kotlin.Unit) {
            this.destination = aws.sdk.kotlin.services.ses.model.Destination.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
