// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Recipient-related information to include in the Delivery Status Notification (DSN) when an email that Amazon SES receives on your behalf bounces.
 *
 * For information about receiving email through Amazon SES, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email.html).
 */
public class BouncedRecipientInfo private constructor(builder: Builder) {
    /**
     * The reason for the bounce. You must provide either this parameter or `RecipientDsnFields`.
     */
    public val bounceType: aws.sdk.kotlin.services.ses.model.BounceType? = builder.bounceType
    /**
     * The email address of the recipient of the bounced email.
     */
    public val recipient: kotlin.String = requireNotNull(builder.recipient) { "A non-null value must be provided for recipient" }
    /**
     * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to receive email for the recipient of the bounced email. For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
     */
    public val recipientArn: kotlin.String? = builder.recipientArn
    /**
     * Recipient-related DSN fields, most of which would normally be filled in automatically when provided with a `BounceType`. You must provide either this parameter or `BounceType`.
     */
    public val recipientDsnFields: aws.sdk.kotlin.services.ses.model.RecipientDsnFields? = builder.recipientDsnFields

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.BouncedRecipientInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BouncedRecipientInfo(")
        append("bounceType=$bounceType,")
        append("recipient=$recipient,")
        append("recipientArn=$recipientArn,")
        append("recipientDsnFields=$recipientDsnFields")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bounceType?.hashCode() ?: 0
        result = 31 * result + (recipient.hashCode())
        result = 31 * result + (recipientArn?.hashCode() ?: 0)
        result = 31 * result + (recipientDsnFields?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BouncedRecipientInfo

        if (bounceType != other.bounceType) return false
        if (recipient != other.recipient) return false
        if (recipientArn != other.recipientArn) return false
        if (recipientDsnFields != other.recipientDsnFields) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.BouncedRecipientInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The reason for the bounce. You must provide either this parameter or `RecipientDsnFields`.
         */
        public var bounceType: aws.sdk.kotlin.services.ses.model.BounceType? = null
        /**
         * The email address of the recipient of the bounced email.
         */
        public var recipient: kotlin.String? = null
        /**
         * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to receive email for the recipient of the bounced email. For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
         */
        public var recipientArn: kotlin.String? = null
        /**
         * Recipient-related DSN fields, most of which would normally be filled in automatically when provided with a `BounceType`. You must provide either this parameter or `BounceType`.
         */
        public var recipientDsnFields: aws.sdk.kotlin.services.ses.model.RecipientDsnFields? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.BouncedRecipientInfo) : this() {
            this.bounceType = x.bounceType
            this.recipient = x.recipient
            this.recipientArn = x.recipientArn
            this.recipientDsnFields = x.recipientDsnFields
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.BouncedRecipientInfo = BouncedRecipientInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.RecipientDsnFields] inside the given [block]
         */
        public fun recipientDsnFields(block: aws.sdk.kotlin.services.ses.model.RecipientDsnFields.Builder.() -> kotlin.Unit) {
            this.recipientDsnFields = aws.sdk.kotlin.services.ses.model.RecipientDsnFields.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (recipient == null) recipient = ""
            return this
        }
    }
}
