// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * When included in a receipt rule, this action rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).
 *
 * For information about sending a bounce message in response to a received email, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-bounce.html).
 */
public class BounceAction private constructor(builder: Builder) {
    /**
     * Human-readable text to include in the bounce message.
     */
    public val message: kotlin.String = requireNotNull(builder.message) { "A non-null value must be provided for message" }
    /**
     * The email address of the sender of the bounced email. This is the address from which the bounce message is sent.
     */
    public val sender: kotlin.String = requireNotNull(builder.sender) { "A non-null value must be provided for sender" }
    /**
     * The SMTP reply code, as defined by [RFC 5321](https://tools.ietf.org/html/rfc5321).
     */
    public val smtpReplyCode: kotlin.String = requireNotNull(builder.smtpReplyCode) { "A non-null value must be provided for smtpReplyCode" }
    /**
     * The SMTP enhanced status code, as defined by [RFC 3463](https://tools.ietf.org/html/rfc3463).
     */
    public val statusCode: kotlin.String? = builder.statusCode
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the bounce action is taken. You can find the ARN of a topic by using the [ListTopics](https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html) operation in Amazon SNS.
     *
     * For more information about Amazon SNS topics, see the [Amazon SNS Developer Guide](https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
     */
    public val topicArn: kotlin.String? = builder.topicArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.BounceAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BounceAction(")
        append("message=$message,")
        append("sender=$sender,")
        append("smtpReplyCode=$smtpReplyCode,")
        append("statusCode=$statusCode,")
        append("topicArn=$topicArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message.hashCode()
        result = 31 * result + (sender.hashCode())
        result = 31 * result + (smtpReplyCode.hashCode())
        result = 31 * result + (statusCode?.hashCode() ?: 0)
        result = 31 * result + (topicArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BounceAction

        if (message != other.message) return false
        if (sender != other.sender) return false
        if (smtpReplyCode != other.smtpReplyCode) return false
        if (statusCode != other.statusCode) return false
        if (topicArn != other.topicArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.BounceAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Human-readable text to include in the bounce message.
         */
        public var message: kotlin.String? = null
        /**
         * The email address of the sender of the bounced email. This is the address from which the bounce message is sent.
         */
        public var sender: kotlin.String? = null
        /**
         * The SMTP reply code, as defined by [RFC 5321](https://tools.ietf.org/html/rfc5321).
         */
        public var smtpReplyCode: kotlin.String? = null
        /**
         * The SMTP enhanced status code, as defined by [RFC 3463](https://tools.ietf.org/html/rfc3463).
         */
        public var statusCode: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the bounce action is taken. You can find the ARN of a topic by using the [ListTopics](https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html) operation in Amazon SNS.
         *
         * For more information about Amazon SNS topics, see the [Amazon SNS Developer Guide](https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
         */
        public var topicArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.BounceAction) : this() {
            this.message = x.message
            this.sender = x.sender
            this.smtpReplyCode = x.smtpReplyCode
            this.statusCode = x.statusCode
            this.topicArn = x.topicArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.BounceAction = BounceAction(this)

        internal fun correctErrors(): Builder {
            if (message == null) message = ""
            if (sender == null) sender = ""
            if (smtpReplyCode == null) smtpReplyCode = ""
            return this
        }
    }
}
