// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.ses.auth.DefaultSesAuthSchemeProvider
import aws.sdk.kotlin.services.ses.auth.SesAuthSchemeProvider
import aws.sdk.kotlin.services.ses.endpoints.DefaultSesEndpointProvider
import aws.sdk.kotlin.services.ses.endpoints.SesEndpointParameters
import aws.sdk.kotlin.services.ses.endpoints.SesEndpointProvider
import aws.sdk.kotlin.services.ses.model.CloneReceiptRuleSetRequest
import aws.sdk.kotlin.services.ses.model.CloneReceiptRuleSetResponse
import aws.sdk.kotlin.services.ses.model.CreateConfigurationSetEventDestinationRequest
import aws.sdk.kotlin.services.ses.model.CreateConfigurationSetEventDestinationResponse
import aws.sdk.kotlin.services.ses.model.CreateConfigurationSetRequest
import aws.sdk.kotlin.services.ses.model.CreateConfigurationSetResponse
import aws.sdk.kotlin.services.ses.model.CreateConfigurationSetTrackingOptionsRequest
import aws.sdk.kotlin.services.ses.model.CreateConfigurationSetTrackingOptionsResponse
import aws.sdk.kotlin.services.ses.model.CreateCustomVerificationEmailTemplateRequest
import aws.sdk.kotlin.services.ses.model.CreateCustomVerificationEmailTemplateResponse
import aws.sdk.kotlin.services.ses.model.CreateReceiptFilterRequest
import aws.sdk.kotlin.services.ses.model.CreateReceiptFilterResponse
import aws.sdk.kotlin.services.ses.model.CreateReceiptRuleRequest
import aws.sdk.kotlin.services.ses.model.CreateReceiptRuleResponse
import aws.sdk.kotlin.services.ses.model.CreateReceiptRuleSetRequest
import aws.sdk.kotlin.services.ses.model.CreateReceiptRuleSetResponse
import aws.sdk.kotlin.services.ses.model.CreateTemplateRequest
import aws.sdk.kotlin.services.ses.model.CreateTemplateResponse
import aws.sdk.kotlin.services.ses.model.DeleteConfigurationSetEventDestinationRequest
import aws.sdk.kotlin.services.ses.model.DeleteConfigurationSetEventDestinationResponse
import aws.sdk.kotlin.services.ses.model.DeleteConfigurationSetRequest
import aws.sdk.kotlin.services.ses.model.DeleteConfigurationSetResponse
import aws.sdk.kotlin.services.ses.model.DeleteConfigurationSetTrackingOptionsRequest
import aws.sdk.kotlin.services.ses.model.DeleteConfigurationSetTrackingOptionsResponse
import aws.sdk.kotlin.services.ses.model.DeleteCustomVerificationEmailTemplateRequest
import aws.sdk.kotlin.services.ses.model.DeleteCustomVerificationEmailTemplateResponse
import aws.sdk.kotlin.services.ses.model.DeleteIdentityPolicyRequest
import aws.sdk.kotlin.services.ses.model.DeleteIdentityPolicyResponse
import aws.sdk.kotlin.services.ses.model.DeleteIdentityRequest
import aws.sdk.kotlin.services.ses.model.DeleteIdentityResponse
import aws.sdk.kotlin.services.ses.model.DeleteReceiptFilterRequest
import aws.sdk.kotlin.services.ses.model.DeleteReceiptFilterResponse
import aws.sdk.kotlin.services.ses.model.DeleteReceiptRuleRequest
import aws.sdk.kotlin.services.ses.model.DeleteReceiptRuleResponse
import aws.sdk.kotlin.services.ses.model.DeleteReceiptRuleSetRequest
import aws.sdk.kotlin.services.ses.model.DeleteReceiptRuleSetResponse
import aws.sdk.kotlin.services.ses.model.DeleteTemplateRequest
import aws.sdk.kotlin.services.ses.model.DeleteTemplateResponse
import aws.sdk.kotlin.services.ses.model.DeleteVerifiedEmailAddressRequest
import aws.sdk.kotlin.services.ses.model.DeleteVerifiedEmailAddressResponse
import aws.sdk.kotlin.services.ses.model.DescribeActiveReceiptRuleSetRequest
import aws.sdk.kotlin.services.ses.model.DescribeActiveReceiptRuleSetResponse
import aws.sdk.kotlin.services.ses.model.DescribeConfigurationSetRequest
import aws.sdk.kotlin.services.ses.model.DescribeConfigurationSetResponse
import aws.sdk.kotlin.services.ses.model.DescribeReceiptRuleRequest
import aws.sdk.kotlin.services.ses.model.DescribeReceiptRuleResponse
import aws.sdk.kotlin.services.ses.model.DescribeReceiptRuleSetRequest
import aws.sdk.kotlin.services.ses.model.DescribeReceiptRuleSetResponse
import aws.sdk.kotlin.services.ses.model.GetAccountSendingEnabledRequest
import aws.sdk.kotlin.services.ses.model.GetAccountSendingEnabledResponse
import aws.sdk.kotlin.services.ses.model.GetCustomVerificationEmailTemplateRequest
import aws.sdk.kotlin.services.ses.model.GetCustomVerificationEmailTemplateResponse
import aws.sdk.kotlin.services.ses.model.GetIdentityDkimAttributesRequest
import aws.sdk.kotlin.services.ses.model.GetIdentityDkimAttributesResponse
import aws.sdk.kotlin.services.ses.model.GetIdentityMailFromDomainAttributesRequest
import aws.sdk.kotlin.services.ses.model.GetIdentityMailFromDomainAttributesResponse
import aws.sdk.kotlin.services.ses.model.GetIdentityNotificationAttributesRequest
import aws.sdk.kotlin.services.ses.model.GetIdentityNotificationAttributesResponse
import aws.sdk.kotlin.services.ses.model.GetIdentityPoliciesRequest
import aws.sdk.kotlin.services.ses.model.GetIdentityPoliciesResponse
import aws.sdk.kotlin.services.ses.model.GetIdentityVerificationAttributesRequest
import aws.sdk.kotlin.services.ses.model.GetIdentityVerificationAttributesResponse
import aws.sdk.kotlin.services.ses.model.GetSendQuotaRequest
import aws.sdk.kotlin.services.ses.model.GetSendQuotaResponse
import aws.sdk.kotlin.services.ses.model.GetSendStatisticsRequest
import aws.sdk.kotlin.services.ses.model.GetSendStatisticsResponse
import aws.sdk.kotlin.services.ses.model.GetTemplateRequest
import aws.sdk.kotlin.services.ses.model.GetTemplateResponse
import aws.sdk.kotlin.services.ses.model.ListConfigurationSetsRequest
import aws.sdk.kotlin.services.ses.model.ListConfigurationSetsResponse
import aws.sdk.kotlin.services.ses.model.ListCustomVerificationEmailTemplatesRequest
import aws.sdk.kotlin.services.ses.model.ListCustomVerificationEmailTemplatesResponse
import aws.sdk.kotlin.services.ses.model.ListIdentitiesRequest
import aws.sdk.kotlin.services.ses.model.ListIdentitiesResponse
import aws.sdk.kotlin.services.ses.model.ListIdentityPoliciesRequest
import aws.sdk.kotlin.services.ses.model.ListIdentityPoliciesResponse
import aws.sdk.kotlin.services.ses.model.ListReceiptFiltersRequest
import aws.sdk.kotlin.services.ses.model.ListReceiptFiltersResponse
import aws.sdk.kotlin.services.ses.model.ListReceiptRuleSetsRequest
import aws.sdk.kotlin.services.ses.model.ListReceiptRuleSetsResponse
import aws.sdk.kotlin.services.ses.model.ListTemplatesRequest
import aws.sdk.kotlin.services.ses.model.ListTemplatesResponse
import aws.sdk.kotlin.services.ses.model.ListVerifiedEmailAddressesRequest
import aws.sdk.kotlin.services.ses.model.ListVerifiedEmailAddressesResponse
import aws.sdk.kotlin.services.ses.model.PutConfigurationSetDeliveryOptionsRequest
import aws.sdk.kotlin.services.ses.model.PutConfigurationSetDeliveryOptionsResponse
import aws.sdk.kotlin.services.ses.model.PutIdentityPolicyRequest
import aws.sdk.kotlin.services.ses.model.PutIdentityPolicyResponse
import aws.sdk.kotlin.services.ses.model.ReorderReceiptRuleSetRequest
import aws.sdk.kotlin.services.ses.model.ReorderReceiptRuleSetResponse
import aws.sdk.kotlin.services.ses.model.SendBounceRequest
import aws.sdk.kotlin.services.ses.model.SendBounceResponse
import aws.sdk.kotlin.services.ses.model.SendBulkTemplatedEmailRequest
import aws.sdk.kotlin.services.ses.model.SendBulkTemplatedEmailResponse
import aws.sdk.kotlin.services.ses.model.SendCustomVerificationEmailRequest
import aws.sdk.kotlin.services.ses.model.SendCustomVerificationEmailResponse
import aws.sdk.kotlin.services.ses.model.SendEmailRequest
import aws.sdk.kotlin.services.ses.model.SendEmailResponse
import aws.sdk.kotlin.services.ses.model.SendRawEmailRequest
import aws.sdk.kotlin.services.ses.model.SendRawEmailResponse
import aws.sdk.kotlin.services.ses.model.SendTemplatedEmailRequest
import aws.sdk.kotlin.services.ses.model.SendTemplatedEmailResponse
import aws.sdk.kotlin.services.ses.model.SetActiveReceiptRuleSetRequest
import aws.sdk.kotlin.services.ses.model.SetActiveReceiptRuleSetResponse
import aws.sdk.kotlin.services.ses.model.SetIdentityDkimEnabledRequest
import aws.sdk.kotlin.services.ses.model.SetIdentityDkimEnabledResponse
import aws.sdk.kotlin.services.ses.model.SetIdentityFeedbackForwardingEnabledRequest
import aws.sdk.kotlin.services.ses.model.SetIdentityFeedbackForwardingEnabledResponse
import aws.sdk.kotlin.services.ses.model.SetIdentityHeadersInNotificationsEnabledRequest
import aws.sdk.kotlin.services.ses.model.SetIdentityHeadersInNotificationsEnabledResponse
import aws.sdk.kotlin.services.ses.model.SetIdentityMailFromDomainRequest
import aws.sdk.kotlin.services.ses.model.SetIdentityMailFromDomainResponse
import aws.sdk.kotlin.services.ses.model.SetIdentityNotificationTopicRequest
import aws.sdk.kotlin.services.ses.model.SetIdentityNotificationTopicResponse
import aws.sdk.kotlin.services.ses.model.SetReceiptRulePositionRequest
import aws.sdk.kotlin.services.ses.model.SetReceiptRulePositionResponse
import aws.sdk.kotlin.services.ses.model.TestRenderTemplateRequest
import aws.sdk.kotlin.services.ses.model.TestRenderTemplateResponse
import aws.sdk.kotlin.services.ses.model.UpdateAccountSendingEnabledRequest
import aws.sdk.kotlin.services.ses.model.UpdateAccountSendingEnabledResponse
import aws.sdk.kotlin.services.ses.model.UpdateConfigurationSetEventDestinationRequest
import aws.sdk.kotlin.services.ses.model.UpdateConfigurationSetEventDestinationResponse
import aws.sdk.kotlin.services.ses.model.UpdateConfigurationSetReputationMetricsEnabledRequest
import aws.sdk.kotlin.services.ses.model.UpdateConfigurationSetReputationMetricsEnabledResponse
import aws.sdk.kotlin.services.ses.model.UpdateConfigurationSetSendingEnabledRequest
import aws.sdk.kotlin.services.ses.model.UpdateConfigurationSetSendingEnabledResponse
import aws.sdk.kotlin.services.ses.model.UpdateConfigurationSetTrackingOptionsRequest
import aws.sdk.kotlin.services.ses.model.UpdateConfigurationSetTrackingOptionsResponse
import aws.sdk.kotlin.services.ses.model.UpdateCustomVerificationEmailTemplateRequest
import aws.sdk.kotlin.services.ses.model.UpdateCustomVerificationEmailTemplateResponse
import aws.sdk.kotlin.services.ses.model.UpdateReceiptRuleRequest
import aws.sdk.kotlin.services.ses.model.UpdateReceiptRuleResponse
import aws.sdk.kotlin.services.ses.model.UpdateTemplateRequest
import aws.sdk.kotlin.services.ses.model.UpdateTemplateResponse
import aws.sdk.kotlin.services.ses.model.VerifyDomainDkimRequest
import aws.sdk.kotlin.services.ses.model.VerifyDomainDkimResponse
import aws.sdk.kotlin.services.ses.model.VerifyDomainIdentityRequest
import aws.sdk.kotlin.services.ses.model.VerifyDomainIdentityResponse
import aws.sdk.kotlin.services.ses.model.VerifyEmailAddressRequest
import aws.sdk.kotlin.services.ses.model.VerifyEmailAddressResponse
import aws.sdk.kotlin.services.ses.model.VerifyEmailIdentityRequest
import aws.sdk.kotlin.services.ses.model.VerifyEmailIdentityResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "SES"
public const val SdkVersion: String = "0.34.3-beta"

/**
 * # Amazon Simple Email Service
 *  This document contains reference information for the [Amazon Simple Email Service](https://aws.amazon.com/ses/) (Amazon SES) API, version 2010-12-01. This document is best used in conjunction with the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/Welcome.html).
 *
 *  For a list of Amazon SES endpoints to use in service requests, see [Regions and Amazon SES](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/regions.html) in the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/Welcome.html).
 *
 * This documentation contains reference information related to the following:
 * + [Amazon SES API Actions](https://docs.aws.amazon.com/ses/latest/APIReference/API_Operations.html)
 * + [Amazon SES API Data Types](https://docs.aws.amazon.com/ses/latest/APIReference/API_Types.html)
 * + [Common Parameters](https://docs.aws.amazon.com/ses/latest/APIReference/CommonParameters.html)
 * + [Common Errors](https://docs.aws.amazon.com/ses/latest/APIReference/CommonErrors.html)
 */
public interface SesClient : SdkClient {
    /**
     * SesClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SesClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>) {
            builder.config.interceptors.add(0, ClockSkewInterceptor())
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Ses",
                "SES",
                "ses",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SesClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SesClient = DefaultSesClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        public val authSchemeProvider: SesAuthSchemeProvider = builder.authSchemeProvider ?: DefaultSesAuthSchemeProvider
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: SesEndpointProvider = builder.endpointProvider ?: DefaultSesEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemeProvider = this@Config.authSchemeProvider
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "SES"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: SesAuthSchemeProvider? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: SesEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a receipt rule set by cloning an existing one. All receipt rules and configurations are copied to the new receipt rule set and are completely independent of the source rule set.
     *
     * For information about setting up rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html#receiving-email-concepts-rules).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun cloneReceiptRuleSet(input: CloneReceiptRuleSetRequest): CloneReceiptRuleSetResponse

    /**
     * Creates a configuration set.
     *
     * Configuration sets enable you to publish email sending events. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun createConfigurationSet(input: CreateConfigurationSetRequest): CreateConfigurationSetResponse

    /**
     * Creates a configuration set event destination.
     *
     * When you create or update an event destination, you must provide one, and only one, destination. The destination can be CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).
     *
     * An event destination is the Amazon Web Services service to which Amazon SES publishes the email sending events associated with a configuration set. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun createConfigurationSetEventDestination(input: CreateConfigurationSetEventDestinationRequest): CreateConfigurationSetEventDestinationResponse

    /**
     * Creates an association between a configuration set and a custom domain for open and click event tracking.
     *
     * By default, images and links used for tracking open and click events are hosted on domains operated by Amazon SES. You can configure a subdomain of your own to handle these events. For information about using custom domains, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/configure-custom-open-click-domains.html).
     */
    public suspend fun createConfigurationSetTrackingOptions(input: CreateConfigurationSetTrackingOptionsRequest): CreateConfigurationSetTrackingOptionsResponse

    /**
     * Creates a new custom verification email template.
     *
     * For more information about custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom) in the *Amazon SES Developer Guide*.
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun createCustomVerificationEmailTemplate(input: CreateCustomVerificationEmailTemplateRequest): CreateCustomVerificationEmailTemplateResponse

    /**
     * Creates a new IP address filter.
     *
     * For information about setting up IP address filters, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-ip-filtering-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun createReceiptFilter(input: CreateReceiptFilterRequest): CreateReceiptFilterResponse

    /**
     * Creates a receipt rule.
     *
     * For information about setting up receipt rules, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun createReceiptRule(input: CreateReceiptRuleRequest): CreateReceiptRuleResponse

    /**
     * Creates an empty receipt rule set.
     *
     * For information about setting up receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html#receiving-email-concepts-rules).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun createReceiptRuleSet(input: CreateReceiptRuleSetRequest): CreateReceiptRuleSetResponse

    /**
     * Creates an email template. Email templates enable you to send personalized email to one or more destinations in a single operation. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-personalized-email-api.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun createTemplate(input: CreateTemplateRequest): CreateTemplateResponse

    /**
     * Deletes a configuration set. Configuration sets enable you to publish email sending events. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun deleteConfigurationSet(input: DeleteConfigurationSetRequest): DeleteConfigurationSetResponse

    /**
     * Deletes a configuration set event destination. Configuration set event destinations are associated with configuration sets, which enable you to publish email sending events. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun deleteConfigurationSetEventDestination(input: DeleteConfigurationSetEventDestinationRequest): DeleteConfigurationSetEventDestinationResponse

    /**
     * Deletes an association between a configuration set and a custom domain for open and click event tracking.
     *
     * By default, images and links used for tracking open and click events are hosted on domains operated by Amazon SES. You can configure a subdomain of your own to handle these events. For information about using custom domains, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/configure-custom-open-click-domains.html).
     *
     * Deleting this kind of association results in emails sent using the specified configuration set to capture open and click events using the standard, Amazon SES-operated domains.
     */
    public suspend fun deleteConfigurationSetTrackingOptions(input: DeleteConfigurationSetTrackingOptionsRequest): DeleteConfigurationSetTrackingOptionsResponse

    /**
     * Deletes an existing custom verification email template.
     *
     * For more information about custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom) in the *Amazon SES Developer Guide*.
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun deleteCustomVerificationEmailTemplate(input: DeleteCustomVerificationEmailTemplateRequest): DeleteCustomVerificationEmailTemplateResponse

    /**
     * Deletes the specified identity (an email address or a domain) from the list of verified identities.
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun deleteIdentity(input: DeleteIdentityRequest): DeleteIdentityResponse

    /**
     * Deletes the specified sending authorization policy for the given identity (an email address or a domain). This operation returns successfully even if a policy with the specified name does not exist.
     *
     * This operation is for the identity owner only. If you have not verified the identity, it returns an error.
     *
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun deleteIdentityPolicy(input: DeleteIdentityPolicyRequest): DeleteIdentityPolicyResponse

    /**
     * Deletes the specified IP address filter.
     *
     * For information about managing IP address filters, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-ip-filtering-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun deleteReceiptFilter(input: DeleteReceiptFilterRequest): DeleteReceiptFilterResponse

    /**
     * Deletes the specified receipt rule.
     *
     * For information about managing receipt rules, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun deleteReceiptRule(input: DeleteReceiptRuleRequest): DeleteReceiptRuleResponse

    /**
     * Deletes the specified receipt rule set and all of the receipt rules it contains.
     *
     * The currently active rule set cannot be deleted.
     *
     * For information about managing receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun deleteReceiptRuleSet(input: DeleteReceiptRuleSetRequest): DeleteReceiptRuleSetResponse

    /**
     * Deletes an email template.
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun deleteTemplate(input: DeleteTemplateRequest): DeleteTemplateResponse

    /**
     * Deprecated. Use the `DeleteIdentity` operation to delete email addresses and domains.
     */
    public suspend fun deleteVerifiedEmailAddress(input: DeleteVerifiedEmailAddressRequest): DeleteVerifiedEmailAddressResponse

    /**
     * Returns the metadata and receipt rules for the receipt rule set that is currently active.
     *
     * For information about setting up receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html#receiving-email-concepts-rules).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun describeActiveReceiptRuleSet(input: DescribeActiveReceiptRuleSetRequest = DescribeActiveReceiptRuleSetRequest { }): DescribeActiveReceiptRuleSetResponse

    /**
     * Returns the details of the specified configuration set. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun describeConfigurationSet(input: DescribeConfigurationSetRequest): DescribeConfigurationSetResponse

    /**
     * Returns the details of the specified receipt rule.
     *
     * For information about setting up receipt rules, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun describeReceiptRule(input: DescribeReceiptRuleRequest): DescribeReceiptRuleResponse

    /**
     * Returns the details of the specified receipt rule set.
     *
     * For information about managing receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun describeReceiptRuleSet(input: DescribeReceiptRuleSetRequest): DescribeReceiptRuleSetResponse

    /**
     * Returns the email sending status of the Amazon SES account for the current Region.
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun getAccountSendingEnabled(input: GetAccountSendingEnabledRequest = GetAccountSendingEnabledRequest { }): GetAccountSendingEnabledResponse

    /**
     * Returns the custom email verification template for the template name you specify.
     *
     * For more information about custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom) in the *Amazon SES Developer Guide*.
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun getCustomVerificationEmailTemplate(input: GetCustomVerificationEmailTemplateRequest): GetCustomVerificationEmailTemplateResponse

    /**
     * Returns the current status of Easy DKIM signing for an entity. For domain name identities, this operation also returns the DKIM tokens that are required for Easy DKIM signing, and whether Amazon SES has successfully verified that these tokens have been published.
     *
     * This operation takes a list of identities as input and returns the following information for each:
     * + Whether Easy DKIM signing is enabled or disabled.
     * + A set of DKIM tokens that represent the identity. If the identity is an email address, the tokens represent the domain of that address.
     * + Whether Amazon SES has successfully verified the DKIM tokens published in the domain's DNS. This information is only returned for domain name identities, not for email addresses.
     *
     * This operation is throttled at one request per second and can only get DKIM attributes for up to 100 identities at a time.
     *
     * For more information about creating DNS records using DKIM tokens, go to the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy-managing.html).
     */
    public suspend fun getIdentityDkimAttributes(input: GetIdentityDkimAttributesRequest): GetIdentityDkimAttributesResponse

    /**
     * Returns the custom MAIL FROM attributes for a list of identities (email addresses : domains).
     *
     * This operation is throttled at one request per second and can only get custom MAIL FROM attributes for up to 100 identities at a time.
     */
    public suspend fun getIdentityMailFromDomainAttributes(input: GetIdentityMailFromDomainAttributesRequest): GetIdentityMailFromDomainAttributesResponse

    /**
     * Given a list of verified identities (email addresses and/or domains), returns a structure describing identity notification attributes.
     *
     * This operation is throttled at one request per second and can only get notification attributes for up to 100 identities at a time.
     *
     * For more information about using notifications with Amazon SES, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications.html).
     */
    public suspend fun getIdentityNotificationAttributes(input: GetIdentityNotificationAttributesRequest): GetIdentityNotificationAttributesResponse

    /**
     * Returns the requested sending authorization policies for the given identity (an email address or a domain). The policies are returned as a map of policy names to policy contents. You can retrieve a maximum of 20 policies at a time.
     *
     * This operation is for the identity owner only. If you have not verified the identity, it returns an error.
     *
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun getIdentityPolicies(input: GetIdentityPoliciesRequest): GetIdentityPoliciesResponse

    /**
     * Given a list of identities (email addresses and/or domains), returns the verification status and (for domain identities) the verification token for each identity.
     *
     * The verification status of an email address is "Pending" until the email address owner clicks the link within the verification email that Amazon SES sent to that address. If the email address owner clicks the link within 24 hours, the verification status of the email address changes to "Success". If the link is not clicked within 24 hours, the verification status changes to "Failed." In that case, to verify the email address, you must restart the verification process from the beginning.
     *
     * For domain identities, the domain's verification status is "Pending" as Amazon SES searches for the required TXT record in the DNS settings of the domain. When Amazon SES detects the record, the domain's verification status changes to "Success". If Amazon SES is unable to detect the record within 72 hours, the domain's verification status changes to "Failed." In that case, to verify the domain, you must restart the verification process from the beginning.
     *
     * This operation is throttled at one request per second and can only get verification attributes for up to 100 identities at a time.
     */
    public suspend fun getIdentityVerificationAttributes(input: GetIdentityVerificationAttributesRequest): GetIdentityVerificationAttributesResponse

    /**
     * Provides the sending limits for the Amazon SES account.
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun getSendQuota(input: GetSendQuotaRequest = GetSendQuotaRequest { }): GetSendQuotaResponse

    /**
     * Provides sending statistics for the current Amazon Web Services Region. The result is a list of data points, representing the last two weeks of sending activity. Each data point in the list contains statistics for a 15-minute period of time.
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun getSendStatistics(input: GetSendStatisticsRequest = GetSendStatisticsRequest { }): GetSendStatisticsResponse

    /**
     * Displays the template object (which includes the Subject line, HTML part and text part) for the template you specify.
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun getTemplate(input: GetTemplateRequest): GetTemplateResponse

    /**
     * Provides a list of the configuration sets associated with your Amazon SES account in the current Amazon Web Services Region. For information about using configuration sets, see [Monitoring Your Amazon SES Sending Activity](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html) in the *Amazon SES Developer Guide.*
     *
     * You can execute this operation no more than once per second. This operation returns up to 1,000 configuration sets each time it is run. If your Amazon SES account has more than 1,000 configuration sets, this operation also returns `NextToken`. You can then execute the `ListConfigurationSets` operation again, passing the `NextToken` parameter and the value of the NextToken element to retrieve additional results.
     */
    public suspend fun listConfigurationSets(input: ListConfigurationSetsRequest = ListConfigurationSetsRequest { }): ListConfigurationSetsResponse

    /**
     * Lists the existing custom verification email templates for your account in the current Amazon Web Services Region.
     *
     * For more information about custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom) in the *Amazon SES Developer Guide*.
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun listCustomVerificationEmailTemplates(input: ListCustomVerificationEmailTemplatesRequest = ListCustomVerificationEmailTemplatesRequest { }): ListCustomVerificationEmailTemplatesResponse

    /**
     * Returns a list containing all of the identities (email addresses and domains) for your Amazon Web Services account in the current Amazon Web Services Region, regardless of verification status.
     *
     * You can execute this operation no more than once per second.
     *
     * It's recommended that for successive pagination calls of this API, you continue to the use the same parameter/value pairs as used in the original call, e.g., if you used `IdentityType=Domain` in the the original call and received a `NextToken` in the response, you should continue providing the `IdentityType=Domain` parameter for further `NextToken` calls; however, if you didn't provide the `IdentityType` parameter in the original call, then continue to not provide it for successive pagination calls. Using this protocol will ensure consistent results.
     */
    public suspend fun listIdentities(input: ListIdentitiesRequest = ListIdentitiesRequest { }): ListIdentitiesResponse

    /**
     * Returns a list of sending authorization policies that are attached to the given identity (an email address or a domain). This operation returns only a list. To get the actual policy content, use `GetIdentityPolicies`.
     *
     * This operation is for the identity owner only. If you have not verified the identity, it returns an error.
     *
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun listIdentityPolicies(input: ListIdentityPoliciesRequest): ListIdentityPoliciesResponse

    /**
     * Lists the IP address filters associated with your Amazon Web Services account in the current Amazon Web Services Region.
     *
     * For information about managing IP address filters, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-ip-filtering-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun listReceiptFilters(input: ListReceiptFiltersRequest = ListReceiptFiltersRequest { }): ListReceiptFiltersResponse

    /**
     * Lists the receipt rule sets that exist under your Amazon Web Services account in the current Amazon Web Services Region. If there are additional receipt rule sets to be retrieved, you receive a `NextToken` that you can provide to the next call to `ListReceiptRuleSets` to retrieve the additional entries.
     *
     * For information about managing receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun listReceiptRuleSets(input: ListReceiptRuleSetsRequest = ListReceiptRuleSetsRequest { }): ListReceiptRuleSetsResponse

    /**
     * Lists the email templates present in your Amazon SES account in the current Amazon Web Services Region.
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun listTemplates(input: ListTemplatesRequest = ListTemplatesRequest { }): ListTemplatesResponse

    /**
     * Deprecated. Use the `ListIdentities` operation to list the email addresses and domains associated with your account.
     */
    public suspend fun listVerifiedEmailAddresses(input: ListVerifiedEmailAddressesRequest = ListVerifiedEmailAddressesRequest { }): ListVerifiedEmailAddressesResponse

    /**
     * Adds or updates the delivery options for a configuration set.
     */
    public suspend fun putConfigurationSetDeliveryOptions(input: PutConfigurationSetDeliveryOptionsRequest): PutConfigurationSetDeliveryOptionsResponse

    /**
     * Adds or updates a sending authorization policy for the specified identity (an email address or a domain).
     *
     * This operation is for the identity owner only. If you have not verified the identity, it returns an error.
     *
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun putIdentityPolicy(input: PutIdentityPolicyRequest): PutIdentityPolicyResponse

    /**
     * Reorders the receipt rules within a receipt rule set.
     *
     * All of the rules in the rule set must be represented in this request. That is, it is error if the reorder request doesn't explicitly position all of the rules.
     *
     * For information about managing receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun reorderReceiptRuleSet(input: ReorderReceiptRuleSetRequest): ReorderReceiptRuleSetResponse

    /**
     * Generates and sends a bounce message to the sender of an email you received through Amazon SES. You can only use this operation on an email up to 24 hours after you receive it.
     *
     * You cannot use this operation to send generic bounces for mail that was not received by Amazon SES.
     *
     * For information about receiving email through Amazon SES, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun sendBounce(input: SendBounceRequest): SendBounceResponse

    /**
     * Composes an email message to multiple destinations. The message body is created using an email template.
     *
     * To send email using this operation, your call must meet the following requirements:
     * + The call must refer to an existing email template. You can create email templates using CreateTemplate.
     * + The message must be sent from a verified email address or domain.
     * + If your account is still in the Amazon SES sandbox, you may send only to verified addresses or domains, or to email addresses associated with the Amazon SES Mailbox Simulator. For more information, see [Verifying Email Addresses and Domains](https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html) in the *Amazon SES Developer Guide.*
     * + The maximum message size is 10 MB.
     * + Each `Destination` parameter must include at least one recipient email address. The recipient address can be a To: address, a CC: address, or a BCC: address. If a recipient email address is invalid (that is, it is not in the format *UserName@&#91;SubDomain.&#93;Domain.TopLevelDomain*), the entire message is rejected, even if the message contains other recipients that are valid.
     * + The message may not include more than 50 recipients, across the To:, CC: and BCC: fields. If you need to send an email message to a larger audience, you can divide your recipient list into groups of 50 or fewer, and then call the `SendBulkTemplatedEmail` operation several times to send the message to each group.
     * + The number of destinations you can contact in a single call can be limited by your account's maximum sending rate.
     */
    public suspend fun sendBulkTemplatedEmail(input: SendBulkTemplatedEmailRequest): SendBulkTemplatedEmailResponse

    /**
     * Adds an email address to the list of identities for your Amazon SES account in the current Amazon Web Services Region and attempts to verify it. As a result of executing this operation, a customized verification email is sent to the specified address.
     *
     * To use this operation, you must first create a custom verification email template. For more information about creating and using custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom) in the *Amazon SES Developer Guide*.
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun sendCustomVerificationEmail(input: SendCustomVerificationEmailRequest): SendCustomVerificationEmailResponse

    /**
     * Composes an email message and immediately queues it for sending. To send email using this operation, your message must meet the following requirements:
     * + The message must be sent from a verified email address or domain. If you attempt to send email using a non-verified address or domain, the operation results in an "Email address not verified" error.
     * + If your account is still in the Amazon SES sandbox, you may only send to verified addresses or domains, or to email addresses associated with the Amazon SES Mailbox Simulator. For more information, see [Verifying Email Addresses and Domains](https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html) in the *Amazon SES Developer Guide.*
     * + The maximum message size is 10 MB.
     * + The message must include at least one recipient email address. The recipient address can be a To: address, a CC: address, or a BCC: address. If a recipient email address is invalid (that is, it is not in the format *UserName@&#91;SubDomain.&#93;Domain.TopLevelDomain*), the entire message is rejected, even if the message contains other recipients that are valid.
     * + The message may not include more than 50 recipients, across the To:, CC: and BCC: fields. If you need to send an email message to a larger audience, you can divide your recipient list into groups of 50 or fewer, and then call the `SendEmail` operation several times to send the message to each group.
     *
     * For every message that you send, the total number of recipients (including each recipient in the To:, CC: and BCC: fields) is counted against the maximum number of emails you can send in a 24-hour period (your *sending quota*). For more information about sending quotas in Amazon SES, see [Managing Your Amazon SES Sending Limits](https://docs.aws.amazon.com/ses/latest/dg/manage-sending-quotas.html) in the *Amazon SES Developer Guide.*
     */
    public suspend fun sendEmail(input: SendEmailRequest): SendEmailResponse

    /**
     * Composes an email message and immediately queues it for sending.
     *
     * This operation is more flexible than the `SendEmail` operation. When you use the `SendRawEmail` operation, you can specify the headers of the message as well as its content. This flexibility is useful, for example, when you need to send a multipart MIME email (such a message that contains both a text and an HTML version). You can also use this operation to send messages that include attachments.
     *
     * The `SendRawEmail` operation has the following requirements:
     * + You can only send email from [verified email addresses or domains](https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html). If you try to send email from an address that isn't verified, the operation results in an "Email address not verified" error.
     * + If your account is still in the [Amazon SES sandbox](https://docs.aws.amazon.com/ses/latest/dg/request-production-access.html), you can only send email to other verified addresses in your account, or to addresses that are associated with the [Amazon SES mailbox simulator](https://docs.aws.amazon.com/ses/latest/dg/send-an-email-from-console.html).
     * + The maximum message size, including attachments, is 10 MB.
     * + Each message has to include at least one recipient address. A recipient address includes any address on the To:, CC:, or BCC: lines.
     * + If you send a single message to more than one recipient address, and one of the recipient addresses isn't in a valid format (that is, it's not in the format *UserName@&#91;SubDomain.&#93;Domain.TopLevelDomain*), Amazon SES rejects the entire message, even if the other addresses are valid.
     * + Each message can include up to 50 recipient addresses across the To:, CC:, or BCC: lines. If you need to send a single message to more than 50 recipients, you have to split the list of recipient addresses into groups of less than 50 recipients, and send separate messages to each group.
     * + Amazon SES allows you to specify 8-bit Content-Transfer-Encoding for MIME message parts. However, if Amazon SES has to modify the contents of your message (for example, if you use open and click tracking), 8-bit content isn't preserved. For this reason, we highly recommend that you encode all content that isn't 7-bit ASCII. For more information, see [MIME Encoding](https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html#send-email-mime-encoding) in the *Amazon SES Developer Guide*.
     *
     * Additionally, keep the following considerations in mind when using the `SendRawEmail` operation:
     * + Although you can customize the message headers when using the `SendRawEmail` operation, Amazon SES automatically applies its own `Message-ID` and `Date` headers; if you passed these headers when creating the message, they are overwritten by the values that Amazon SES provides.
     * + If you are using sending authorization to send on behalf of another user, `SendRawEmail` enables you to specify the cross-account identity for the email's Source, From, and Return-Path parameters in one of two ways: you can pass optional parameters `SourceArn`, `FromArn`, and/or `ReturnPathArn`, or you can include the following X-headers in the header of your raw email:
     *    + `X-SES-SOURCE-ARN`
     *    + `X-SES-FROM-ARN`
     *    + `X-SES-RETURN-PATH-ARN`
     * Don't include these X-headers in the DKIM signature. Amazon SES removes these before it sends the email.If you only specify the `SourceIdentityArn` parameter, Amazon SES sets the From and Return-Path addresses to the same identity that you specified.For more information about sending authorization, see the [Using Sending Authorization with Amazon SES](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html) in the *Amazon SES Developer Guide.*
     * + For every message that you send, the total number of recipients (including each recipient in the To:, CC: and BCC: fields) is counted against the maximum number of emails you can send in a 24-hour period (your *sending quota*). For more information about sending quotas in Amazon SES, see [Managing Your Amazon SES Sending Limits](https://docs.aws.amazon.com/ses/latest/dg/manage-sending-quotas.html) in the *Amazon SES Developer Guide.*
     */
    public suspend fun sendRawEmail(input: SendRawEmailRequest): SendRawEmailResponse

    /**
     * Composes an email message using an email template and immediately queues it for sending.
     *
     * To send email using this operation, your call must meet the following requirements:
     * + The call must refer to an existing email template. You can create email templates using the CreateTemplate operation.
     * + The message must be sent from a verified email address or domain.
     * + If your account is still in the Amazon SES sandbox, you may only send to verified addresses or domains, or to email addresses associated with the Amazon SES Mailbox Simulator. For more information, see [Verifying Email Addresses and Domains](https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html) in the *Amazon SES Developer Guide.*
     * + The maximum message size is 10 MB.
     * + Calls to the `SendTemplatedEmail` operation may only include one `Destination` parameter. A destination is a set of recipients that receives the same version of the email. The `Destination` parameter can include up to 50 recipients, across the To:, CC: and BCC: fields.
     * + The `Destination` parameter must include at least one recipient email address. The recipient address can be a To: address, a CC: address, or a BCC: address. If a recipient email address is invalid (that is, it is not in the format *UserName@&#91;SubDomain.&#93;Domain.TopLevelDomain*), the entire message is rejected, even if the message contains other recipients that are valid.
     *
     * If your call to the `SendTemplatedEmail` operation includes all of the required parameters, Amazon SES accepts it and returns a Message ID. However, if Amazon SES can't render the email because the template contains errors, it doesn't send the email. Additionally, because it already accepted the message, Amazon SES doesn't return a message stating that it was unable to send the email.
     *
     * For these reasons, we highly recommend that you set up Amazon SES to send you notifications when Rendering Failure events occur. For more information, see [Sending Personalized Email Using the Amazon SES API](https://docs.aws.amazon.com/ses/latest/dg/send-personalized-email-api.html) in the *Amazon Simple Email Service Developer Guide*.
     */
    public suspend fun sendTemplatedEmail(input: SendTemplatedEmailRequest): SendTemplatedEmailResponse

    /**
     * Sets the specified receipt rule set as the active receipt rule set.
     *
     * To disable your email-receiving through Amazon SES completely, you can call this operation with `RuleSetName` set to null.
     *
     * For information about managing receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun setActiveReceiptRuleSet(input: SetActiveReceiptRuleSetRequest = SetActiveReceiptRuleSetRequest { }): SetActiveReceiptRuleSetResponse

    /**
     * Enables or disables Easy DKIM signing of email sent from an identity. If Easy DKIM signing is enabled for a domain, then Amazon SES uses DKIM to sign all email that it sends from addresses on that domain. If Easy DKIM signing is enabled for an email address, then Amazon SES uses DKIM to sign all email it sends from that address.
     *
     * For email addresses (for example, `user@example.com`), you can only enable DKIM signing if the corresponding domain (in this case, `example.com`) has been set up to use Easy DKIM.
     *
     * You can enable DKIM signing for an identity at any time after you start the verification process for the identity, even if the verification process isn't complete.
     *
     * You can execute this operation no more than once per second.
     *
     * For more information about Easy DKIM signing, go to the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
     */
    public suspend fun setIdentityDkimEnabled(input: SetIdentityDkimEnabledRequest): SetIdentityDkimEnabledResponse

    /**
     * Given an identity (an email address or a domain), enables or disables whether Amazon SES forwards bounce and complaint notifications as email. Feedback forwarding can only be disabled when Amazon Simple Notification Service (Amazon SNS) topics are specified for both bounces and complaints.
     *
     * Feedback forwarding does not apply to delivery notifications. Delivery notifications are only available through Amazon SNS.
     *
     * You can execute this operation no more than once per second.
     *
     * For more information about using notifications with Amazon SES, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications.html).
     */
    public suspend fun setIdentityFeedbackForwardingEnabled(input: SetIdentityFeedbackForwardingEnabledRequest): SetIdentityFeedbackForwardingEnabledResponse

    /**
     * Given an identity (an email address or a domain), sets whether Amazon SES includes the original email headers in the Amazon Simple Notification Service (Amazon SNS) notifications of a specified type.
     *
     * You can execute this operation no more than once per second.
     *
     * For more information about using notifications with Amazon SES, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications.html).
     */
    public suspend fun setIdentityHeadersInNotificationsEnabled(input: SetIdentityHeadersInNotificationsEnabledRequest): SetIdentityHeadersInNotificationsEnabledResponse

    /**
     * Enables or disables the custom MAIL FROM domain setup for a verified identity (an email address or a domain).
     *
     * To send emails using the specified MAIL FROM domain, you must add an MX record to your MAIL FROM domain's DNS settings. To ensure that your emails pass Sender Policy Framework (SPF) checks, you must also add or update an SPF record. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/mail-from.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun setIdentityMailFromDomain(input: SetIdentityMailFromDomainRequest): SetIdentityMailFromDomainResponse

    /**
     * Sets an Amazon Simple Notification Service (Amazon SNS) topic to use when delivering notifications. When you use this operation, you specify a verified identity, such as an email address or domain. When you send an email that uses the chosen identity in the Source field, Amazon SES sends notifications to the topic you specified. You can send bounce, complaint, or delivery notifications (or any combination of the three) to the Amazon SNS topic that you specify.
     *
     * You can execute this operation no more than once per second.
     *
     * For more information about feedback notification, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications.html).
     */
    public suspend fun setIdentityNotificationTopic(input: SetIdentityNotificationTopicRequest): SetIdentityNotificationTopicResponse

    /**
     * Sets the position of the specified receipt rule in the receipt rule set.
     *
     * For information about managing receipt rules, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun setReceiptRulePosition(input: SetReceiptRulePositionRequest): SetReceiptRulePositionResponse

    /**
     * Creates a preview of the MIME content of an email when provided with a template and a set of replacement data.
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun testRenderTemplate(input: TestRenderTemplateRequest): TestRenderTemplateResponse

    /**
     * Enables or disables email sending across your entire Amazon SES account in the current Amazon Web Services Region. You can use this operation in conjunction with Amazon CloudWatch alarms to temporarily pause email sending across your Amazon SES account in a given Amazon Web Services Region when reputation metrics (such as your bounce or complaint rates) reach certain thresholds.
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun updateAccountSendingEnabled(input: UpdateAccountSendingEnabledRequest = UpdateAccountSendingEnabledRequest { }): UpdateAccountSendingEnabledResponse

    /**
     * Updates the event destination of a configuration set. Event destinations are associated with configuration sets, which enable you to publish email sending events to Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS). For information about using configuration sets, see [Monitoring Your Amazon SES Sending Activity](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html) in the *Amazon SES Developer Guide.*
     *
     * When you create or update an event destination, you must provide one, and only one, destination. The destination can be Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun updateConfigurationSetEventDestination(input: UpdateConfigurationSetEventDestinationRequest): UpdateConfigurationSetEventDestinationResponse

    /**
     * Enables or disables the publishing of reputation metrics for emails sent using a specific configuration set in a given Amazon Web Services Region. Reputation metrics include bounce and complaint rates. These metrics are published to Amazon CloudWatch. By using CloudWatch, you can create alarms when bounce or complaint rates exceed certain thresholds.
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun updateConfigurationSetReputationMetricsEnabled(input: UpdateConfigurationSetReputationMetricsEnabledRequest): UpdateConfigurationSetReputationMetricsEnabledResponse

    /**
     * Enables or disables email sending for messages sent using a specific configuration set in a given Amazon Web Services Region. You can use this operation in conjunction with Amazon CloudWatch alarms to temporarily pause email sending for a configuration set when the reputation metrics for that configuration set (such as your bounce on complaint rate) exceed certain thresholds.
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun updateConfigurationSetSendingEnabled(input: UpdateConfigurationSetSendingEnabledRequest): UpdateConfigurationSetSendingEnabledResponse

    /**
     * Modifies an association between a configuration set and a custom domain for open and click event tracking.
     *
     * By default, images and links used for tracking open and click events are hosted on domains operated by Amazon SES. You can configure a subdomain of your own to handle these events. For information about using custom domains, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/configure-custom-open-click-domains.html).
     */
    public suspend fun updateConfigurationSetTrackingOptions(input: UpdateConfigurationSetTrackingOptionsRequest): UpdateConfigurationSetTrackingOptionsResponse

    /**
     * Updates an existing custom verification email template.
     *
     * For more information about custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom) in the *Amazon SES Developer Guide*.
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun updateCustomVerificationEmailTemplate(input: UpdateCustomVerificationEmailTemplateRequest): UpdateCustomVerificationEmailTemplateResponse

    /**
     * Updates a receipt rule.
     *
     * For information about managing receipt rules, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun updateReceiptRule(input: UpdateReceiptRuleRequest): UpdateReceiptRuleResponse

    /**
     * Updates an email template. Email templates enable you to send personalized email to one or more destinations in a single operation. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-personalized-email-api.html).
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun updateTemplate(input: UpdateTemplateRequest): UpdateTemplateResponse

    /**
     * Returns a set of DKIM tokens for a domain identity.
     *
     * When you execute the `VerifyDomainDkim` operation, the domain that you specify is added to the list of identities that are associated with your account. This is true even if you haven't already associated the domain with your account by using the `VerifyDomainIdentity` operation. However, you can't send email from the domain until you either successfully [verify it](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#verify-domain-procedure) or you successfully [set up DKIM for it](https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
     *
     * You use the tokens that are generated by this operation to create CNAME records. When Amazon SES detects that you've added these records to the DNS configuration for a domain, you can start sending email from that domain. You can start sending email even if you haven't added the TXT record provided by the VerifyDomainIdentity operation to the DNS configuration for your domain. All email that you send from the domain is authenticated using DKIM.
     *
     * To create the CNAME records for DKIM authentication, use the following values:
     * + **Name**: *token*._domainkey.*example.com*
     * + **Type**: CNAME
     * + **Value**: *token*.dkim.amazonses.com
     *
     * In the preceding example, replace *token* with one of the tokens that are generated when you execute this operation. Replace *example.com* with your domain. Repeat this process for each token that's generated by this operation.
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun verifyDomainDkim(input: VerifyDomainDkimRequest): VerifyDomainDkimResponse

    /**
     * Adds a domain to the list of identities for your Amazon SES account in the current Amazon Web Services Region and attempts to verify it. For more information about verifying domains, see [Verifying Email Addresses and Domains](https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html) in the *Amazon SES Developer Guide.*
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun verifyDomainIdentity(input: VerifyDomainIdentityRequest): VerifyDomainIdentityResponse

    /**
     * Deprecated. Use the `VerifyEmailIdentity` operation to verify a new email address.
     */
    public suspend fun verifyEmailAddress(input: VerifyEmailAddressRequest): VerifyEmailAddressResponse

    /**
     * Adds an email address to the list of identities for your Amazon SES account in the current Amazon Web Services Region and attempts to verify it. As a result of executing this operation, a verification email is sent to the specified address.
     *
     * You can execute this operation no more than once per second.
     */
    public suspend fun verifyEmailIdentity(input: VerifyEmailIdentityRequest): VerifyEmailIdentityResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SesClient.withConfig(block: SesClient.Config.Builder.() -> Unit): SesClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSesClient(newConfig)
}

/**
 * Creates a receipt rule set by cloning an existing one. All receipt rules and configurations are copied to the new receipt rule set and are completely independent of the source rule set.
 *
 * For information about setting up rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html#receiving-email-concepts-rules).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.cloneReceiptRuleSet(crossinline block: CloneReceiptRuleSetRequest.Builder.() -> Unit): CloneReceiptRuleSetResponse = cloneReceiptRuleSet(CloneReceiptRuleSetRequest.Builder().apply(block).build())

/**
 * Creates a configuration set.
 *
 * Configuration sets enable you to publish email sending events. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.createConfigurationSet(crossinline block: CreateConfigurationSetRequest.Builder.() -> Unit): CreateConfigurationSetResponse = createConfigurationSet(CreateConfigurationSetRequest.Builder().apply(block).build())

/**
 * Creates a configuration set event destination.
 *
 * When you create or update an event destination, you must provide one, and only one, destination. The destination can be CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).
 *
 * An event destination is the Amazon Web Services service to which Amazon SES publishes the email sending events associated with a configuration set. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.createConfigurationSetEventDestination(crossinline block: CreateConfigurationSetEventDestinationRequest.Builder.() -> Unit): CreateConfigurationSetEventDestinationResponse = createConfigurationSetEventDestination(CreateConfigurationSetEventDestinationRequest.Builder().apply(block).build())

/**
 * Creates an association between a configuration set and a custom domain for open and click event tracking.
 *
 * By default, images and links used for tracking open and click events are hosted on domains operated by Amazon SES. You can configure a subdomain of your own to handle these events. For information about using custom domains, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/configure-custom-open-click-domains.html).
 */
public suspend inline fun SesClient.createConfigurationSetTrackingOptions(crossinline block: CreateConfigurationSetTrackingOptionsRequest.Builder.() -> Unit): CreateConfigurationSetTrackingOptionsResponse = createConfigurationSetTrackingOptions(CreateConfigurationSetTrackingOptionsRequest.Builder().apply(block).build())

/**
 * Creates a new custom verification email template.
 *
 * For more information about custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom) in the *Amazon SES Developer Guide*.
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.createCustomVerificationEmailTemplate(crossinline block: CreateCustomVerificationEmailTemplateRequest.Builder.() -> Unit): CreateCustomVerificationEmailTemplateResponse = createCustomVerificationEmailTemplate(CreateCustomVerificationEmailTemplateRequest.Builder().apply(block).build())

/**
 * Creates a new IP address filter.
 *
 * For information about setting up IP address filters, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-ip-filtering-console-walkthrough.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.createReceiptFilter(crossinline block: CreateReceiptFilterRequest.Builder.() -> Unit): CreateReceiptFilterResponse = createReceiptFilter(CreateReceiptFilterRequest.Builder().apply(block).build())

/**
 * Creates a receipt rule.
 *
 * For information about setting up receipt rules, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.createReceiptRule(crossinline block: CreateReceiptRuleRequest.Builder.() -> Unit): CreateReceiptRuleResponse = createReceiptRule(CreateReceiptRuleRequest.Builder().apply(block).build())

/**
 * Creates an empty receipt rule set.
 *
 * For information about setting up receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html#receiving-email-concepts-rules).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.createReceiptRuleSet(crossinline block: CreateReceiptRuleSetRequest.Builder.() -> Unit): CreateReceiptRuleSetResponse = createReceiptRuleSet(CreateReceiptRuleSetRequest.Builder().apply(block).build())

/**
 * Creates an email template. Email templates enable you to send personalized email to one or more destinations in a single operation. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-personalized-email-api.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.createTemplate(crossinline block: CreateTemplateRequest.Builder.() -> Unit): CreateTemplateResponse = createTemplate(CreateTemplateRequest.Builder().apply(block).build())

/**
 * Deletes a configuration set. Configuration sets enable you to publish email sending events. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.deleteConfigurationSet(crossinline block: DeleteConfigurationSetRequest.Builder.() -> Unit): DeleteConfigurationSetResponse = deleteConfigurationSet(DeleteConfigurationSetRequest.Builder().apply(block).build())

/**
 * Deletes a configuration set event destination. Configuration set event destinations are associated with configuration sets, which enable you to publish email sending events. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.deleteConfigurationSetEventDestination(crossinline block: DeleteConfigurationSetEventDestinationRequest.Builder.() -> Unit): DeleteConfigurationSetEventDestinationResponse = deleteConfigurationSetEventDestination(DeleteConfigurationSetEventDestinationRequest.Builder().apply(block).build())

/**
 * Deletes an association between a configuration set and a custom domain for open and click event tracking.
 *
 * By default, images and links used for tracking open and click events are hosted on domains operated by Amazon SES. You can configure a subdomain of your own to handle these events. For information about using custom domains, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/configure-custom-open-click-domains.html).
 *
 * Deleting this kind of association results in emails sent using the specified configuration set to capture open and click events using the standard, Amazon SES-operated domains.
 */
public suspend inline fun SesClient.deleteConfigurationSetTrackingOptions(crossinline block: DeleteConfigurationSetTrackingOptionsRequest.Builder.() -> Unit): DeleteConfigurationSetTrackingOptionsResponse = deleteConfigurationSetTrackingOptions(DeleteConfigurationSetTrackingOptionsRequest.Builder().apply(block).build())

/**
 * Deletes an existing custom verification email template.
 *
 * For more information about custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom) in the *Amazon SES Developer Guide*.
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.deleteCustomVerificationEmailTemplate(crossinline block: DeleteCustomVerificationEmailTemplateRequest.Builder.() -> Unit): DeleteCustomVerificationEmailTemplateResponse = deleteCustomVerificationEmailTemplate(DeleteCustomVerificationEmailTemplateRequest.Builder().apply(block).build())

/**
 * Deletes the specified identity (an email address or a domain) from the list of verified identities.
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.deleteIdentity(crossinline block: DeleteIdentityRequest.Builder.() -> Unit): DeleteIdentityResponse = deleteIdentity(DeleteIdentityRequest.Builder().apply(block).build())

/**
 * Deletes the specified sending authorization policy for the given identity (an email address or a domain). This operation returns successfully even if a policy with the specified name does not exist.
 *
 * This operation is for the identity owner only. If you have not verified the identity, it returns an error.
 *
 * Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.deleteIdentityPolicy(crossinline block: DeleteIdentityPolicyRequest.Builder.() -> Unit): DeleteIdentityPolicyResponse = deleteIdentityPolicy(DeleteIdentityPolicyRequest.Builder().apply(block).build())

/**
 * Deletes the specified IP address filter.
 *
 * For information about managing IP address filters, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-ip-filtering-console-walkthrough.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.deleteReceiptFilter(crossinline block: DeleteReceiptFilterRequest.Builder.() -> Unit): DeleteReceiptFilterResponse = deleteReceiptFilter(DeleteReceiptFilterRequest.Builder().apply(block).build())

/**
 * Deletes the specified receipt rule.
 *
 * For information about managing receipt rules, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.deleteReceiptRule(crossinline block: DeleteReceiptRuleRequest.Builder.() -> Unit): DeleteReceiptRuleResponse = deleteReceiptRule(DeleteReceiptRuleRequest.Builder().apply(block).build())

/**
 * Deletes the specified receipt rule set and all of the receipt rules it contains.
 *
 * The currently active rule set cannot be deleted.
 *
 * For information about managing receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.deleteReceiptRuleSet(crossinline block: DeleteReceiptRuleSetRequest.Builder.() -> Unit): DeleteReceiptRuleSetResponse = deleteReceiptRuleSet(DeleteReceiptRuleSetRequest.Builder().apply(block).build())

/**
 * Deletes an email template.
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.deleteTemplate(crossinline block: DeleteTemplateRequest.Builder.() -> Unit): DeleteTemplateResponse = deleteTemplate(DeleteTemplateRequest.Builder().apply(block).build())

/**
 * Deprecated. Use the `DeleteIdentity` operation to delete email addresses and domains.
 */
public suspend inline fun SesClient.deleteVerifiedEmailAddress(crossinline block: DeleteVerifiedEmailAddressRequest.Builder.() -> Unit): DeleteVerifiedEmailAddressResponse = deleteVerifiedEmailAddress(DeleteVerifiedEmailAddressRequest.Builder().apply(block).build())

/**
 * Returns the metadata and receipt rules for the receipt rule set that is currently active.
 *
 * For information about setting up receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html#receiving-email-concepts-rules).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.describeActiveReceiptRuleSet(crossinline block: DescribeActiveReceiptRuleSetRequest.Builder.() -> Unit): DescribeActiveReceiptRuleSetResponse = describeActiveReceiptRuleSet(DescribeActiveReceiptRuleSetRequest.Builder().apply(block).build())

/**
 * Returns the details of the specified configuration set. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.describeConfigurationSet(crossinline block: DescribeConfigurationSetRequest.Builder.() -> Unit): DescribeConfigurationSetResponse = describeConfigurationSet(DescribeConfigurationSetRequest.Builder().apply(block).build())

/**
 * Returns the details of the specified receipt rule.
 *
 * For information about setting up receipt rules, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.describeReceiptRule(crossinline block: DescribeReceiptRuleRequest.Builder.() -> Unit): DescribeReceiptRuleResponse = describeReceiptRule(DescribeReceiptRuleRequest.Builder().apply(block).build())

/**
 * Returns the details of the specified receipt rule set.
 *
 * For information about managing receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.describeReceiptRuleSet(crossinline block: DescribeReceiptRuleSetRequest.Builder.() -> Unit): DescribeReceiptRuleSetResponse = describeReceiptRuleSet(DescribeReceiptRuleSetRequest.Builder().apply(block).build())

/**
 * Returns the email sending status of the Amazon SES account for the current Region.
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.getAccountSendingEnabled(crossinline block: GetAccountSendingEnabledRequest.Builder.() -> Unit): GetAccountSendingEnabledResponse = getAccountSendingEnabled(GetAccountSendingEnabledRequest.Builder().apply(block).build())

/**
 * Returns the custom email verification template for the template name you specify.
 *
 * For more information about custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom) in the *Amazon SES Developer Guide*.
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.getCustomVerificationEmailTemplate(crossinline block: GetCustomVerificationEmailTemplateRequest.Builder.() -> Unit): GetCustomVerificationEmailTemplateResponse = getCustomVerificationEmailTemplate(GetCustomVerificationEmailTemplateRequest.Builder().apply(block).build())

/**
 * Returns the current status of Easy DKIM signing for an entity. For domain name identities, this operation also returns the DKIM tokens that are required for Easy DKIM signing, and whether Amazon SES has successfully verified that these tokens have been published.
 *
 * This operation takes a list of identities as input and returns the following information for each:
 * + Whether Easy DKIM signing is enabled or disabled.
 * + A set of DKIM tokens that represent the identity. If the identity is an email address, the tokens represent the domain of that address.
 * + Whether Amazon SES has successfully verified the DKIM tokens published in the domain's DNS. This information is only returned for domain name identities, not for email addresses.
 *
 * This operation is throttled at one request per second and can only get DKIM attributes for up to 100 identities at a time.
 *
 * For more information about creating DNS records using DKIM tokens, go to the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy-managing.html).
 */
public suspend inline fun SesClient.getIdentityDkimAttributes(crossinline block: GetIdentityDkimAttributesRequest.Builder.() -> Unit): GetIdentityDkimAttributesResponse = getIdentityDkimAttributes(GetIdentityDkimAttributesRequest.Builder().apply(block).build())

/**
 * Returns the custom MAIL FROM attributes for a list of identities (email addresses : domains).
 *
 * This operation is throttled at one request per second and can only get custom MAIL FROM attributes for up to 100 identities at a time.
 */
public suspend inline fun SesClient.getIdentityMailFromDomainAttributes(crossinline block: GetIdentityMailFromDomainAttributesRequest.Builder.() -> Unit): GetIdentityMailFromDomainAttributesResponse = getIdentityMailFromDomainAttributes(GetIdentityMailFromDomainAttributesRequest.Builder().apply(block).build())

/**
 * Given a list of verified identities (email addresses and/or domains), returns a structure describing identity notification attributes.
 *
 * This operation is throttled at one request per second and can only get notification attributes for up to 100 identities at a time.
 *
 * For more information about using notifications with Amazon SES, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications.html).
 */
public suspend inline fun SesClient.getIdentityNotificationAttributes(crossinline block: GetIdentityNotificationAttributesRequest.Builder.() -> Unit): GetIdentityNotificationAttributesResponse = getIdentityNotificationAttributes(GetIdentityNotificationAttributesRequest.Builder().apply(block).build())

/**
 * Returns the requested sending authorization policies for the given identity (an email address or a domain). The policies are returned as a map of policy names to policy contents. You can retrieve a maximum of 20 policies at a time.
 *
 * This operation is for the identity owner only. If you have not verified the identity, it returns an error.
 *
 * Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.getIdentityPolicies(crossinline block: GetIdentityPoliciesRequest.Builder.() -> Unit): GetIdentityPoliciesResponse = getIdentityPolicies(GetIdentityPoliciesRequest.Builder().apply(block).build())

/**
 * Given a list of identities (email addresses and/or domains), returns the verification status and (for domain identities) the verification token for each identity.
 *
 * The verification status of an email address is "Pending" until the email address owner clicks the link within the verification email that Amazon SES sent to that address. If the email address owner clicks the link within 24 hours, the verification status of the email address changes to "Success". If the link is not clicked within 24 hours, the verification status changes to "Failed." In that case, to verify the email address, you must restart the verification process from the beginning.
 *
 * For domain identities, the domain's verification status is "Pending" as Amazon SES searches for the required TXT record in the DNS settings of the domain. When Amazon SES detects the record, the domain's verification status changes to "Success". If Amazon SES is unable to detect the record within 72 hours, the domain's verification status changes to "Failed." In that case, to verify the domain, you must restart the verification process from the beginning.
 *
 * This operation is throttled at one request per second and can only get verification attributes for up to 100 identities at a time.
 */
public suspend inline fun SesClient.getIdentityVerificationAttributes(crossinline block: GetIdentityVerificationAttributesRequest.Builder.() -> Unit): GetIdentityVerificationAttributesResponse = getIdentityVerificationAttributes(GetIdentityVerificationAttributesRequest.Builder().apply(block).build())

/**
 * Provides the sending limits for the Amazon SES account.
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.getSendQuota(crossinline block: GetSendQuotaRequest.Builder.() -> Unit): GetSendQuotaResponse = getSendQuota(GetSendQuotaRequest.Builder().apply(block).build())

/**
 * Provides sending statistics for the current Amazon Web Services Region. The result is a list of data points, representing the last two weeks of sending activity. Each data point in the list contains statistics for a 15-minute period of time.
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.getSendStatistics(crossinline block: GetSendStatisticsRequest.Builder.() -> Unit): GetSendStatisticsResponse = getSendStatistics(GetSendStatisticsRequest.Builder().apply(block).build())

/**
 * Displays the template object (which includes the Subject line, HTML part and text part) for the template you specify.
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.getTemplate(crossinline block: GetTemplateRequest.Builder.() -> Unit): GetTemplateResponse = getTemplate(GetTemplateRequest.Builder().apply(block).build())

/**
 * Provides a list of the configuration sets associated with your Amazon SES account in the current Amazon Web Services Region. For information about using configuration sets, see [Monitoring Your Amazon SES Sending Activity](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html) in the *Amazon SES Developer Guide.*
 *
 * You can execute this operation no more than once per second. This operation returns up to 1,000 configuration sets each time it is run. If your Amazon SES account has more than 1,000 configuration sets, this operation also returns `NextToken`. You can then execute the `ListConfigurationSets` operation again, passing the `NextToken` parameter and the value of the NextToken element to retrieve additional results.
 */
public suspend inline fun SesClient.listConfigurationSets(crossinline block: ListConfigurationSetsRequest.Builder.() -> Unit): ListConfigurationSetsResponse = listConfigurationSets(ListConfigurationSetsRequest.Builder().apply(block).build())

/**
 * Lists the existing custom verification email templates for your account in the current Amazon Web Services Region.
 *
 * For more information about custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom) in the *Amazon SES Developer Guide*.
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.listCustomVerificationEmailTemplates(crossinline block: ListCustomVerificationEmailTemplatesRequest.Builder.() -> Unit): ListCustomVerificationEmailTemplatesResponse = listCustomVerificationEmailTemplates(ListCustomVerificationEmailTemplatesRequest.Builder().apply(block).build())

/**
 * Returns a list containing all of the identities (email addresses and domains) for your Amazon Web Services account in the current Amazon Web Services Region, regardless of verification status.
 *
 * You can execute this operation no more than once per second.
 *
 * It's recommended that for successive pagination calls of this API, you continue to the use the same parameter/value pairs as used in the original call, e.g., if you used `IdentityType=Domain` in the the original call and received a `NextToken` in the response, you should continue providing the `IdentityType=Domain` parameter for further `NextToken` calls; however, if you didn't provide the `IdentityType` parameter in the original call, then continue to not provide it for successive pagination calls. Using this protocol will ensure consistent results.
 */
public suspend inline fun SesClient.listIdentities(crossinline block: ListIdentitiesRequest.Builder.() -> Unit): ListIdentitiesResponse = listIdentities(ListIdentitiesRequest.Builder().apply(block).build())

/**
 * Returns a list of sending authorization policies that are attached to the given identity (an email address or a domain). This operation returns only a list. To get the actual policy content, use `GetIdentityPolicies`.
 *
 * This operation is for the identity owner only. If you have not verified the identity, it returns an error.
 *
 * Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.listIdentityPolicies(crossinline block: ListIdentityPoliciesRequest.Builder.() -> Unit): ListIdentityPoliciesResponse = listIdentityPolicies(ListIdentityPoliciesRequest.Builder().apply(block).build())

/**
 * Lists the IP address filters associated with your Amazon Web Services account in the current Amazon Web Services Region.
 *
 * For information about managing IP address filters, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-ip-filtering-console-walkthrough.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.listReceiptFilters(crossinline block: ListReceiptFiltersRequest.Builder.() -> Unit): ListReceiptFiltersResponse = listReceiptFilters(ListReceiptFiltersRequest.Builder().apply(block).build())

/**
 * Lists the receipt rule sets that exist under your Amazon Web Services account in the current Amazon Web Services Region. If there are additional receipt rule sets to be retrieved, you receive a `NextToken` that you can provide to the next call to `ListReceiptRuleSets` to retrieve the additional entries.
 *
 * For information about managing receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.listReceiptRuleSets(crossinline block: ListReceiptRuleSetsRequest.Builder.() -> Unit): ListReceiptRuleSetsResponse = listReceiptRuleSets(ListReceiptRuleSetsRequest.Builder().apply(block).build())

/**
 * Lists the email templates present in your Amazon SES account in the current Amazon Web Services Region.
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.listTemplates(crossinline block: ListTemplatesRequest.Builder.() -> Unit): ListTemplatesResponse = listTemplates(ListTemplatesRequest.Builder().apply(block).build())

/**
 * Deprecated. Use the `ListIdentities` operation to list the email addresses and domains associated with your account.
 */
public suspend inline fun SesClient.listVerifiedEmailAddresses(crossinline block: ListVerifiedEmailAddressesRequest.Builder.() -> Unit): ListVerifiedEmailAddressesResponse = listVerifiedEmailAddresses(ListVerifiedEmailAddressesRequest.Builder().apply(block).build())

/**
 * Adds or updates the delivery options for a configuration set.
 */
public suspend inline fun SesClient.putConfigurationSetDeliveryOptions(crossinline block: PutConfigurationSetDeliveryOptionsRequest.Builder.() -> Unit): PutConfigurationSetDeliveryOptionsResponse = putConfigurationSetDeliveryOptions(PutConfigurationSetDeliveryOptionsRequest.Builder().apply(block).build())

/**
 * Adds or updates a sending authorization policy for the specified identity (an email address or a domain).
 *
 * This operation is for the identity owner only. If you have not verified the identity, it returns an error.
 *
 * Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.putIdentityPolicy(crossinline block: PutIdentityPolicyRequest.Builder.() -> Unit): PutIdentityPolicyResponse = putIdentityPolicy(PutIdentityPolicyRequest.Builder().apply(block).build())

/**
 * Reorders the receipt rules within a receipt rule set.
 *
 * All of the rules in the rule set must be represented in this request. That is, it is error if the reorder request doesn't explicitly position all of the rules.
 *
 * For information about managing receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.reorderReceiptRuleSet(crossinline block: ReorderReceiptRuleSetRequest.Builder.() -> Unit): ReorderReceiptRuleSetResponse = reorderReceiptRuleSet(ReorderReceiptRuleSetRequest.Builder().apply(block).build())

/**
 * Generates and sends a bounce message to the sender of an email you received through Amazon SES. You can only use this operation on an email up to 24 hours after you receive it.
 *
 * You cannot use this operation to send generic bounces for mail that was not received by Amazon SES.
 *
 * For information about receiving email through Amazon SES, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.sendBounce(crossinline block: SendBounceRequest.Builder.() -> Unit): SendBounceResponse = sendBounce(SendBounceRequest.Builder().apply(block).build())

/**
 * Composes an email message to multiple destinations. The message body is created using an email template.
 *
 * To send email using this operation, your call must meet the following requirements:
 * + The call must refer to an existing email template. You can create email templates using CreateTemplate.
 * + The message must be sent from a verified email address or domain.
 * + If your account is still in the Amazon SES sandbox, you may send only to verified addresses or domains, or to email addresses associated with the Amazon SES Mailbox Simulator. For more information, see [Verifying Email Addresses and Domains](https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html) in the *Amazon SES Developer Guide.*
 * + The maximum message size is 10 MB.
 * + Each `Destination` parameter must include at least one recipient email address. The recipient address can be a To: address, a CC: address, or a BCC: address. If a recipient email address is invalid (that is, it is not in the format *UserName@&#91;SubDomain.&#93;Domain.TopLevelDomain*), the entire message is rejected, even if the message contains other recipients that are valid.
 * + The message may not include more than 50 recipients, across the To:, CC: and BCC: fields. If you need to send an email message to a larger audience, you can divide your recipient list into groups of 50 or fewer, and then call the `SendBulkTemplatedEmail` operation several times to send the message to each group.
 * + The number of destinations you can contact in a single call can be limited by your account's maximum sending rate.
 */
public suspend inline fun SesClient.sendBulkTemplatedEmail(crossinline block: SendBulkTemplatedEmailRequest.Builder.() -> Unit): SendBulkTemplatedEmailResponse = sendBulkTemplatedEmail(SendBulkTemplatedEmailRequest.Builder().apply(block).build())

/**
 * Adds an email address to the list of identities for your Amazon SES account in the current Amazon Web Services Region and attempts to verify it. As a result of executing this operation, a customized verification email is sent to the specified address.
 *
 * To use this operation, you must first create a custom verification email template. For more information about creating and using custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom) in the *Amazon SES Developer Guide*.
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.sendCustomVerificationEmail(crossinline block: SendCustomVerificationEmailRequest.Builder.() -> Unit): SendCustomVerificationEmailResponse = sendCustomVerificationEmail(SendCustomVerificationEmailRequest.Builder().apply(block).build())

/**
 * Composes an email message and immediately queues it for sending. To send email using this operation, your message must meet the following requirements:
 * + The message must be sent from a verified email address or domain. If you attempt to send email using a non-verified address or domain, the operation results in an "Email address not verified" error.
 * + If your account is still in the Amazon SES sandbox, you may only send to verified addresses or domains, or to email addresses associated with the Amazon SES Mailbox Simulator. For more information, see [Verifying Email Addresses and Domains](https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html) in the *Amazon SES Developer Guide.*
 * + The maximum message size is 10 MB.
 * + The message must include at least one recipient email address. The recipient address can be a To: address, a CC: address, or a BCC: address. If a recipient email address is invalid (that is, it is not in the format *UserName@&#91;SubDomain.&#93;Domain.TopLevelDomain*), the entire message is rejected, even if the message contains other recipients that are valid.
 * + The message may not include more than 50 recipients, across the To:, CC: and BCC: fields. If you need to send an email message to a larger audience, you can divide your recipient list into groups of 50 or fewer, and then call the `SendEmail` operation several times to send the message to each group.
 *
 * For every message that you send, the total number of recipients (including each recipient in the To:, CC: and BCC: fields) is counted against the maximum number of emails you can send in a 24-hour period (your *sending quota*). For more information about sending quotas in Amazon SES, see [Managing Your Amazon SES Sending Limits](https://docs.aws.amazon.com/ses/latest/dg/manage-sending-quotas.html) in the *Amazon SES Developer Guide.*
 */
public suspend inline fun SesClient.sendEmail(crossinline block: SendEmailRequest.Builder.() -> Unit): SendEmailResponse = sendEmail(SendEmailRequest.Builder().apply(block).build())

/**
 * Composes an email message and immediately queues it for sending.
 *
 * This operation is more flexible than the `SendEmail` operation. When you use the `SendRawEmail` operation, you can specify the headers of the message as well as its content. This flexibility is useful, for example, when you need to send a multipart MIME email (such a message that contains both a text and an HTML version). You can also use this operation to send messages that include attachments.
 *
 * The `SendRawEmail` operation has the following requirements:
 * + You can only send email from [verified email addresses or domains](https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html). If you try to send email from an address that isn't verified, the operation results in an "Email address not verified" error.
 * + If your account is still in the [Amazon SES sandbox](https://docs.aws.amazon.com/ses/latest/dg/request-production-access.html), you can only send email to other verified addresses in your account, or to addresses that are associated with the [Amazon SES mailbox simulator](https://docs.aws.amazon.com/ses/latest/dg/send-an-email-from-console.html).
 * + The maximum message size, including attachments, is 10 MB.
 * + Each message has to include at least one recipient address. A recipient address includes any address on the To:, CC:, or BCC: lines.
 * + If you send a single message to more than one recipient address, and one of the recipient addresses isn't in a valid format (that is, it's not in the format *UserName@&#91;SubDomain.&#93;Domain.TopLevelDomain*), Amazon SES rejects the entire message, even if the other addresses are valid.
 * + Each message can include up to 50 recipient addresses across the To:, CC:, or BCC: lines. If you need to send a single message to more than 50 recipients, you have to split the list of recipient addresses into groups of less than 50 recipients, and send separate messages to each group.
 * + Amazon SES allows you to specify 8-bit Content-Transfer-Encoding for MIME message parts. However, if Amazon SES has to modify the contents of your message (for example, if you use open and click tracking), 8-bit content isn't preserved. For this reason, we highly recommend that you encode all content that isn't 7-bit ASCII. For more information, see [MIME Encoding](https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html#send-email-mime-encoding) in the *Amazon SES Developer Guide*.
 *
 * Additionally, keep the following considerations in mind when using the `SendRawEmail` operation:
 * + Although you can customize the message headers when using the `SendRawEmail` operation, Amazon SES automatically applies its own `Message-ID` and `Date` headers; if you passed these headers when creating the message, they are overwritten by the values that Amazon SES provides.
 * + If you are using sending authorization to send on behalf of another user, `SendRawEmail` enables you to specify the cross-account identity for the email's Source, From, and Return-Path parameters in one of two ways: you can pass optional parameters `SourceArn`, `FromArn`, and/or `ReturnPathArn`, or you can include the following X-headers in the header of your raw email:
 *    + `X-SES-SOURCE-ARN`
 *    + `X-SES-FROM-ARN`
 *    + `X-SES-RETURN-PATH-ARN`
 * Don't include these X-headers in the DKIM signature. Amazon SES removes these before it sends the email.If you only specify the `SourceIdentityArn` parameter, Amazon SES sets the From and Return-Path addresses to the same identity that you specified.For more information about sending authorization, see the [Using Sending Authorization with Amazon SES](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html) in the *Amazon SES Developer Guide.*
 * + For every message that you send, the total number of recipients (including each recipient in the To:, CC: and BCC: fields) is counted against the maximum number of emails you can send in a 24-hour period (your *sending quota*). For more information about sending quotas in Amazon SES, see [Managing Your Amazon SES Sending Limits](https://docs.aws.amazon.com/ses/latest/dg/manage-sending-quotas.html) in the *Amazon SES Developer Guide.*
 */
public suspend inline fun SesClient.sendRawEmail(crossinline block: SendRawEmailRequest.Builder.() -> Unit): SendRawEmailResponse = sendRawEmail(SendRawEmailRequest.Builder().apply(block).build())

/**
 * Composes an email message using an email template and immediately queues it for sending.
 *
 * To send email using this operation, your call must meet the following requirements:
 * + The call must refer to an existing email template. You can create email templates using the CreateTemplate operation.
 * + The message must be sent from a verified email address or domain.
 * + If your account is still in the Amazon SES sandbox, you may only send to verified addresses or domains, or to email addresses associated with the Amazon SES Mailbox Simulator. For more information, see [Verifying Email Addresses and Domains](https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html) in the *Amazon SES Developer Guide.*
 * + The maximum message size is 10 MB.
 * + Calls to the `SendTemplatedEmail` operation may only include one `Destination` parameter. A destination is a set of recipients that receives the same version of the email. The `Destination` parameter can include up to 50 recipients, across the To:, CC: and BCC: fields.
 * + The `Destination` parameter must include at least one recipient email address. The recipient address can be a To: address, a CC: address, or a BCC: address. If a recipient email address is invalid (that is, it is not in the format *UserName@&#91;SubDomain.&#93;Domain.TopLevelDomain*), the entire message is rejected, even if the message contains other recipients that are valid.
 *
 * If your call to the `SendTemplatedEmail` operation includes all of the required parameters, Amazon SES accepts it and returns a Message ID. However, if Amazon SES can't render the email because the template contains errors, it doesn't send the email. Additionally, because it already accepted the message, Amazon SES doesn't return a message stating that it was unable to send the email.
 *
 * For these reasons, we highly recommend that you set up Amazon SES to send you notifications when Rendering Failure events occur. For more information, see [Sending Personalized Email Using the Amazon SES API](https://docs.aws.amazon.com/ses/latest/dg/send-personalized-email-api.html) in the *Amazon Simple Email Service Developer Guide*.
 */
public suspend inline fun SesClient.sendTemplatedEmail(crossinline block: SendTemplatedEmailRequest.Builder.() -> Unit): SendTemplatedEmailResponse = sendTemplatedEmail(SendTemplatedEmailRequest.Builder().apply(block).build())

/**
 * Sets the specified receipt rule set as the active receipt rule set.
 *
 * To disable your email-receiving through Amazon SES completely, you can call this operation with `RuleSetName` set to null.
 *
 * For information about managing receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.setActiveReceiptRuleSet(crossinline block: SetActiveReceiptRuleSetRequest.Builder.() -> Unit): SetActiveReceiptRuleSetResponse = setActiveReceiptRuleSet(SetActiveReceiptRuleSetRequest.Builder().apply(block).build())

/**
 * Enables or disables Easy DKIM signing of email sent from an identity. If Easy DKIM signing is enabled for a domain, then Amazon SES uses DKIM to sign all email that it sends from addresses on that domain. If Easy DKIM signing is enabled for an email address, then Amazon SES uses DKIM to sign all email it sends from that address.
 *
 * For email addresses (for example, `user@example.com`), you can only enable DKIM signing if the corresponding domain (in this case, `example.com`) has been set up to use Easy DKIM.
 *
 * You can enable DKIM signing for an identity at any time after you start the verification process for the identity, even if the verification process isn't complete.
 *
 * You can execute this operation no more than once per second.
 *
 * For more information about Easy DKIM signing, go to the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
 */
public suspend inline fun SesClient.setIdentityDkimEnabled(crossinline block: SetIdentityDkimEnabledRequest.Builder.() -> Unit): SetIdentityDkimEnabledResponse = setIdentityDkimEnabled(SetIdentityDkimEnabledRequest.Builder().apply(block).build())

/**
 * Given an identity (an email address or a domain), enables or disables whether Amazon SES forwards bounce and complaint notifications as email. Feedback forwarding can only be disabled when Amazon Simple Notification Service (Amazon SNS) topics are specified for both bounces and complaints.
 *
 * Feedback forwarding does not apply to delivery notifications. Delivery notifications are only available through Amazon SNS.
 *
 * You can execute this operation no more than once per second.
 *
 * For more information about using notifications with Amazon SES, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications.html).
 */
public suspend inline fun SesClient.setIdentityFeedbackForwardingEnabled(crossinline block: SetIdentityFeedbackForwardingEnabledRequest.Builder.() -> Unit): SetIdentityFeedbackForwardingEnabledResponse = setIdentityFeedbackForwardingEnabled(SetIdentityFeedbackForwardingEnabledRequest.Builder().apply(block).build())

/**
 * Given an identity (an email address or a domain), sets whether Amazon SES includes the original email headers in the Amazon Simple Notification Service (Amazon SNS) notifications of a specified type.
 *
 * You can execute this operation no more than once per second.
 *
 * For more information about using notifications with Amazon SES, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications.html).
 */
public suspend inline fun SesClient.setIdentityHeadersInNotificationsEnabled(crossinline block: SetIdentityHeadersInNotificationsEnabledRequest.Builder.() -> Unit): SetIdentityHeadersInNotificationsEnabledResponse = setIdentityHeadersInNotificationsEnabled(SetIdentityHeadersInNotificationsEnabledRequest.Builder().apply(block).build())

/**
 * Enables or disables the custom MAIL FROM domain setup for a verified identity (an email address or a domain).
 *
 * To send emails using the specified MAIL FROM domain, you must add an MX record to your MAIL FROM domain's DNS settings. To ensure that your emails pass Sender Policy Framework (SPF) checks, you must also add or update an SPF record. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/mail-from.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.setIdentityMailFromDomain(crossinline block: SetIdentityMailFromDomainRequest.Builder.() -> Unit): SetIdentityMailFromDomainResponse = setIdentityMailFromDomain(SetIdentityMailFromDomainRequest.Builder().apply(block).build())

/**
 * Sets an Amazon Simple Notification Service (Amazon SNS) topic to use when delivering notifications. When you use this operation, you specify a verified identity, such as an email address or domain. When you send an email that uses the chosen identity in the Source field, Amazon SES sends notifications to the topic you specified. You can send bounce, complaint, or delivery notifications (or any combination of the three) to the Amazon SNS topic that you specify.
 *
 * You can execute this operation no more than once per second.
 *
 * For more information about feedback notification, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications.html).
 */
public suspend inline fun SesClient.setIdentityNotificationTopic(crossinline block: SetIdentityNotificationTopicRequest.Builder.() -> Unit): SetIdentityNotificationTopicResponse = setIdentityNotificationTopic(SetIdentityNotificationTopicRequest.Builder().apply(block).build())

/**
 * Sets the position of the specified receipt rule in the receipt rule set.
 *
 * For information about managing receipt rules, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.setReceiptRulePosition(crossinline block: SetReceiptRulePositionRequest.Builder.() -> Unit): SetReceiptRulePositionResponse = setReceiptRulePosition(SetReceiptRulePositionRequest.Builder().apply(block).build())

/**
 * Creates a preview of the MIME content of an email when provided with a template and a set of replacement data.
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.testRenderTemplate(crossinline block: TestRenderTemplateRequest.Builder.() -> Unit): TestRenderTemplateResponse = testRenderTemplate(TestRenderTemplateRequest.Builder().apply(block).build())

/**
 * Enables or disables email sending across your entire Amazon SES account in the current Amazon Web Services Region. You can use this operation in conjunction with Amazon CloudWatch alarms to temporarily pause email sending across your Amazon SES account in a given Amazon Web Services Region when reputation metrics (such as your bounce or complaint rates) reach certain thresholds.
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.updateAccountSendingEnabled(crossinline block: UpdateAccountSendingEnabledRequest.Builder.() -> Unit): UpdateAccountSendingEnabledResponse = updateAccountSendingEnabled(UpdateAccountSendingEnabledRequest.Builder().apply(block).build())

/**
 * Updates the event destination of a configuration set. Event destinations are associated with configuration sets, which enable you to publish email sending events to Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS). For information about using configuration sets, see [Monitoring Your Amazon SES Sending Activity](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html) in the *Amazon SES Developer Guide.*
 *
 * When you create or update an event destination, you must provide one, and only one, destination. The destination can be Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.updateConfigurationSetEventDestination(crossinline block: UpdateConfigurationSetEventDestinationRequest.Builder.() -> Unit): UpdateConfigurationSetEventDestinationResponse = updateConfigurationSetEventDestination(UpdateConfigurationSetEventDestinationRequest.Builder().apply(block).build())

/**
 * Enables or disables the publishing of reputation metrics for emails sent using a specific configuration set in a given Amazon Web Services Region. Reputation metrics include bounce and complaint rates. These metrics are published to Amazon CloudWatch. By using CloudWatch, you can create alarms when bounce or complaint rates exceed certain thresholds.
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.updateConfigurationSetReputationMetricsEnabled(crossinline block: UpdateConfigurationSetReputationMetricsEnabledRequest.Builder.() -> Unit): UpdateConfigurationSetReputationMetricsEnabledResponse = updateConfigurationSetReputationMetricsEnabled(UpdateConfigurationSetReputationMetricsEnabledRequest.Builder().apply(block).build())

/**
 * Enables or disables email sending for messages sent using a specific configuration set in a given Amazon Web Services Region. You can use this operation in conjunction with Amazon CloudWatch alarms to temporarily pause email sending for a configuration set when the reputation metrics for that configuration set (such as your bounce on complaint rate) exceed certain thresholds.
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.updateConfigurationSetSendingEnabled(crossinline block: UpdateConfigurationSetSendingEnabledRequest.Builder.() -> Unit): UpdateConfigurationSetSendingEnabledResponse = updateConfigurationSetSendingEnabled(UpdateConfigurationSetSendingEnabledRequest.Builder().apply(block).build())

/**
 * Modifies an association between a configuration set and a custom domain for open and click event tracking.
 *
 * By default, images and links used for tracking open and click events are hosted on domains operated by Amazon SES. You can configure a subdomain of your own to handle these events. For information about using custom domains, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/configure-custom-open-click-domains.html).
 */
public suspend inline fun SesClient.updateConfigurationSetTrackingOptions(crossinline block: UpdateConfigurationSetTrackingOptionsRequest.Builder.() -> Unit): UpdateConfigurationSetTrackingOptionsResponse = updateConfigurationSetTrackingOptions(UpdateConfigurationSetTrackingOptionsRequest.Builder().apply(block).build())

/**
 * Updates an existing custom verification email template.
 *
 * For more information about custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom) in the *Amazon SES Developer Guide*.
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.updateCustomVerificationEmailTemplate(crossinline block: UpdateCustomVerificationEmailTemplateRequest.Builder.() -> Unit): UpdateCustomVerificationEmailTemplateResponse = updateCustomVerificationEmailTemplate(UpdateCustomVerificationEmailTemplateRequest.Builder().apply(block).build())

/**
 * Updates a receipt rule.
 *
 * For information about managing receipt rules, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.updateReceiptRule(crossinline block: UpdateReceiptRuleRequest.Builder.() -> Unit): UpdateReceiptRuleResponse = updateReceiptRule(UpdateReceiptRuleRequest.Builder().apply(block).build())

/**
 * Updates an email template. Email templates enable you to send personalized email to one or more destinations in a single operation. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-personalized-email-api.html).
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.updateTemplate(crossinline block: UpdateTemplateRequest.Builder.() -> Unit): UpdateTemplateResponse = updateTemplate(UpdateTemplateRequest.Builder().apply(block).build())

/**
 * Returns a set of DKIM tokens for a domain identity.
 *
 * When you execute the `VerifyDomainDkim` operation, the domain that you specify is added to the list of identities that are associated with your account. This is true even if you haven't already associated the domain with your account by using the `VerifyDomainIdentity` operation. However, you can't send email from the domain until you either successfully [verify it](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#verify-domain-procedure) or you successfully [set up DKIM for it](https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
 *
 * You use the tokens that are generated by this operation to create CNAME records. When Amazon SES detects that you've added these records to the DNS configuration for a domain, you can start sending email from that domain. You can start sending email even if you haven't added the TXT record provided by the VerifyDomainIdentity operation to the DNS configuration for your domain. All email that you send from the domain is authenticated using DKIM.
 *
 * To create the CNAME records for DKIM authentication, use the following values:
 * + **Name**: *token*._domainkey.*example.com*
 * + **Type**: CNAME
 * + **Value**: *token*.dkim.amazonses.com
 *
 * In the preceding example, replace *token* with one of the tokens that are generated when you execute this operation. Replace *example.com* with your domain. Repeat this process for each token that's generated by this operation.
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.verifyDomainDkim(crossinline block: VerifyDomainDkimRequest.Builder.() -> Unit): VerifyDomainDkimResponse = verifyDomainDkim(VerifyDomainDkimRequest.Builder().apply(block).build())

/**
 * Adds a domain to the list of identities for your Amazon SES account in the current Amazon Web Services Region and attempts to verify it. For more information about verifying domains, see [Verifying Email Addresses and Domains](https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html) in the *Amazon SES Developer Guide.*
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.verifyDomainIdentity(crossinline block: VerifyDomainIdentityRequest.Builder.() -> Unit): VerifyDomainIdentityResponse = verifyDomainIdentity(VerifyDomainIdentityRequest.Builder().apply(block).build())

/**
 * Deprecated. Use the `VerifyEmailIdentity` operation to verify a new email address.
 */
public suspend inline fun SesClient.verifyEmailAddress(crossinline block: VerifyEmailAddressRequest.Builder.() -> Unit): VerifyEmailAddressResponse = verifyEmailAddress(VerifyEmailAddressRequest.Builder().apply(block).build())

/**
 * Adds an email address to the list of identities for your Amazon SES account in the current Amazon Web Services Region and attempts to verify it. As a result of executing this operation, a verification email is sent to the specified address.
 *
 * You can execute this operation no more than once per second.
 */
public suspend inline fun SesClient.verifyEmailIdentity(crossinline block: VerifyEmailIdentityRequest.Builder.() -> Unit): VerifyEmailIdentityResponse = verifyEmailIdentity(VerifyEmailIdentityRequest.Builder().apply(block).build())
