// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicequotas.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.servicequotas.model.RequestServiceQuotaIncreaseResponse
import aws.sdk.kotlin.services.servicequotas.model.RequestedServiceQuotaChange
import aws.sdk.kotlin.services.servicequotas.model.ServiceQuotasException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RequestServiceQuotaIncreaseOperationDeserializer: HttpDeserialize<RequestServiceQuotaIncreaseResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RequestServiceQuotaIncreaseResponse {
        if (!response.status.isSuccess()) {
            throwRequestServiceQuotaIncreaseError(context, response)
        }
        val builder = RequestServiceQuotaIncreaseResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRequestServiceQuotaIncreaseOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwRequestServiceQuotaIncreaseError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceQuotasException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "DependencyAccessDeniedException" -> DependencyAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "IllegalArgumentException" -> IllegalArgumentExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidResourceStateException" -> InvalidResourceStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "NoSuchResourceException" -> NoSuchResourceExceptionDeserializer().deserialize(context, wrappedResponse)
        "QuotaExceededException" -> QuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServiceQuotasException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRequestServiceQuotaIncreaseOperationBody(builder: RequestServiceQuotaIncreaseResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val REQUESTEDQUOTA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RequestedQuota"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(REQUESTEDQUOTA_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                REQUESTEDQUOTA_DESCRIPTOR.index -> builder.requestedQuota = deserializeRequestedServiceQuotaChangeDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
