// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicequotas.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse
import aws.sdk.kotlin.services.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate
import aws.sdk.kotlin.services.servicequotas.model.ServiceQuotasException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutServiceQuotaIncreaseRequestIntoTemplateOperationDeserializer: HttpDeserialize<PutServiceQuotaIncreaseRequestIntoTemplateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutServiceQuotaIncreaseRequestIntoTemplateResponse {
        if (!response.status.isSuccess()) {
            throwPutServiceQuotaIncreaseRequestIntoTemplateError(context, response)
        }
        val builder = PutServiceQuotaIncreaseRequestIntoTemplateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutServiceQuotaIncreaseRequestIntoTemplateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPutServiceQuotaIncreaseRequestIntoTemplateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceQuotasException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AWSServiceAccessNotEnabledException" -> AwsServiceAccessNotEnabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "DependencyAccessDeniedException" -> DependencyAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "IllegalArgumentException" -> IllegalArgumentExceptionDeserializer().deserialize(context, wrappedResponse)
        "NoAvailableOrganizationException" -> NoAvailableOrganizationExceptionDeserializer().deserialize(context, wrappedResponse)
        "NoSuchResourceException" -> NoSuchResourceExceptionDeserializer().deserialize(context, wrappedResponse)
        "QuotaExceededException" -> QuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "TemplatesNotAvailableInRegionException" -> TemplatesNotAvailableInRegionExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServiceQuotasException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutServiceQuotaIncreaseRequestIntoTemplateOperationBody(builder: PutServiceQuotaIncreaseRequestIntoTemplateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SERVICEQUOTAINCREASEREQUESTINTEMPLATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ServiceQuotaIncreaseRequestInTemplate"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SERVICEQUOTAINCREASEREQUESTINTEMPLATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SERVICEQUOTAINCREASEREQUESTINTEMPLATE_DESCRIPTOR.index -> builder.serviceQuotaIncreaseRequestInTemplate = deserializeServiceQuotaIncreaseRequestInTemplateDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
