// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicequotas.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse
import aws.sdk.kotlin.services.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate
import aws.sdk.kotlin.services.servicequotas.model.ServiceQuotasException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListServiceQuotaIncreaseRequestsInTemplateOperationDeserializer: HttpDeserialize<ListServiceQuotaIncreaseRequestsInTemplateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListServiceQuotaIncreaseRequestsInTemplateResponse {
        if (!response.status.isSuccess()) {
            throwListServiceQuotaIncreaseRequestsInTemplateError(context, response)
        }
        val builder = ListServiceQuotaIncreaseRequestsInTemplateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListServiceQuotaIncreaseRequestsInTemplateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListServiceQuotaIncreaseRequestsInTemplateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceQuotasException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AWSServiceAccessNotEnabledException" -> AwsServiceAccessNotEnabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "DependencyAccessDeniedException" -> DependencyAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "IllegalArgumentException" -> IllegalArgumentExceptionDeserializer().deserialize(context, wrappedResponse)
        "NoAvailableOrganizationException" -> NoAvailableOrganizationExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "TemplatesNotAvailableInRegionException" -> TemplatesNotAvailableInRegionExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServiceQuotasException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListServiceQuotaIncreaseRequestsInTemplateOperationBody(builder: ListServiceQuotaIncreaseRequestsInTemplateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val SERVICEQUOTAINCREASEREQUESTINTEMPLATELIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ServiceQuotaIncreaseRequestInTemplateList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(SERVICEQUOTAINCREASEREQUESTINTEMPLATELIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SERVICEQUOTAINCREASEREQUESTINTEMPLATELIST_DESCRIPTOR.index -> builder.serviceQuotaIncreaseRequestInTemplateList =
                    deserializer.deserializeList(SERVICEQUOTAINCREASEREQUESTINTEMPLATELIST_DESCRIPTOR) {
                        val col0 = mutableListOf<ServiceQuotaIncreaseRequestInTemplate>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeServiceQuotaIncreaseRequestInTemplateDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
