// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicequotas.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse
import aws.sdk.kotlin.services.servicequotas.model.RequestedServiceQuotaChange
import aws.sdk.kotlin.services.servicequotas.model.ServiceQuotasException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListRequestedServiceQuotaChangeHistoryByQuotaOperationDeserializer: HttpDeserialize<ListRequestedServiceQuotaChangeHistoryByQuotaResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListRequestedServiceQuotaChangeHistoryByQuotaResponse {
        if (!response.status.isSuccess()) {
            throwListRequestedServiceQuotaChangeHistoryByQuotaError(context, response)
        }
        val builder = ListRequestedServiceQuotaChangeHistoryByQuotaResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListRequestedServiceQuotaChangeHistoryByQuotaOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListRequestedServiceQuotaChangeHistoryByQuotaError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceQuotasException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "IllegalArgumentException" -> IllegalArgumentExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidPaginationTokenException" -> InvalidPaginationTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "NoSuchResourceException" -> NoSuchResourceExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServiceQuotasException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListRequestedServiceQuotaChangeHistoryByQuotaOperationBody(builder: ListRequestedServiceQuotaChangeHistoryByQuotaResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val REQUESTEDQUOTAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RequestedQuotas"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(REQUESTEDQUOTAS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                REQUESTEDQUOTAS_DESCRIPTOR.index -> builder.requestedQuotas =
                    deserializer.deserializeList(REQUESTEDQUOTAS_DESCRIPTOR) {
                        val col0 = mutableListOf<RequestedServiceQuotaChange>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRequestedServiceQuotaChangeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
