// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicequotas.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.servicequotas.model.GetAssociationForServiceQuotaTemplateResponse
import aws.sdk.kotlin.services.servicequotas.model.ServiceQuotaTemplateAssociationStatus
import aws.sdk.kotlin.services.servicequotas.model.ServiceQuotasException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetAssociationForServiceQuotaTemplateOperationDeserializer: HttpDeserialize<GetAssociationForServiceQuotaTemplateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetAssociationForServiceQuotaTemplateResponse {
        if (!response.status.isSuccess()) {
            throwGetAssociationForServiceQuotaTemplateError(context, response)
        }
        val builder = GetAssociationForServiceQuotaTemplateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetAssociationForServiceQuotaTemplateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetAssociationForServiceQuotaTemplateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceQuotasException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AWSServiceAccessNotEnabledException" -> AwsServiceAccessNotEnabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "DependencyAccessDeniedException" -> DependencyAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "NoAvailableOrganizationException" -> NoAvailableOrganizationExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaTemplateNotInUseException" -> ServiceQuotaTemplateNotInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "TemplatesNotAvailableInRegionException" -> TemplatesNotAvailableInRegionExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServiceQuotasException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAssociationForServiceQuotaTemplateOperationBody(builder: GetAssociationForServiceQuotaTemplateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SERVICEQUOTATEMPLATEASSOCIATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ServiceQuotaTemplateAssociationStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SERVICEQUOTATEMPLATEASSOCIATIONSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SERVICEQUOTATEMPLATEASSOCIATIONSTATUS_DESCRIPTOR.index -> builder.serviceQuotaTemplateAssociationStatus = deserializeString().let { ServiceQuotaTemplateAssociationStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
