// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicequotas.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.servicequotas.model.DisassociateServiceQuotaTemplateResponse
import aws.sdk.kotlin.services.servicequotas.model.ServiceQuotasException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class DisassociateServiceQuotaTemplateOperationDeserializer: HttpDeserialize<DisassociateServiceQuotaTemplateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DisassociateServiceQuotaTemplateResponse {
        if (!response.status.isSuccess()) {
            throwDisassociateServiceQuotaTemplateError(context, response)
        }
        val builder = DisassociateServiceQuotaTemplateResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDisassociateServiceQuotaTemplateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceQuotasException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AWSServiceAccessNotEnabledException" -> AwsServiceAccessNotEnabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "DependencyAccessDeniedException" -> DependencyAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "NoAvailableOrganizationException" -> NoAvailableOrganizationExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaTemplateNotInUseException" -> ServiceQuotaTemplateNotInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "TemplatesNotAvailableInRegionException" -> TemplatesNotAvailableInRegionExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServiceQuotasException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
