// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicequotas.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.servicequotas.model.AssociateServiceQuotaTemplateResponse
import aws.sdk.kotlin.services.servicequotas.model.ServiceQuotasException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class AssociateServiceQuotaTemplateOperationDeserializer: HttpDeserialize<AssociateServiceQuotaTemplateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AssociateServiceQuotaTemplateResponse {
        if (!response.status.isSuccess()) {
            throwAssociateServiceQuotaTemplateError(context, response)
        }
        val builder = AssociateServiceQuotaTemplateResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwAssociateServiceQuotaTemplateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceQuotasException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AWSServiceAccessNotEnabledException" -> AwsServiceAccessNotEnabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "DependencyAccessDeniedException" -> DependencyAccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "NoAvailableOrganizationException" -> NoAvailableOrganizationExceptionDeserializer().deserialize(context, wrappedResponse)
        "OrganizationNotInAllFeaturesModeException" -> OrganizationNotInAllFeaturesModeExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "TemplatesNotAvailableInRegionException" -> TemplatesNotAvailableInRegionExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServiceQuotasException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
