// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicequotas.paginators

import aws.sdk.kotlin.services.servicequotas.ServiceQuotasClient
import aws.sdk.kotlin.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest
import aws.sdk.kotlin.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse
import aws.sdk.kotlin.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest
import aws.sdk.kotlin.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse
import aws.sdk.kotlin.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest
import aws.sdk.kotlin.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse
import aws.sdk.kotlin.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest
import aws.sdk.kotlin.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse
import aws.sdk.kotlin.services.servicequotas.model.ListServiceQuotasRequest
import aws.sdk.kotlin.services.servicequotas.model.ListServiceQuotasResponse
import aws.sdk.kotlin.services.servicequotas.model.ListServicesRequest
import aws.sdk.kotlin.services.servicequotas.model.ListServicesResponse
import aws.sdk.kotlin.services.servicequotas.model.RequestedServiceQuotaChange
import aws.sdk.kotlin.services.servicequotas.model.ServiceInfo
import aws.sdk.kotlin.services.servicequotas.model.ServiceQuota
import aws.sdk.kotlin.services.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAwsDefaultServiceQuotasResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAwsDefaultServiceQuotasRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAwsDefaultServiceQuotasResponse]
 */
public fun ServiceQuotasClient.listAwsDefaultServiceQuotasPaginated(initialRequest: ListAwsDefaultServiceQuotasRequest): Flow<ListAwsDefaultServiceQuotasResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAwsDefaultServiceQuotasPaginated.listAwsDefaultServiceQuotas(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAwsDefaultServiceQuotasResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAwsDefaultServiceQuotasResponse]
 */
public fun ServiceQuotasClient.listAwsDefaultServiceQuotasPaginated(block: ListAwsDefaultServiceQuotasRequest.Builder.() -> Unit): Flow<ListAwsDefaultServiceQuotasResponse> =
    listAwsDefaultServiceQuotasPaginated(ListAwsDefaultServiceQuotasRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAwsDefaultServiceQuotasPaginated]
 * to access the nested member [ServiceQuota]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ServiceQuota]
 */
@JvmName("listAwsDefaultServiceQuotasResponseServiceQuota")
public fun Flow<ListAwsDefaultServiceQuotasResponse>.quotas(): Flow<ServiceQuota> =
    transform() { response ->
        response.quotas?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRequestedServiceQuotaChangeHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRequestedServiceQuotaChangeHistoryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRequestedServiceQuotaChangeHistoryResponse]
 */
public fun ServiceQuotasClient.listRequestedServiceQuotaChangeHistoryPaginated(initialRequest: ListRequestedServiceQuotaChangeHistoryRequest): Flow<ListRequestedServiceQuotaChangeHistoryResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRequestedServiceQuotaChangeHistoryPaginated.listRequestedServiceQuotaChangeHistory(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRequestedServiceQuotaChangeHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRequestedServiceQuotaChangeHistoryResponse]
 */
public fun ServiceQuotasClient.listRequestedServiceQuotaChangeHistoryPaginated(block: ListRequestedServiceQuotaChangeHistoryRequest.Builder.() -> Unit): Flow<ListRequestedServiceQuotaChangeHistoryResponse> =
    listRequestedServiceQuotaChangeHistoryPaginated(ListRequestedServiceQuotaChangeHistoryRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRequestedServiceQuotaChangeHistoryPaginated]
 * to access the nested member [RequestedServiceQuotaChange]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RequestedServiceQuotaChange]
 */
@JvmName("listRequestedServiceQuotaChangeHistoryResponseRequestedServiceQuotaChange")
public fun Flow<ListRequestedServiceQuotaChangeHistoryResponse>.requestedQuotas(): Flow<RequestedServiceQuotaChange> =
    transform() { response ->
        response.requestedQuotas?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRequestedServiceQuotaChangeHistoryByQuotaResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRequestedServiceQuotaChangeHistoryByQuotaRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRequestedServiceQuotaChangeHistoryByQuotaResponse]
 */
public fun ServiceQuotasClient.listRequestedServiceQuotaChangeHistoryByQuotaPaginated(initialRequest: ListRequestedServiceQuotaChangeHistoryByQuotaRequest): Flow<ListRequestedServiceQuotaChangeHistoryByQuotaResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRequestedServiceQuotaChangeHistoryByQuotaPaginated.listRequestedServiceQuotaChangeHistoryByQuota(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRequestedServiceQuotaChangeHistoryByQuotaResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRequestedServiceQuotaChangeHistoryByQuotaResponse]
 */
public fun ServiceQuotasClient.listRequestedServiceQuotaChangeHistoryByQuotaPaginated(block: ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder.() -> Unit): Flow<ListRequestedServiceQuotaChangeHistoryByQuotaResponse> =
    listRequestedServiceQuotaChangeHistoryByQuotaPaginated(ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRequestedServiceQuotaChangeHistoryByQuotaPaginated]
 * to access the nested member [RequestedServiceQuotaChange]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RequestedServiceQuotaChange]
 */
@JvmName("listRequestedServiceQuotaChangeHistoryByQuotaResponseRequestedServiceQuotaChange")
public fun Flow<ListRequestedServiceQuotaChangeHistoryByQuotaResponse>.requestedQuotas(): Flow<RequestedServiceQuotaChange> =
    transform() { response ->
        response.requestedQuotas?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListServiceQuotaIncreaseRequestsInTemplateResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListServiceQuotaIncreaseRequestsInTemplateRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServiceQuotaIncreaseRequestsInTemplateResponse]
 */
public fun ServiceQuotasClient.listServiceQuotaIncreaseRequestsInTemplatePaginated(initialRequest: ListServiceQuotaIncreaseRequestsInTemplateRequest): Flow<ListServiceQuotaIncreaseRequestsInTemplateResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listServiceQuotaIncreaseRequestsInTemplatePaginated.listServiceQuotaIncreaseRequestsInTemplate(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListServiceQuotaIncreaseRequestsInTemplateResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServiceQuotaIncreaseRequestsInTemplateResponse]
 */
public fun ServiceQuotasClient.listServiceQuotaIncreaseRequestsInTemplatePaginated(block: ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder.() -> Unit): Flow<ListServiceQuotaIncreaseRequestsInTemplateResponse> =
    listServiceQuotaIncreaseRequestsInTemplatePaginated(ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listServiceQuotaIncreaseRequestsInTemplatePaginated]
 * to access the nested member [ServiceQuotaIncreaseRequestInTemplate]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ServiceQuotaIncreaseRequestInTemplate]
 */
@JvmName("listServiceQuotaIncreaseRequestsInTemplateResponseServiceQuotaIncreaseRequestInTemplate")
public fun Flow<ListServiceQuotaIncreaseRequestsInTemplateResponse>.serviceQuotaIncreaseRequestInTemplateList(): Flow<ServiceQuotaIncreaseRequestInTemplate> =
    transform() { response ->
        response.serviceQuotaIncreaseRequestInTemplateList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListServiceQuotasResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListServiceQuotasRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServiceQuotasResponse]
 */
public fun ServiceQuotasClient.listServiceQuotasPaginated(initialRequest: ListServiceQuotasRequest): Flow<ListServiceQuotasResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listServiceQuotasPaginated.listServiceQuotas(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListServiceQuotasResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServiceQuotasResponse]
 */
public fun ServiceQuotasClient.listServiceQuotasPaginated(block: ListServiceQuotasRequest.Builder.() -> Unit): Flow<ListServiceQuotasResponse> =
    listServiceQuotasPaginated(ListServiceQuotasRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listServiceQuotasPaginated]
 * to access the nested member [ServiceQuota]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ServiceQuota]
 */
@JvmName("listServiceQuotasResponseServiceQuota")
public fun Flow<ListServiceQuotasResponse>.quotas(): Flow<ServiceQuota> =
    transform() { response ->
        response.quotas?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListServicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListServicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServicesResponse]
 */
public fun ServiceQuotasClient.listServicesPaginated(initialRequest: ListServicesRequest): Flow<ListServicesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listServicesPaginated.listServices(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListServicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServicesResponse]
 */
public fun ServiceQuotasClient.listServicesPaginated(block: ListServicesRequest.Builder.() -> Unit): Flow<ListServicesResponse> =
    listServicesPaginated(ListServicesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listServicesPaginated]
 * to access the nested member [ServiceInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ServiceInfo]
 */
@JvmName("listServicesResponseServiceInfo")
public fun Flow<ListServicesResponse>.services(): Flow<ServiceInfo> =
    transform() { response ->
        response.services?.forEach {
            emit(it)
        }
    }
