// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicequotas

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.servicequotas.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.servicequotas.model.*
import aws.sdk.kotlin.services.servicequotas.model.AssociateServiceQuotaTemplateRequest
import aws.sdk.kotlin.services.servicequotas.model.AssociateServiceQuotaTemplateResponse
import aws.sdk.kotlin.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateRequest
import aws.sdk.kotlin.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateResponse
import aws.sdk.kotlin.services.servicequotas.model.DisassociateServiceQuotaTemplateRequest
import aws.sdk.kotlin.services.servicequotas.model.DisassociateServiceQuotaTemplateResponse
import aws.sdk.kotlin.services.servicequotas.model.GetAssociationForServiceQuotaTemplateRequest
import aws.sdk.kotlin.services.servicequotas.model.GetAssociationForServiceQuotaTemplateResponse
import aws.sdk.kotlin.services.servicequotas.model.GetAwsDefaultServiceQuotaRequest
import aws.sdk.kotlin.services.servicequotas.model.GetAwsDefaultServiceQuotaResponse
import aws.sdk.kotlin.services.servicequotas.model.GetRequestedServiceQuotaChangeRequest
import aws.sdk.kotlin.services.servicequotas.model.GetRequestedServiceQuotaChangeResponse
import aws.sdk.kotlin.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateRequest
import aws.sdk.kotlin.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateResponse
import aws.sdk.kotlin.services.servicequotas.model.GetServiceQuotaRequest
import aws.sdk.kotlin.services.servicequotas.model.GetServiceQuotaResponse
import aws.sdk.kotlin.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest
import aws.sdk.kotlin.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse
import aws.sdk.kotlin.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest
import aws.sdk.kotlin.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse
import aws.sdk.kotlin.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest
import aws.sdk.kotlin.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse
import aws.sdk.kotlin.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest
import aws.sdk.kotlin.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse
import aws.sdk.kotlin.services.servicequotas.model.ListServiceQuotasRequest
import aws.sdk.kotlin.services.servicequotas.model.ListServiceQuotasResponse
import aws.sdk.kotlin.services.servicequotas.model.ListServicesRequest
import aws.sdk.kotlin.services.servicequotas.model.ListServicesResponse
import aws.sdk.kotlin.services.servicequotas.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.servicequotas.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateRequest
import aws.sdk.kotlin.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse
import aws.sdk.kotlin.services.servicequotas.model.RequestServiceQuotaIncreaseRequest
import aws.sdk.kotlin.services.servicequotas.model.RequestServiceQuotaIncreaseResponse
import aws.sdk.kotlin.services.servicequotas.model.TagResourceRequest
import aws.sdk.kotlin.services.servicequotas.model.TagResourceResponse
import aws.sdk.kotlin.services.servicequotas.model.UntagResourceRequest
import aws.sdk.kotlin.services.servicequotas.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * With Service Quotas, you can view and manage your quotas easily as your AWS workloads grow. Quotas, also referred to as limits, are the maximum number of resources that you can create in your AWS account. For more information, see the [Service Quotas User Guide](https://docs.aws.amazon.com/servicequotas/latest/userguide/).
 */
public interface ServiceQuotasClient : SdkClient {

    override val serviceName: String
        get() = "Service Quotas"
    /**
     * ServiceQuotasClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): ServiceQuotasClient {
            val config = Config.Builder().apply(block).build()
            return DefaultServiceQuotasClient(config)
        }

        public operator fun invoke(config: Config): ServiceQuotasClient = DefaultServiceQuotasClient(config)

        /**
         * Construct a [ServiceQuotasClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ServiceQuotasClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultServiceQuotasClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates your quota request template with your organization. When a new account is created in your organization, the quota increase requests in the template are automatically applied to the account. You can add a quota increase request for any adjustable quota to your template.
     */
    public suspend fun associateServiceQuotaTemplate(input: AssociateServiceQuotaTemplateRequest = AssociateServiceQuotaTemplateRequest {}): AssociateServiceQuotaTemplateResponse

    /**
     * Deletes the quota increase request for the specified quota from your quota request template.
     */
    public suspend fun deleteServiceQuotaIncreaseRequestFromTemplate(input: DeleteServiceQuotaIncreaseRequestFromTemplateRequest): DeleteServiceQuotaIncreaseRequestFromTemplateResponse

    /**
     * Disables your quota request template. After a template is disabled, the quota increase requests in the template are not applied to new accounts in your organization. Disabling a quota request template does not apply its quota increase requests.
     */
    public suspend fun disassociateServiceQuotaTemplate(input: DisassociateServiceQuotaTemplateRequest = DisassociateServiceQuotaTemplateRequest {}): DisassociateServiceQuotaTemplateResponse

    /**
     * Retrieves the status of the association for the quota request template.
     */
    public suspend fun getAssociationForServiceQuotaTemplate(input: GetAssociationForServiceQuotaTemplateRequest = GetAssociationForServiceQuotaTemplateRequest {}): GetAssociationForServiceQuotaTemplateResponse

    /**
     * Retrieves the default value for the specified quota. The default value does not reflect any quota increases.
     */
    public suspend fun getAwsDefaultServiceQuota(input: GetAwsDefaultServiceQuotaRequest): GetAwsDefaultServiceQuotaResponse

    /**
     * Retrieves information about the specified quota increase request.
     */
    public suspend fun getRequestedServiceQuotaChange(input: GetRequestedServiceQuotaChangeRequest): GetRequestedServiceQuotaChangeResponse

    /**
     * Retrieves the applied quota value for the specified quota. For some quotas, only the default values are available. If the applied quota value is not available for a quota, the quota is not retrieved.
     */
    public suspend fun getServiceQuota(input: GetServiceQuotaRequest): GetServiceQuotaResponse

    /**
     * Retrieves information about the specified quota increase request in your quota request template.
     */
    public suspend fun getServiceQuotaIncreaseRequestFromTemplate(input: GetServiceQuotaIncreaseRequestFromTemplateRequest): GetServiceQuotaIncreaseRequestFromTemplateResponse

    /**
     * Lists the default values for the quotas for the specified AWS service. A default value does not reflect any quota increases.
     */
    public suspend fun listAwsDefaultServiceQuotas(input: ListAwsDefaultServiceQuotasRequest): ListAwsDefaultServiceQuotasResponse

    /**
     * Retrieves the quota increase requests for the specified service.
     */
    public suspend fun listRequestedServiceQuotaChangeHistory(input: ListRequestedServiceQuotaChangeHistoryRequest = ListRequestedServiceQuotaChangeHistoryRequest {}): ListRequestedServiceQuotaChangeHistoryResponse

    /**
     * Retrieves the quota increase requests for the specified quota.
     */
    public suspend fun listRequestedServiceQuotaChangeHistoryByQuota(input: ListRequestedServiceQuotaChangeHistoryByQuotaRequest): ListRequestedServiceQuotaChangeHistoryByQuotaResponse

    /**
     * Lists the quota increase requests in the specified quota request template.
     */
    public suspend fun listServiceQuotaIncreaseRequestsInTemplate(input: ListServiceQuotaIncreaseRequestsInTemplateRequest = ListServiceQuotaIncreaseRequestsInTemplateRequest {}): ListServiceQuotaIncreaseRequestsInTemplateResponse

    /**
     * Lists the applied quota values for the specified AWS service. For some quotas, only the default values are available. If the applied quota value is not available for a quota, the quota is not retrieved.
     */
    public suspend fun listServiceQuotas(input: ListServiceQuotasRequest): ListServiceQuotasResponse

    /**
     * Lists the names and codes for the services integrated with Service Quotas.
     */
    public suspend fun listServices(input: ListServicesRequest = ListServicesRequest {}): ListServicesResponse

    /**
     * Returns a list of the tags assigned to the specified applied quota.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds a quota increase request to your quota request template.
     */
    public suspend fun putServiceQuotaIncreaseRequestIntoTemplate(input: PutServiceQuotaIncreaseRequestIntoTemplateRequest): PutServiceQuotaIncreaseRequestIntoTemplateResponse

    /**
     * Submits a quota increase request for the specified quota.
     */
    public suspend fun requestServiceQuotaIncrease(input: RequestServiceQuotaIncreaseRequest): RequestServiceQuotaIncreaseResponse

    /**
     * Adds tags to the specified applied quota. You can include one or more tags to add to the quota.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from the specified applied quota. You can specify one or more tags to remove.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Associates your quota request template with your organization. When a new account is created in your organization, the quota increase requests in the template are automatically applied to the account. You can add a quota increase request for any adjustable quota to your template.
 */
public suspend inline fun ServiceQuotasClient.associateServiceQuotaTemplate(crossinline block: AssociateServiceQuotaTemplateRequest.Builder.() -> Unit): AssociateServiceQuotaTemplateResponse = associateServiceQuotaTemplate(AssociateServiceQuotaTemplateRequest.Builder().apply(block).build())

/**
 * Deletes the quota increase request for the specified quota from your quota request template.
 */
public suspend inline fun ServiceQuotasClient.deleteServiceQuotaIncreaseRequestFromTemplate(crossinline block: DeleteServiceQuotaIncreaseRequestFromTemplateRequest.Builder.() -> Unit): DeleteServiceQuotaIncreaseRequestFromTemplateResponse = deleteServiceQuotaIncreaseRequestFromTemplate(DeleteServiceQuotaIncreaseRequestFromTemplateRequest.Builder().apply(block).build())

/**
 * Disables your quota request template. After a template is disabled, the quota increase requests in the template are not applied to new accounts in your organization. Disabling a quota request template does not apply its quota increase requests.
 */
public suspend inline fun ServiceQuotasClient.disassociateServiceQuotaTemplate(crossinline block: DisassociateServiceQuotaTemplateRequest.Builder.() -> Unit): DisassociateServiceQuotaTemplateResponse = disassociateServiceQuotaTemplate(DisassociateServiceQuotaTemplateRequest.Builder().apply(block).build())

/**
 * Retrieves the status of the association for the quota request template.
 */
public suspend inline fun ServiceQuotasClient.getAssociationForServiceQuotaTemplate(crossinline block: GetAssociationForServiceQuotaTemplateRequest.Builder.() -> Unit): GetAssociationForServiceQuotaTemplateResponse = getAssociationForServiceQuotaTemplate(GetAssociationForServiceQuotaTemplateRequest.Builder().apply(block).build())

/**
 * Retrieves the default value for the specified quota. The default value does not reflect any quota increases.
 */
public suspend inline fun ServiceQuotasClient.getAwsDefaultServiceQuota(crossinline block: GetAwsDefaultServiceQuotaRequest.Builder.() -> Unit): GetAwsDefaultServiceQuotaResponse = getAwsDefaultServiceQuota(GetAwsDefaultServiceQuotaRequest.Builder().apply(block).build())

/**
 * Retrieves information about the specified quota increase request.
 */
public suspend inline fun ServiceQuotasClient.getRequestedServiceQuotaChange(crossinline block: GetRequestedServiceQuotaChangeRequest.Builder.() -> Unit): GetRequestedServiceQuotaChangeResponse = getRequestedServiceQuotaChange(GetRequestedServiceQuotaChangeRequest.Builder().apply(block).build())

/**
 * Retrieves the applied quota value for the specified quota. For some quotas, only the default values are available. If the applied quota value is not available for a quota, the quota is not retrieved.
 */
public suspend inline fun ServiceQuotasClient.getServiceQuota(crossinline block: GetServiceQuotaRequest.Builder.() -> Unit): GetServiceQuotaResponse = getServiceQuota(GetServiceQuotaRequest.Builder().apply(block).build())

/**
 * Retrieves information about the specified quota increase request in your quota request template.
 */
public suspend inline fun ServiceQuotasClient.getServiceQuotaIncreaseRequestFromTemplate(crossinline block: GetServiceQuotaIncreaseRequestFromTemplateRequest.Builder.() -> Unit): GetServiceQuotaIncreaseRequestFromTemplateResponse = getServiceQuotaIncreaseRequestFromTemplate(GetServiceQuotaIncreaseRequestFromTemplateRequest.Builder().apply(block).build())

/**
 * Lists the default values for the quotas for the specified AWS service. A default value does not reflect any quota increases.
 */
public suspend inline fun ServiceQuotasClient.listAwsDefaultServiceQuotas(crossinline block: ListAwsDefaultServiceQuotasRequest.Builder.() -> Unit): ListAwsDefaultServiceQuotasResponse = listAwsDefaultServiceQuotas(ListAwsDefaultServiceQuotasRequest.Builder().apply(block).build())

/**
 * Retrieves the quota increase requests for the specified service.
 */
public suspend inline fun ServiceQuotasClient.listRequestedServiceQuotaChangeHistory(crossinline block: ListRequestedServiceQuotaChangeHistoryRequest.Builder.() -> Unit): ListRequestedServiceQuotaChangeHistoryResponse = listRequestedServiceQuotaChangeHistory(ListRequestedServiceQuotaChangeHistoryRequest.Builder().apply(block).build())

/**
 * Retrieves the quota increase requests for the specified quota.
 */
public suspend inline fun ServiceQuotasClient.listRequestedServiceQuotaChangeHistoryByQuota(crossinline block: ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder.() -> Unit): ListRequestedServiceQuotaChangeHistoryByQuotaResponse = listRequestedServiceQuotaChangeHistoryByQuota(ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder().apply(block).build())

/**
 * Lists the quota increase requests in the specified quota request template.
 */
public suspend inline fun ServiceQuotasClient.listServiceQuotaIncreaseRequestsInTemplate(crossinline block: ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder.() -> Unit): ListServiceQuotaIncreaseRequestsInTemplateResponse = listServiceQuotaIncreaseRequestsInTemplate(ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder().apply(block).build())

/**
 * Lists the applied quota values for the specified AWS service. For some quotas, only the default values are available. If the applied quota value is not available for a quota, the quota is not retrieved.
 */
public suspend inline fun ServiceQuotasClient.listServiceQuotas(crossinline block: ListServiceQuotasRequest.Builder.() -> Unit): ListServiceQuotasResponse = listServiceQuotas(ListServiceQuotasRequest.Builder().apply(block).build())

/**
 * Lists the names and codes for the services integrated with Service Quotas.
 */
public suspend inline fun ServiceQuotasClient.listServices(crossinline block: ListServicesRequest.Builder.() -> Unit): ListServicesResponse = listServices(ListServicesRequest.Builder().apply(block).build())

/**
 * Returns a list of the tags assigned to the specified applied quota.
 */
public suspend inline fun ServiceQuotasClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds a quota increase request to your quota request template.
 */
public suspend inline fun ServiceQuotasClient.putServiceQuotaIncreaseRequestIntoTemplate(crossinline block: PutServiceQuotaIncreaseRequestIntoTemplateRequest.Builder.() -> Unit): PutServiceQuotaIncreaseRequestIntoTemplateResponse = putServiceQuotaIncreaseRequestIntoTemplate(PutServiceQuotaIncreaseRequestIntoTemplateRequest.Builder().apply(block).build())

/**
 * Submits a quota increase request for the specified quota.
 */
public suspend inline fun ServiceQuotasClient.requestServiceQuotaIncrease(crossinline block: RequestServiceQuotaIncreaseRequest.Builder.() -> Unit): RequestServiceQuotaIncreaseResponse = requestServiceQuotaIncrease(RequestServiceQuotaIncreaseRequest.Builder().apply(block).build())

/**
 * Adds tags to the specified applied quota. You can include one or more tags to add to the quota.
 */
public suspend inline fun ServiceQuotasClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from the specified applied quota. You can specify one or more tags to remove.
 */
public suspend inline fun ServiceQuotasClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
