// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicequotas

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.servicequotas.model.*
import aws.sdk.kotlin.services.servicequotas.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Service Quotas"
public const val ServiceApiVersion: String = "2019-06-24"
public const val SdkVersion: String = "0.17.9-beta"

internal class DefaultServiceQuotasClient(override val config: ServiceQuotasClient.Config) : ServiceQuotasClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Associates your quota request template with your organization. When a new account is created in your organization, the quota increase requests in the template are automatically applied to the account. You can add a quota increase request for any adjustable quota to your template.
     */
    override suspend fun associateServiceQuotaTemplate(input: AssociateServiceQuotaTemplateRequest): AssociateServiceQuotaTemplateResponse {
        val op = SdkHttpOperation.build<AssociateServiceQuotaTemplateRequest, AssociateServiceQuotaTemplateResponse> {
            serializer = AssociateServiceQuotaTemplateOperationSerializer()
            deserializer = AssociateServiceQuotaTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateServiceQuotaTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ServiceQuotasV20190624", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicequotas"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the quota increase request for the specified quota from your quota request template.
     */
    override suspend fun deleteServiceQuotaIncreaseRequestFromTemplate(input: DeleteServiceQuotaIncreaseRequestFromTemplateRequest): DeleteServiceQuotaIncreaseRequestFromTemplateResponse {
        val op = SdkHttpOperation.build<DeleteServiceQuotaIncreaseRequestFromTemplateRequest, DeleteServiceQuotaIncreaseRequestFromTemplateResponse> {
            serializer = DeleteServiceQuotaIncreaseRequestFromTemplateOperationSerializer()
            deserializer = DeleteServiceQuotaIncreaseRequestFromTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteServiceQuotaIncreaseRequestFromTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ServiceQuotasV20190624", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicequotas"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables your quota request template. After a template is disabled, the quota increase requests in the template are not applied to new accounts in your organization. Disabling a quota request template does not apply its quota increase requests.
     */
    override suspend fun disassociateServiceQuotaTemplate(input: DisassociateServiceQuotaTemplateRequest): DisassociateServiceQuotaTemplateResponse {
        val op = SdkHttpOperation.build<DisassociateServiceQuotaTemplateRequest, DisassociateServiceQuotaTemplateResponse> {
            serializer = DisassociateServiceQuotaTemplateOperationSerializer()
            deserializer = DisassociateServiceQuotaTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateServiceQuotaTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ServiceQuotasV20190624", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicequotas"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the status of the association for the quota request template.
     */
    override suspend fun getAssociationForServiceQuotaTemplate(input: GetAssociationForServiceQuotaTemplateRequest): GetAssociationForServiceQuotaTemplateResponse {
        val op = SdkHttpOperation.build<GetAssociationForServiceQuotaTemplateRequest, GetAssociationForServiceQuotaTemplateResponse> {
            serializer = GetAssociationForServiceQuotaTemplateOperationSerializer()
            deserializer = GetAssociationForServiceQuotaTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAssociationForServiceQuotaTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ServiceQuotasV20190624", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicequotas"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the default value for the specified quota. The default value does not reflect any quota increases.
     */
    override suspend fun getAwsDefaultServiceQuota(input: GetAwsDefaultServiceQuotaRequest): GetAwsDefaultServiceQuotaResponse {
        val op = SdkHttpOperation.build<GetAwsDefaultServiceQuotaRequest, GetAwsDefaultServiceQuotaResponse> {
            serializer = GetAWSDefaultServiceQuotaOperationSerializer()
            deserializer = GetAWSDefaultServiceQuotaOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAWSDefaultServiceQuota"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ServiceQuotasV20190624", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicequotas"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the specified quota increase request.
     */
    override suspend fun getRequestedServiceQuotaChange(input: GetRequestedServiceQuotaChangeRequest): GetRequestedServiceQuotaChangeResponse {
        val op = SdkHttpOperation.build<GetRequestedServiceQuotaChangeRequest, GetRequestedServiceQuotaChangeResponse> {
            serializer = GetRequestedServiceQuotaChangeOperationSerializer()
            deserializer = GetRequestedServiceQuotaChangeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRequestedServiceQuotaChange"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ServiceQuotasV20190624", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicequotas"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the applied quota value for the specified quota. For some quotas, only the default values are available. If the applied quota value is not available for a quota, the quota is not retrieved.
     */
    override suspend fun getServiceQuota(input: GetServiceQuotaRequest): GetServiceQuotaResponse {
        val op = SdkHttpOperation.build<GetServiceQuotaRequest, GetServiceQuotaResponse> {
            serializer = GetServiceQuotaOperationSerializer()
            deserializer = GetServiceQuotaOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetServiceQuota"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ServiceQuotasV20190624", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicequotas"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the specified quota increase request in your quota request template.
     */
    override suspend fun getServiceQuotaIncreaseRequestFromTemplate(input: GetServiceQuotaIncreaseRequestFromTemplateRequest): GetServiceQuotaIncreaseRequestFromTemplateResponse {
        val op = SdkHttpOperation.build<GetServiceQuotaIncreaseRequestFromTemplateRequest, GetServiceQuotaIncreaseRequestFromTemplateResponse> {
            serializer = GetServiceQuotaIncreaseRequestFromTemplateOperationSerializer()
            deserializer = GetServiceQuotaIncreaseRequestFromTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetServiceQuotaIncreaseRequestFromTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ServiceQuotasV20190624", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicequotas"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the default values for the quotas for the specified AWS service. A default value does not reflect any quota increases.
     */
    override suspend fun listAwsDefaultServiceQuotas(input: ListAwsDefaultServiceQuotasRequest): ListAwsDefaultServiceQuotasResponse {
        val op = SdkHttpOperation.build<ListAwsDefaultServiceQuotasRequest, ListAwsDefaultServiceQuotasResponse> {
            serializer = ListAWSDefaultServiceQuotasOperationSerializer()
            deserializer = ListAWSDefaultServiceQuotasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAWSDefaultServiceQuotas"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ServiceQuotasV20190624", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicequotas"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the quota increase requests for the specified service.
     */
    override suspend fun listRequestedServiceQuotaChangeHistory(input: ListRequestedServiceQuotaChangeHistoryRequest): ListRequestedServiceQuotaChangeHistoryResponse {
        val op = SdkHttpOperation.build<ListRequestedServiceQuotaChangeHistoryRequest, ListRequestedServiceQuotaChangeHistoryResponse> {
            serializer = ListRequestedServiceQuotaChangeHistoryOperationSerializer()
            deserializer = ListRequestedServiceQuotaChangeHistoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRequestedServiceQuotaChangeHistory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ServiceQuotasV20190624", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicequotas"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the quota increase requests for the specified quota.
     */
    override suspend fun listRequestedServiceQuotaChangeHistoryByQuota(input: ListRequestedServiceQuotaChangeHistoryByQuotaRequest): ListRequestedServiceQuotaChangeHistoryByQuotaResponse {
        val op = SdkHttpOperation.build<ListRequestedServiceQuotaChangeHistoryByQuotaRequest, ListRequestedServiceQuotaChangeHistoryByQuotaResponse> {
            serializer = ListRequestedServiceQuotaChangeHistoryByQuotaOperationSerializer()
            deserializer = ListRequestedServiceQuotaChangeHistoryByQuotaOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRequestedServiceQuotaChangeHistoryByQuota"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ServiceQuotasV20190624", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicequotas"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the quota increase requests in the specified quota request template.
     */
    override suspend fun listServiceQuotaIncreaseRequestsInTemplate(input: ListServiceQuotaIncreaseRequestsInTemplateRequest): ListServiceQuotaIncreaseRequestsInTemplateResponse {
        val op = SdkHttpOperation.build<ListServiceQuotaIncreaseRequestsInTemplateRequest, ListServiceQuotaIncreaseRequestsInTemplateResponse> {
            serializer = ListServiceQuotaIncreaseRequestsInTemplateOperationSerializer()
            deserializer = ListServiceQuotaIncreaseRequestsInTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListServiceQuotaIncreaseRequestsInTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ServiceQuotasV20190624", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicequotas"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the applied quota values for the specified AWS service. For some quotas, only the default values are available. If the applied quota value is not available for a quota, the quota is not retrieved.
     */
    override suspend fun listServiceQuotas(input: ListServiceQuotasRequest): ListServiceQuotasResponse {
        val op = SdkHttpOperation.build<ListServiceQuotasRequest, ListServiceQuotasResponse> {
            serializer = ListServiceQuotasOperationSerializer()
            deserializer = ListServiceQuotasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListServiceQuotas"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ServiceQuotasV20190624", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicequotas"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the names and codes for the services integrated with Service Quotas.
     */
    override suspend fun listServices(input: ListServicesRequest): ListServicesResponse {
        val op = SdkHttpOperation.build<ListServicesRequest, ListServicesResponse> {
            serializer = ListServicesOperationSerializer()
            deserializer = ListServicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListServices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ServiceQuotasV20190624", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicequotas"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the tags assigned to the specified applied quota.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ServiceQuotasV20190624", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicequotas"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a quota increase request to your quota request template.
     */
    override suspend fun putServiceQuotaIncreaseRequestIntoTemplate(input: PutServiceQuotaIncreaseRequestIntoTemplateRequest): PutServiceQuotaIncreaseRequestIntoTemplateResponse {
        val op = SdkHttpOperation.build<PutServiceQuotaIncreaseRequestIntoTemplateRequest, PutServiceQuotaIncreaseRequestIntoTemplateResponse> {
            serializer = PutServiceQuotaIncreaseRequestIntoTemplateOperationSerializer()
            deserializer = PutServiceQuotaIncreaseRequestIntoTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutServiceQuotaIncreaseRequestIntoTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ServiceQuotasV20190624", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicequotas"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Submits a quota increase request for the specified quota.
     */
    override suspend fun requestServiceQuotaIncrease(input: RequestServiceQuotaIncreaseRequest): RequestServiceQuotaIncreaseResponse {
        val op = SdkHttpOperation.build<RequestServiceQuotaIncreaseRequest, RequestServiceQuotaIncreaseResponse> {
            serializer = RequestServiceQuotaIncreaseOperationSerializer()
            deserializer = RequestServiceQuotaIncreaseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RequestServiceQuotaIncrease"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ServiceQuotasV20190624", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicequotas"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds tags to the specified applied quota. You can include one or more tags to add to the quota.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ServiceQuotasV20190624", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicequotas"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes tags from the specified applied quota. You can specify one or more tags to remove.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ServiceQuotasV20190624", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicequotas"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "servicequotas")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
