// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.serde

import aws.sdk.kotlin.services.servicediscovery.model.ServiceDiscoveryException
import aws.sdk.kotlin.services.servicediscovery.model.UpdateInstanceCustomHealthStatusResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateInstanceCustomHealthStatusOperationDeserializer: HttpDeserializer.NonStreaming<UpdateInstanceCustomHealthStatusResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateInstanceCustomHealthStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateInstanceCustomHealthStatusError(context, call, payload)
        }
        val builder = UpdateInstanceCustomHealthStatusResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateInstanceCustomHealthStatusError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceDiscoveryException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedCall, payload)
        "InstanceNotFound" -> InstanceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceNotFound" -> ServiceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        "CustomHealthNotFound" -> CustomHealthNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> ServiceDiscoveryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
