// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.serde

import aws.sdk.kotlin.services.servicediscovery.model.DiscoverInstancesResponse
import aws.sdk.kotlin.services.servicediscovery.model.HttpInstanceSummary
import aws.sdk.kotlin.services.servicediscovery.model.ServiceDiscoveryException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DiscoverInstancesOperationDeserializer: HttpDeserializer.NonStreaming<DiscoverInstancesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DiscoverInstancesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDiscoverInstancesError(context, call, payload)
        }
        val builder = DiscoverInstancesResponse.Builder()

        if (payload != null) {
            deserializeDiscoverInstancesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDiscoverInstancesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceDiscoveryException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceNotFound" -> ServiceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        "RequestLimitExceeded" -> RequestLimitExceededDeserializer().deserialize(context, wrappedCall, payload)
        "NamespaceNotFound" -> NamespaceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> ServiceDiscoveryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDiscoverInstancesOperationBody(builder: DiscoverInstancesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INSTANCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Instances"))
    val INSTANCESREVISION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("InstancesRevision"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INSTANCES_DESCRIPTOR)
        field(INSTANCESREVISION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INSTANCES_DESCRIPTOR.index -> builder.instances =
                    deserializer.deserializeList(INSTANCES_DESCRIPTOR) {
                        val col0 = mutableListOf<HttpInstanceSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeHttpInstanceSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INSTANCESREVISION_DESCRIPTOR.index -> builder.instancesRevision = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
