// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.serde

import aws.sdk.kotlin.services.servicediscovery.model.DeregisterInstanceResponse
import aws.sdk.kotlin.services.servicediscovery.model.ServiceDiscoveryException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeregisterInstanceOperationDeserializer: HttpDeserializer.NonStreaming<DeregisterInstanceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeregisterInstanceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeregisterInstanceError(context, call, payload)
        }
        val builder = DeregisterInstanceResponse.Builder()

        if (payload != null) {
            deserializeDeregisterInstanceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeregisterInstanceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceDiscoveryException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedCall, payload)
        "InstanceNotFound" -> InstanceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceInUse" -> ResourceInUseDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceNotFound" -> ServiceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        "DuplicateRequest" -> DuplicateRequestDeserializer().deserialize(context, wrappedCall, payload)
        else -> ServiceDiscoveryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeregisterInstanceOperationBody(builder: DeregisterInstanceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val OPERATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OperationId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(OPERATIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                OPERATIONID_DESCRIPTOR.index -> builder.operationId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
