// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A complex type that identifies the namespaces that you want to list. You can choose to list public or private namespaces.
 */
public class NamespaceFilter private constructor(builder: Builder) {
    /**
     * Specify the operator that you want to use to determine whether a namespace matches the specified value. Valid values for `Condition` are one of the following.
     * + `EQ`: When you specify `EQ` for `Condition`, you can specify only one value. `EQ` is supported for `TYPE`, `NAME`, and `HTTP_NAME`. `EQ` is the default condition and can be omitted.
     * + `BEGINS_WITH`: When you specify `BEGINS_WITH` for `Condition`, you can specify only one value. `BEGINS_WITH` is supported for `TYPE`, `NAME`, and `HTTP_NAME`.
     */
    public val condition: aws.sdk.kotlin.services.servicediscovery.model.FilterCondition? = builder.condition
    /**
     * Specify the namespaces that you want to get using one of the following.
     * + `TYPE`: Gets the namespaces of the specified type.
     * + `NAME`: Gets the namespaces with the specified name.
     * + `HTTP_NAME`: Gets the namespaces with the specified HTTP name.
     */
    public val name: aws.sdk.kotlin.services.servicediscovery.model.NamespaceFilterName = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Specify the values that are applicable to the value that you specify for `Name`.
     * + `TYPE`: Specify `HTTP`, `DNS_PUBLIC`, or `DNS_PRIVATE`.
     * + `NAME`: Specify the name of the namespace, which is found in `Namespace.Name`.
     * + `HTTP_NAME`: Specify the HTTP name of the namespace, which is found in `Namespace.Properties.HttpProperties.HttpName`.
     */
    public val values: List<String> = requireNotNull(builder.values) { "A non-null value must be provided for values" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicediscovery.model.NamespaceFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NamespaceFilter(")
        append("condition=$condition,")
        append("name=$name,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = condition?.hashCode() ?: 0
        result = 31 * result + (name.hashCode())
        result = 31 * result + (values.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NamespaceFilter

        if (condition != other.condition) return false
        if (name != other.name) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicediscovery.model.NamespaceFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specify the operator that you want to use to determine whether a namespace matches the specified value. Valid values for `Condition` are one of the following.
         * + `EQ`: When you specify `EQ` for `Condition`, you can specify only one value. `EQ` is supported for `TYPE`, `NAME`, and `HTTP_NAME`. `EQ` is the default condition and can be omitted.
         * + `BEGINS_WITH`: When you specify `BEGINS_WITH` for `Condition`, you can specify only one value. `BEGINS_WITH` is supported for `TYPE`, `NAME`, and `HTTP_NAME`.
         */
        public var condition: aws.sdk.kotlin.services.servicediscovery.model.FilterCondition? = null
        /**
         * Specify the namespaces that you want to get using one of the following.
         * + `TYPE`: Gets the namespaces of the specified type.
         * + `NAME`: Gets the namespaces with the specified name.
         * + `HTTP_NAME`: Gets the namespaces with the specified HTTP name.
         */
        public var name: aws.sdk.kotlin.services.servicediscovery.model.NamespaceFilterName? = null
        /**
         * Specify the values that are applicable to the value that you specify for `Name`.
         * + `TYPE`: Specify `HTTP`, `DNS_PUBLIC`, or `DNS_PRIVATE`.
         * + `NAME`: Specify the name of the namespace, which is found in `Namespace.Name`.
         * + `HTTP_NAME`: Specify the HTTP name of the namespace, which is found in `Namespace.Properties.HttpProperties.HttpName`.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicediscovery.model.NamespaceFilter) : this() {
            this.condition = x.condition
            this.name = x.name
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicediscovery.model.NamespaceFilter = NamespaceFilter(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = NamespaceFilterName.SdkUnknown("no value provided")
            if (values == null) values = emptyList()
            return this
        }
    }
}
