// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListServicesRequest private constructor(builder: Builder) {
    /**
     * A complex type that contains specifications for the namespaces that you want to list services for.
     *
     * If you specify more than one filter, an operation must match all filters to be returned by `ListServices`.
     */
    public val filters: List<ServiceFilter>? = builder.filters
    /**
     * The maximum number of services that you want Cloud Map to return in the response to a `ListServices` request. If you don't specify a value for `MaxResults`, Cloud Map returns up to 100 services.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * For the first `ListServices` request, omit this value.
     *
     * If the response contains `NextToken`, submit another `ListServices` request to get the next group of results. Specify the value of `NextToken` from the previous response in the next request.
     *
     * Cloud Map gets `MaxResults` services and then filters them based on the specified criteria. It's possible that no services in the first `MaxResults` services matched the specified criteria but that subsequent groups of `MaxResults` services do contain services that match the criteria.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicediscovery.model.ListServicesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListServicesRequest(")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListServicesRequest

        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicediscovery.model.ListServicesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A complex type that contains specifications for the namespaces that you want to list services for.
         *
         * If you specify more than one filter, an operation must match all filters to be returned by `ListServices`.
         */
        public var filters: List<ServiceFilter>? = null
        /**
         * The maximum number of services that you want Cloud Map to return in the response to a `ListServices` request. If you don't specify a value for `MaxResults`, Cloud Map returns up to 100 services.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * For the first `ListServices` request, omit this value.
         *
         * If the response contains `NextToken`, submit another `ListServices` request to get the next group of results. Specify the value of `NextToken` from the previous response in the next request.
         *
         * Cloud Map gets `MaxResults` services and then filters them based on the specified criteria. It's possible that no services in the first `MaxResults` services matched the specified criteria but that subsequent groups of `MaxResults` services do contain services that match the criteria.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicediscovery.model.ListServicesRequest) : this() {
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicediscovery.model.ListServicesRequest = ListServicesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
