// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A complex type that contains information about the instances that you registered by using a specified service.
 */
public class InstanceSummary private constructor(builder: Builder) {
    /**
     * A string map that contains the following information:
     * + The attributes that are associated with the instance.
     * + For each attribute, the applicable value.
     *
     * Supported attribute keys include the following:
     *
     * ## AWS_ALIAS_DNS_NAME
     * For an alias record that routes traffic to an Elastic Load Balancing load balancer, the DNS name that's associated with the load balancer.
     *
     * ## AWS_EC2_INSTANCE_ID (HTTP namespaces only)
     * The Amazon EC2 instance ID for the instance. When the `AWS_EC2_INSTANCE_ID` attribute is specified, then the `AWS_INSTANCE_IPV4` attribute contains the primary private IPv4 address.
     *
     * ## AWS_INIT_HEALTH_STATUS
     * If the service configuration includes `HealthCheckCustomConfig`, you can optionally use `AWS_INIT_HEALTH_STATUS` to specify the initial status of the custom health check, `HEALTHY` or `UNHEALTHY`. If you don't specify a value for `AWS_INIT_HEALTH_STATUS`, the initial status is `HEALTHY`.
     *
     * ## AWS_INSTANCE_CNAME
     * For a `CNAME` record, the domain name that Route 53 returns in response to DNS queries (for example, `example.com`).
     *
     * ## AWS_INSTANCE_IPV4
     * For an `A` record, the IPv4 address that Route 53 returns in response to DNS queries (for example, `192.0.2.44`).
     *
     * ## AWS_INSTANCE_IPV6
     * For an `AAAA` record, the IPv6 address that Route 53 returns in response to DNS queries (for example, `2001:0db8:85a3:0000:0000:abcd:0001:2345`).
     *
     * ## AWS_INSTANCE_PORT
     * For an `SRV` record, the value that Route 53 returns for the port. In addition, if the service includes `HealthCheckConfig`, the port on the endpoint that Route 53 sends requests to.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * The ID for an instance that you created by using a specified service.
     */
    public val id: kotlin.String? = builder.id

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicediscovery.model.InstanceSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceSummary(")
        append("attributes=$attributes,")
        append("id=$id")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceSummary

        if (attributes != other.attributes) return false
        if (id != other.id) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicediscovery.model.InstanceSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A string map that contains the following information:
         * + The attributes that are associated with the instance.
         * + For each attribute, the applicable value.
         *
         * Supported attribute keys include the following:
         *
         * ## AWS_ALIAS_DNS_NAME
         * For an alias record that routes traffic to an Elastic Load Balancing load balancer, the DNS name that's associated with the load balancer.
         *
         * ## AWS_EC2_INSTANCE_ID (HTTP namespaces only)
         * The Amazon EC2 instance ID for the instance. When the `AWS_EC2_INSTANCE_ID` attribute is specified, then the `AWS_INSTANCE_IPV4` attribute contains the primary private IPv4 address.
         *
         * ## AWS_INIT_HEALTH_STATUS
         * If the service configuration includes `HealthCheckCustomConfig`, you can optionally use `AWS_INIT_HEALTH_STATUS` to specify the initial status of the custom health check, `HEALTHY` or `UNHEALTHY`. If you don't specify a value for `AWS_INIT_HEALTH_STATUS`, the initial status is `HEALTHY`.
         *
         * ## AWS_INSTANCE_CNAME
         * For a `CNAME` record, the domain name that Route 53 returns in response to DNS queries (for example, `example.com`).
         *
         * ## AWS_INSTANCE_IPV4
         * For an `A` record, the IPv4 address that Route 53 returns in response to DNS queries (for example, `192.0.2.44`).
         *
         * ## AWS_INSTANCE_IPV6
         * For an `AAAA` record, the IPv6 address that Route 53 returns in response to DNS queries (for example, `2001:0db8:85a3:0000:0000:abcd:0001:2345`).
         *
         * ## AWS_INSTANCE_PORT
         * For an `SRV` record, the value that Route 53 returns for the port. In addition, if the service includes `HealthCheckConfig`, the port on the endpoint that Route 53 sends requests to.
         */
        public var attributes: Map<String, String>? = null
        /**
         * The ID for an instance that you created by using a specified service.
         */
        public var id: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicediscovery.model.InstanceSummary) : this() {
            this.attributes = x.attributes
            this.id = x.id
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicediscovery.model.InstanceSummary = InstanceSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
