// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * In a response to a [DiscoverInstances](https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html) request, `HttpInstanceSummary` contains information about one instance that matches the values that you specified in the request.
 */
public class HttpInstanceSummary private constructor(builder: Builder) {
    /**
     * If you included any attributes when you registered the instance, the values of those attributes.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * If you configured health checking in the service, the current health status of the service instance.
     */
    public val healthStatus: aws.sdk.kotlin.services.servicediscovery.model.HealthStatus? = builder.healthStatus
    /**
     * The ID of an instance that matches the values that you specified in the request.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * ``````
     *
     * The `HttpName` name of the namespace. It's found in the `HttpProperties` member of the `Properties` member of the namespace.
     */
    public val namespaceName: kotlin.String? = builder.namespaceName
    /**
     * The name of the service that you specified when you registered the instance.
     */
    public val serviceName: kotlin.String? = builder.serviceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicediscovery.model.HttpInstanceSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HttpInstanceSummary(")
        append("attributes=$attributes,")
        append("healthStatus=$healthStatus,")
        append("instanceId=$instanceId,")
        append("namespaceName=$namespaceName,")
        append("serviceName=$serviceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (healthStatus?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (namespaceName?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HttpInstanceSummary

        if (attributes != other.attributes) return false
        if (healthStatus != other.healthStatus) return false
        if (instanceId != other.instanceId) return false
        if (namespaceName != other.namespaceName) return false
        if (serviceName != other.serviceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicediscovery.model.HttpInstanceSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * If you included any attributes when you registered the instance, the values of those attributes.
         */
        public var attributes: Map<String, String>? = null
        /**
         * If you configured health checking in the service, the current health status of the service instance.
         */
        public var healthStatus: aws.sdk.kotlin.services.servicediscovery.model.HealthStatus? = null
        /**
         * The ID of an instance that matches the values that you specified in the request.
         */
        public var instanceId: kotlin.String? = null
        /**
         * ``````
         *
         * The `HttpName` name of the namespace. It's found in the `HttpProperties` member of the `Properties` member of the namespace.
         */
        public var namespaceName: kotlin.String? = null
        /**
         * The name of the service that you specified when you registered the instance.
         */
        public var serviceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicediscovery.model.HttpInstanceSummary) : this() {
            this.attributes = x.attributes
            this.healthStatus = x.healthStatus
            this.instanceId = x.instanceId
            this.namespaceName = x.namespaceName
            this.serviceName = x.serviceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicediscovery.model.HttpInstanceSummary = HttpInstanceSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
