// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A complex type that contains information about the Route 53 DNS records that you want Cloud Map to create when you register an instance.
 */
public class DnsRecord private constructor(builder: Builder) {
    /**
     * The amount of time, in seconds, that you want DNS resolvers to cache the settings for this record.
     *
     * Alias records don't include a TTL because Route 53 uses the TTL for the Amazon Web Services resource that an alias record routes traffic to. If you include the `AWS_ALIAS_DNS_NAME` attribute when you submit a [RegisterInstance](https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html) request, the `TTL` value is ignored. Always specify a TTL for the service; you can use a service to register instances that create either alias or non-alias records.
     */
    public val ttl: kotlin.Long = requireNotNull(builder.ttl) { "A non-null value must be provided for ttl" }
    /**
     * The type of the resource, which indicates the type of value that Route 53 returns in response to DNS queries. You can specify values for `Type` in the following combinations:
     * + **`A`**
     * + **`AAAA`**
     * + **`A`** and **`AAAA`**
     * + **`SRV`**
     * + **`CNAME`**
     *
     * If you want Cloud Map to create a Route 53 alias record when you register an instance, specify `A` or `AAAA` for `Type`.
     *
     * You specify other settings, such as the IP address for `A` and `AAAA` records, when you register an instance. For more information, see [RegisterInstance](https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html).
     *
     * The following values are supported:
     *
     * ## A
     * Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.
     *
     * ## AAAA
     * Route 53 returns the IP address of the resource in IPv6 format, such as 2001:0db8:85a3:0000:0000:abcd:0001:2345.
     *
     * ## CNAME
     * Route 53 returns the domain name of the resource, such as www.example.com. Note the following:
     * + You specify the domain name that you want to route traffic to when you register an instance. For more information, see [Attributes](https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html#cloudmap-RegisterInstance-request-Attributes) in the topic [RegisterInstance](https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html).
     * + You must specify `WEIGHTED` for the value of `RoutingPolicy`.
     * + You can't specify both `CNAME` for `Type` and settings for `HealthCheckConfig`. If you do, the request will fail with an `InvalidInput` error.
     *
     * ## SRV
     * Route 53 returns the value for an `SRV` record. The value for an `SRV` record uses the following values:
     *
     * `priority weight port service-hostname`
     *
     * Note the following about the values:
     * + The values of `priority` and `weight` are both set to `1` and can't be changed.
     * + The value of `port` comes from the value that you specify for the `AWS_INSTANCE_PORT` attribute when you submit a [RegisterInstance](https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html) request.
     * + The value of `service-hostname` is a concatenation of the following values:
     *    + The value that you specify for `InstanceId` when you register an instance.
     *    + The name of the service.
     *    + The name of the namespace.
     * For example, if the value of `InstanceId` is `test`, the name of the service is `backend`, and the name of the namespace is `example.com`, the value of `service-hostname` is the following:`test.backend.example.com`
     * If you specify settings for an `SRV` record, note the following:
     * + If you specify values for `AWS_INSTANCE_IPV4`, `AWS_INSTANCE_IPV6`, or both in the `RegisterInstance` request, Cloud Map automatically creates `A` and/or `AAAA` records that have the same name as the value of `service-hostname` in the `SRV` record. You can ignore these records.
     * + If you're using a system that requires a specific `SRV` format, such as HAProxy, see the [Name](https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html#cloudmap-CreateService-request-Name) element in the documentation about `CreateService` for information about how to specify the correct name format.
     */
    public val type: aws.sdk.kotlin.services.servicediscovery.model.RecordType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicediscovery.model.DnsRecord = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DnsRecord(")
        append("ttl=$ttl,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ttl.hashCode()
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DnsRecord

        if (ttl != other.ttl) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicediscovery.model.DnsRecord = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The amount of time, in seconds, that you want DNS resolvers to cache the settings for this record.
         *
         * Alias records don't include a TTL because Route 53 uses the TTL for the Amazon Web Services resource that an alias record routes traffic to. If you include the `AWS_ALIAS_DNS_NAME` attribute when you submit a [RegisterInstance](https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html) request, the `TTL` value is ignored. Always specify a TTL for the service; you can use a service to register instances that create either alias or non-alias records.
         */
        public var ttl: kotlin.Long? = null
        /**
         * The type of the resource, which indicates the type of value that Route 53 returns in response to DNS queries. You can specify values for `Type` in the following combinations:
         * + **`A`**
         * + **`AAAA`**
         * + **`A`** and **`AAAA`**
         * + **`SRV`**
         * + **`CNAME`**
         *
         * If you want Cloud Map to create a Route 53 alias record when you register an instance, specify `A` or `AAAA` for `Type`.
         *
         * You specify other settings, such as the IP address for `A` and `AAAA` records, when you register an instance. For more information, see [RegisterInstance](https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html).
         *
         * The following values are supported:
         *
         * ## A
         * Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.
         *
         * ## AAAA
         * Route 53 returns the IP address of the resource in IPv6 format, such as 2001:0db8:85a3:0000:0000:abcd:0001:2345.
         *
         * ## CNAME
         * Route 53 returns the domain name of the resource, such as www.example.com. Note the following:
         * + You specify the domain name that you want to route traffic to when you register an instance. For more information, see [Attributes](https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html#cloudmap-RegisterInstance-request-Attributes) in the topic [RegisterInstance](https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html).
         * + You must specify `WEIGHTED` for the value of `RoutingPolicy`.
         * + You can't specify both `CNAME` for `Type` and settings for `HealthCheckConfig`. If you do, the request will fail with an `InvalidInput` error.
         *
         * ## SRV
         * Route 53 returns the value for an `SRV` record. The value for an `SRV` record uses the following values:
         *
         * `priority weight port service-hostname`
         *
         * Note the following about the values:
         * + The values of `priority` and `weight` are both set to `1` and can't be changed.
         * + The value of `port` comes from the value that you specify for the `AWS_INSTANCE_PORT` attribute when you submit a [RegisterInstance](https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html) request.
         * + The value of `service-hostname` is a concatenation of the following values:
         *    + The value that you specify for `InstanceId` when you register an instance.
         *    + The name of the service.
         *    + The name of the namespace.
         * For example, if the value of `InstanceId` is `test`, the name of the service is `backend`, and the name of the namespace is `example.com`, the value of `service-hostname` is the following:`test.backend.example.com`
         * If you specify settings for an `SRV` record, note the following:
         * + If you specify values for `AWS_INSTANCE_IPV4`, `AWS_INSTANCE_IPV6`, or both in the `RegisterInstance` request, Cloud Map automatically creates `A` and/or `AAAA` records that have the same name as the value of `service-hostname` in the `SRV` record. You can ignore these records.
         * + If you're using a system that requires a specific `SRV` format, such as HAProxy, see the [Name](https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html#cloudmap-CreateService-request-Name) element in the documentation about `CreateService` for information about how to specify the correct name format.
         */
        public var type: aws.sdk.kotlin.services.servicediscovery.model.RecordType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicediscovery.model.DnsRecord) : this() {
            this.ttl = x.ttl
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicediscovery.model.DnsRecord = DnsRecord(this)

        internal fun correctErrors(): Builder {
            if (ttl == null) ttl = 0L
            if (type == null) type = RecordType.SdkUnknown("no value provided")
            return this
        }
    }
}
