// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateServiceRequest private constructor(builder: Builder) {
    /**
     * A unique string that identifies the request and that allows failed `CreateService` requests to be retried without the risk of running the operation twice. `CreatorRequestId` can be any unique string (for example, a date/timestamp).
     */
    public val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * A description for the service.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A complex type that contains information about the Amazon Route 53 records that you want Cloud Map to create when you register an instance.
     */
    public val dnsConfig: aws.sdk.kotlin.services.servicediscovery.model.DnsConfig? = builder.dnsConfig
    /**
     * *Public DNS and HTTP namespaces only.* A complex type that contains settings for an optional Route 53 health check. If you specify settings for a health check, Cloud Map associates the health check with all the Route 53 DNS records that you specify in `DnsConfig`.
     *
     * If you specify a health check configuration, you can specify either `HealthCheckCustomConfig` or `HealthCheckConfig` but not both.
     *
     * For information about the charges for health checks, see [Cloud Map Pricing](http://aws.amazon.com/cloud-map/pricing/).
     */
    public val healthCheckConfig: aws.sdk.kotlin.services.servicediscovery.model.HealthCheckConfig? = builder.healthCheckConfig
    /**
     * A complex type that contains information about an optional custom health check.
     *
     * If you specify a health check configuration, you can specify either `HealthCheckCustomConfig` or `HealthCheckConfig` but not both.
     *
     * You can't add, update, or delete a `HealthCheckCustomConfig` configuration from an existing service.
     */
    public val healthCheckCustomConfig: aws.sdk.kotlin.services.servicediscovery.model.HealthCheckCustomConfig? = builder.healthCheckCustomConfig
    /**
     * The name that you want to assign to the service.
     *
     * Do not include sensitive information in the name if the namespace is discoverable by public DNS queries.
     *
     * If you want Cloud Map to create an `SRV` record when you register an instance and you're using a system that requires a specific `SRV` format, such as [HAProxy](http://www.haproxy.org/), specify the following for `Name`:
     * + Start the name with an underscore (_), such as `_exampleservice`.
     * + End the name with *._protocol*, such as `._tcp`.
     *
     * When you register an instance, Cloud Map creates an `SRV` record and assigns a name to the record by concatenating the service name and the namespace name (for example,
     *
     * `_exampleservice._tcp.example.com`).
     *
     * For services that are accessible by DNS queries, you can't create multiple services with names that differ only by case (such as EXAMPLE and example). Otherwise, these services have the same DNS name and can't be distinguished. However, if you use a namespace that's only accessible by API calls, then you can create services that with names that differ only by case.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ID of the namespace that you want to use to create the service. The namespace ID must be specified, but it can be specified either here or in the `DnsConfig` object.
     */
    public val namespaceId: kotlin.String? = builder.namespaceId
    /**
     * The tags to add to the service. Each tag consists of a key and an optional value that you define. Tags keys can be up to 128 characters in length, and tag values can be up to 256 characters in length.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * If present, specifies that the service instances are only discoverable using the `DiscoverInstances` API operation. No DNS records is registered for the service instances. The only valid value is `HTTP`.
     */
    public val type: aws.sdk.kotlin.services.servicediscovery.model.ServiceTypeOption? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicediscovery.model.CreateServiceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateServiceRequest(")
        append("creatorRequestId=$creatorRequestId,")
        append("description=$description,")
        append("dnsConfig=$dnsConfig,")
        append("healthCheckConfig=$healthCheckConfig,")
        append("healthCheckCustomConfig=$healthCheckCustomConfig,")
        append("name=$name,")
        append("namespaceId=$namespaceId,")
        append("tags=$tags,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creatorRequestId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dnsConfig?.hashCode() ?: 0)
        result = 31 * result + (healthCheckConfig?.hashCode() ?: 0)
        result = 31 * result + (healthCheckCustomConfig?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (namespaceId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateServiceRequest

        if (creatorRequestId != other.creatorRequestId) return false
        if (description != other.description) return false
        if (dnsConfig != other.dnsConfig) return false
        if (healthCheckConfig != other.healthCheckConfig) return false
        if (healthCheckCustomConfig != other.healthCheckCustomConfig) return false
        if (name != other.name) return false
        if (namespaceId != other.namespaceId) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicediscovery.model.CreateServiceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique string that identifies the request and that allows failed `CreateService` requests to be retried without the risk of running the operation twice. `CreatorRequestId` can be any unique string (for example, a date/timestamp).
         */
        public var creatorRequestId: kotlin.String? = null
        /**
         * A description for the service.
         */
        public var description: kotlin.String? = null
        /**
         * A complex type that contains information about the Amazon Route 53 records that you want Cloud Map to create when you register an instance.
         */
        public var dnsConfig: aws.sdk.kotlin.services.servicediscovery.model.DnsConfig? = null
        /**
         * *Public DNS and HTTP namespaces only.* A complex type that contains settings for an optional Route 53 health check. If you specify settings for a health check, Cloud Map associates the health check with all the Route 53 DNS records that you specify in `DnsConfig`.
         *
         * If you specify a health check configuration, you can specify either `HealthCheckCustomConfig` or `HealthCheckConfig` but not both.
         *
         * For information about the charges for health checks, see [Cloud Map Pricing](http://aws.amazon.com/cloud-map/pricing/).
         */
        public var healthCheckConfig: aws.sdk.kotlin.services.servicediscovery.model.HealthCheckConfig? = null
        /**
         * A complex type that contains information about an optional custom health check.
         *
         * If you specify a health check configuration, you can specify either `HealthCheckCustomConfig` or `HealthCheckConfig` but not both.
         *
         * You can't add, update, or delete a `HealthCheckCustomConfig` configuration from an existing service.
         */
        public var healthCheckCustomConfig: aws.sdk.kotlin.services.servicediscovery.model.HealthCheckCustomConfig? = null
        /**
         * The name that you want to assign to the service.
         *
         * Do not include sensitive information in the name if the namespace is discoverable by public DNS queries.
         *
         * If you want Cloud Map to create an `SRV` record when you register an instance and you're using a system that requires a specific `SRV` format, such as [HAProxy](http://www.haproxy.org/), specify the following for `Name`:
         * + Start the name with an underscore (_), such as `_exampleservice`.
         * + End the name with *._protocol*, such as `._tcp`.
         *
         * When you register an instance, Cloud Map creates an `SRV` record and assigns a name to the record by concatenating the service name and the namespace name (for example,
         *
         * `_exampleservice._tcp.example.com`).
         *
         * For services that are accessible by DNS queries, you can't create multiple services with names that differ only by case (such as EXAMPLE and example). Otherwise, these services have the same DNS name and can't be distinguished. However, if you use a namespace that's only accessible by API calls, then you can create services that with names that differ only by case.
         */
        public var name: kotlin.String? = null
        /**
         * The ID of the namespace that you want to use to create the service. The namespace ID must be specified, but it can be specified either here or in the `DnsConfig` object.
         */
        public var namespaceId: kotlin.String? = null
        /**
         * The tags to add to the service. Each tag consists of a key and an optional value that you define. Tags keys can be up to 128 characters in length, and tag values can be up to 256 characters in length.
         */
        public var tags: List<Tag>? = null
        /**
         * If present, specifies that the service instances are only discoverable using the `DiscoverInstances` API operation. No DNS records is registered for the service instances. The only valid value is `HTTP`.
         */
        public var type: aws.sdk.kotlin.services.servicediscovery.model.ServiceTypeOption? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicediscovery.model.CreateServiceRequest) : this() {
            this.creatorRequestId = x.creatorRequestId
            this.description = x.description
            this.dnsConfig = x.dnsConfig
            this.healthCheckConfig = x.healthCheckConfig
            this.healthCheckCustomConfig = x.healthCheckCustomConfig
            this.name = x.name
            this.namespaceId = x.namespaceId
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicediscovery.model.CreateServiceRequest = CreateServiceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.servicediscovery.model.DnsConfig] inside the given [block]
         */
        public fun dnsConfig(block: aws.sdk.kotlin.services.servicediscovery.model.DnsConfig.Builder.() -> kotlin.Unit) {
            this.dnsConfig = aws.sdk.kotlin.services.servicediscovery.model.DnsConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.servicediscovery.model.HealthCheckConfig] inside the given [block]
         */
        public fun healthCheckConfig(block: aws.sdk.kotlin.services.servicediscovery.model.HealthCheckConfig.Builder.() -> kotlin.Unit) {
            this.healthCheckConfig = aws.sdk.kotlin.services.servicediscovery.model.HealthCheckConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.servicediscovery.model.HealthCheckCustomConfig] inside the given [block]
         */
        public fun healthCheckCustomConfig(block: aws.sdk.kotlin.services.servicediscovery.model.HealthCheckCustomConfig.Builder.() -> kotlin.Unit) {
            this.healthCheckCustomConfig = aws.sdk.kotlin.services.servicediscovery.model.HealthCheckCustomConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
