// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.serde

import aws.sdk.kotlin.services.servicediscovery.model.DiscoverInstancesRevisionResponse
import aws.sdk.kotlin.services.servicediscovery.model.ServiceDiscoveryException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DiscoverInstancesRevisionOperationDeserializer: HttpDeserialize<DiscoverInstancesRevisionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DiscoverInstancesRevisionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDiscoverInstancesRevisionError(context, call)
        }
        val builder = DiscoverInstancesRevisionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDiscoverInstancesRevisionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDiscoverInstancesRevisionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceDiscoveryException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedCall)
        "ServiceNotFound" -> ServiceNotFoundDeserializer().deserialize(context, wrappedCall)
        "RequestLimitExceeded" -> RequestLimitExceededDeserializer().deserialize(context, wrappedCall)
        "NamespaceNotFound" -> NamespaceNotFoundDeserializer().deserialize(context, wrappedCall)
        else -> ServiceDiscoveryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDiscoverInstancesRevisionOperationBody(builder: DiscoverInstancesRevisionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INSTANCESREVISION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("InstancesRevision"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INSTANCESREVISION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INSTANCESREVISION_DESCRIPTOR.index -> builder.instancesRevision = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
