// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A complex type that contains information about a specified operation.
 */
public class Operation private constructor(builder: Builder) {
    /**
     * The date and time that the request was submitted, in Unix date/time format and Coordinated Universal Time (UTC). The value of `CreateDate` is accurate to milliseconds. For example, the value `1516925490.087` represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * The code associated with `ErrorMessage`. Values for `ErrorCode` include the following:
     * + `ACCESS_DENIED`
     * + `CANNOT_CREATE_HOSTED_ZONE`
     * + `EXPIRED_TOKEN`
     * + `HOSTED_ZONE_NOT_FOUND`
     * + `INTERNAL_FAILURE`
     * + `INVALID_CHANGE_BATCH`
     * + `THROTTLED_REQUEST`
     */
    public val errorCode: kotlin.String? = builder.errorCode
    /**
     * If the value of `Status` is `FAIL`, the reason that the operation failed.
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * The ID of the operation that you want to get information about.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The status of the operation. Values include the following:
     *
     * ## SUBMITTED
     * This is the initial state that occurs immediately after you submit a request.
     *
     * ## PENDING
     * Cloud Map is performing the operation.
     *
     * ## SUCCESS
     * The operation succeeded.
     *
     * ## FAIL
     * The operation failed. For the failure reason, see `ErrorMessage`.
     */
    public val status: aws.sdk.kotlin.services.servicediscovery.model.OperationStatus? = builder.status
    /**
     * The name of the target entity that's associated with the operation:
     *
     * ## NAMESPACE
     * The namespace ID is returned in the `ResourceId` property.
     *
     * ## SERVICE
     * The service ID is returned in the `ResourceId` property.
     *
     * ## INSTANCE
     * The instance ID is returned in the `ResourceId` property.
     */
    public val targets: Map<String, String>? = builder.targets
    /**
     * The name of the operation that's associated with the specified ID.
     */
    public val type: aws.sdk.kotlin.services.servicediscovery.model.OperationType? = builder.type
    /**
     * The date and time that the value of `Status` changed to the current value, in Unix date/time format and Coordinated Universal Time (UTC). The value of `UpdateDate` is accurate to milliseconds. For example, the value `1516925490.087` represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val updateDate: aws.smithy.kotlin.runtime.time.Instant? = builder.updateDate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicediscovery.model.Operation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Operation(")
        append("createDate=$createDate,")
        append("errorCode=$errorCode,")
        append("errorMessage=$errorMessage,")
        append("id=$id,")
        append("status=$status,")
        append("targets=$targets,")
        append("type=$type,")
        append("updateDate=$updateDate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createDate?.hashCode() ?: 0
        result = 31 * result + (errorCode?.hashCode() ?: 0)
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (updateDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Operation

        if (createDate != other.createDate) return false
        if (errorCode != other.errorCode) return false
        if (errorMessage != other.errorMessage) return false
        if (id != other.id) return false
        if (status != other.status) return false
        if (targets != other.targets) return false
        if (type != other.type) return false
        if (updateDate != other.updateDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicediscovery.model.Operation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time that the request was submitted, in Unix date/time format and Coordinated Universal Time (UTC). The value of `CreateDate` is accurate to milliseconds. For example, the value `1516925490.087` represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The code associated with `ErrorMessage`. Values for `ErrorCode` include the following:
         * + `ACCESS_DENIED`
         * + `CANNOT_CREATE_HOSTED_ZONE`
         * + `EXPIRED_TOKEN`
         * + `HOSTED_ZONE_NOT_FOUND`
         * + `INTERNAL_FAILURE`
         * + `INVALID_CHANGE_BATCH`
         * + `THROTTLED_REQUEST`
         */
        public var errorCode: kotlin.String? = null
        /**
         * If the value of `Status` is `FAIL`, the reason that the operation failed.
         */
        public var errorMessage: kotlin.String? = null
        /**
         * The ID of the operation that you want to get information about.
         */
        public var id: kotlin.String? = null
        /**
         * The status of the operation. Values include the following:
         *
         * ## SUBMITTED
         * This is the initial state that occurs immediately after you submit a request.
         *
         * ## PENDING
         * Cloud Map is performing the operation.
         *
         * ## SUCCESS
         * The operation succeeded.
         *
         * ## FAIL
         * The operation failed. For the failure reason, see `ErrorMessage`.
         */
        public var status: aws.sdk.kotlin.services.servicediscovery.model.OperationStatus? = null
        /**
         * The name of the target entity that's associated with the operation:
         *
         * ## NAMESPACE
         * The namespace ID is returned in the `ResourceId` property.
         *
         * ## SERVICE
         * The service ID is returned in the `ResourceId` property.
         *
         * ## INSTANCE
         * The instance ID is returned in the `ResourceId` property.
         */
        public var targets: Map<String, String>? = null
        /**
         * The name of the operation that's associated with the specified ID.
         */
        public var type: aws.sdk.kotlin.services.servicediscovery.model.OperationType? = null
        /**
         * The date and time that the value of `Status` changed to the current value, in Unix date/time format and Coordinated Universal Time (UTC). The value of `UpdateDate` is accurate to milliseconds. For example, the value `1516925490.087` represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var updateDate: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicediscovery.model.Operation) : this() {
            this.createDate = x.createDate
            this.errorCode = x.errorCode
            this.errorMessage = x.errorMessage
            this.id = x.id
            this.status = x.status
            this.targets = x.targets
            this.type = x.type
            this.updateDate = x.updateDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicediscovery.model.Operation = Operation(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
