// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.model



public class ListNamespacesRequest private constructor(builder: Builder) {
    /**
     * A complex type that contains specifications for the namespaces that you want to list.
     *
     * If you specify more than one filter, a namespace must match all filters to be returned by `ListNamespaces`.
     */
    public val filters: List<NamespaceFilter>? = builder.filters
    /**
     * The maximum number of namespaces that you want Cloud Map to return in the response to a `ListNamespaces` request. If you don't specify a value for `MaxResults`, Cloud Map returns up to 100 namespaces.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * For the first `ListNamespaces` request, omit this value.
     *
     * If the response contains `NextToken`, submit another `ListNamespaces` request to get the next group of results. Specify the value of `NextToken` from the previous response in the next request.
     *
     * Cloud Map gets `MaxResults` namespaces and then filters them based on the specified criteria. It's possible that no namespaces in the first `MaxResults` namespaces matched the specified criteria but that subsequent groups of `MaxResults` namespaces do contain namespaces that match the criteria.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicediscovery.model.ListNamespacesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListNamespacesRequest(")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListNamespacesRequest

        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicediscovery.model.ListNamespacesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A complex type that contains specifications for the namespaces that you want to list.
         *
         * If you specify more than one filter, a namespace must match all filters to be returned by `ListNamespaces`.
         */
        public var filters: List<NamespaceFilter>? = null
        /**
         * The maximum number of namespaces that you want Cloud Map to return in the response to a `ListNamespaces` request. If you don't specify a value for `MaxResults`, Cloud Map returns up to 100 namespaces.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * For the first `ListNamespaces` request, omit this value.
         *
         * If the response contains `NextToken`, submit another `ListNamespaces` request to get the next group of results. Specify the value of `NextToken` from the previous response in the next request.
         *
         * Cloud Map gets `MaxResults` namespaces and then filters them based on the specified criteria. It's possible that no namespaces in the first `MaxResults` namespaces matched the specified criteria but that subsequent groups of `MaxResults` namespaces do contain namespaces that match the criteria.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicediscovery.model.ListNamespacesRequest) : this() {
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicediscovery.model.ListNamespacesRequest = ListNamespacesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
